/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.localizer.Generator;
import org.jvnet.localizer.Reporter;

public class GeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String fileMask;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String pkg = this.project.getPackaging();
        if (pkg != null && pkg.equals("pom")) {
            return;
        }
        Generator g = new Generator(this.outputDirectory, new Reporter(){

            public void debug(String msg) {
                GeneratorMojo.this.getLog().debug((CharSequence)msg);
            }
        });
        for (Resource res : this.project.getResources()) {
            File baseDir = new File(res.getDirectory());
            if (!baseDir.exists()) continue;
            FileSet fs = new FileSet();
            fs.setDir(baseDir);
            for (String name : res.getIncludes()) {
                fs.createInclude().setName(name);
            }
            for (String name : res.getExcludes()) {
                fs.createExclude().setName(name);
            }
            for (String relPath : fs.getDirectoryScanner(new Project()).getIncludedFiles()) {
                File f = new File(baseDir, relPath);
                if (!f.getName().endsWith(".properties") || f.getName().contains("_") || this.fileMask != null && !f.getName().equals(this.fileMask)) continue;
                try {
                    g.generate(f, relPath);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to generate a class from " + f, (Exception)e);
                }
            }
        }
        try {
            g.build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate source files", (Exception)e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }
}

