/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeUtil;
import org.popcraft.chunky.util.Version;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.lib.paperlib.PaperLib;

public class BorderCheckTask
implements Runnable {
    private ChunkyBorder chunkyBorder;

    public BorderCheckTask(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    @Override
    public void run() {
        for (Player player : this.chunkyBorder.getServer().getOnlinePlayers()) {
            Location newLoc;
            Shape border;
            BorderData borderData;
            Map<String, BorderData> borders = this.chunkyBorder.getBorders();
            World world = player.getWorld();
            if (borders == null || !borders.containsKey(world.getName()) || (borderData = borders.get(world.getName())) == null || (border = borderData.getBorder()) == null) continue;
            Location loc = player.getLocation();
            boolean currentLocationValid = border.isBounding(loc.getX(), loc.getZ());
            boolean lastLocationValid = this.chunkyBorder.getPlayerData(player).isLastLocationValid();
            this.chunkyBorder.getPlayerData(player).setLastLocationValid(currentLocationValid);
            if (currentLocationValid) {
                this.chunkyBorder.getPlayerData(player).setLastLocation(loc);
                continue;
            }
            if (player.hasPermission("chunkyborder.bypass.move") || this.chunkyBorder.getPlayerData(player).isBypassing()) {
                if (!lastLocationValid) continue;
                this.chunkyBorder.sendBorderMessage(player);
                continue;
            }
            if (borderData.isWrap()) {
                newLoc = this.wrap(borderData, player);
                this.chunkyBorder.getPlayerData(player).setLastLocation(newLoc);
            } else {
                newLoc = this.chunkyBorder.getPlayerData(player).getLastLocation().orElse(world.getSpawnLocation());
                newLoc.setYaw(loc.getYaw());
                newLoc.setPitch(loc.getPitch());
            }
            this.chunkyBorder.sendBorderMessage(player);
            this.chunkyBorder.getBorderEffect().ifPresent(effect -> player.getWorld().playEffect(loc, effect, 0));
            this.chunkyBorder.getBorderSound().ifPresent(sound -> player.getWorld().playSound(loc, sound, 2.0f, 1.0f));
            Entity vehicle = player.getVehicle();
            PaperLib.teleportAsync((Entity)player, newLoc);
            if (vehicle == null) continue;
            PaperLib.teleportAsync(vehicle, newLoc);
        }
    }

    private Location wrap(BorderData borderData, Player player) {
        Location loc = player.getLocation();
        Location newLoc = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
        switch (borderData.getShape()) {
            case "square": 
            case "rectangle": {
                double minX = borderData.getCenterX() - borderData.getRadiusX();
                double maxX = borderData.getCenterX() + borderData.getRadiusX();
                double minZ = borderData.getCenterZ() - borderData.getRadiusZ();
                double maxZ = borderData.getCenterZ() + borderData.getRadiusZ();
                if (loc.getX() <= minX) {
                    newLoc.setX(maxX - 3.0);
                } else if (loc.getX() >= maxX) {
                    newLoc.setX(minX + 3.0);
                } else if (loc.getZ() <= minZ) {
                    newLoc.setZ(maxZ - 3.0);
                } else if (loc.getZ() >= maxZ) {
                    newLoc.setZ(minZ + 3.0);
                }
                if (!borderData.getBorder().isBounding(newLoc.getX(), newLoc.getZ())) {
                    return this.chunkyBorder.getPlayerData(player).getLastLocation().orElse(loc.getWorld().getSpawnLocation());
                }
                newLoc.setYaw(loc.getYaw());
                newLoc.setPitch(loc.getPitch());
                break;
            }
            default: {
                double centerX = borderData.getCenterX();
                double centerZ = borderData.getCenterZ();
                double fromX = loc.getX();
                double fromY = loc.getY();
                double fromZ = loc.getZ();
                Shape border = borderData.getBorder();
                ArrayList<double[]> intersections = new ArrayList<double[]>();
                if (border instanceof AbstractPolygon) {
                    AbstractPolygon polygonBorder = (AbstractPolygon)border;
                    double[] pointsX = polygonBorder.pointsX();
                    double[] pointsZ = polygonBorder.pointsZ();
                    for (int i = 0; i < pointsX.length; ++i) {
                        ShapeUtil.intersection((double)centerX, (double)centerZ, (double)fromX, (double)fromZ, (double)pointsX[i], (double)pointsZ[i], (double)pointsX[i == pointsX.length - 1 ? 0 : i + 1], (double)pointsZ[i == pointsZ.length - 1 ? 0 : i + 1]).ifPresent(intersections::add);
                    }
                } else if (border instanceof AbstractEllipse) {
                    AbstractEllipse ellipticalBorder = (AbstractEllipse)border;
                    double[] radii = ellipticalBorder.getRadii();
                    double angle = Math.PI + Math.atan2(fromZ - centerX, fromX - centerZ);
                    intersections.add(ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radii[0], (double)radii[1], (double)angle));
                }
                if (intersections.isEmpty()) {
                    return this.chunkyBorder.getPlayerData(player).getLastLocation().orElse(loc.getWorld().getSpawnLocation());
                }
                Vector centerDirection = new Vector(fromX - centerX, 0.0, fromZ - centerZ).normalize().multiply(3);
                double closestX = ((double[])intersections.get(0))[0];
                double closestZ = ((double[])intersections.get(0))[1];
                double longestDistance = Double.MIN_VALUE;
                for (double[] intersection : intersections) {
                    double intersectionX = intersection[0];
                    double intersectionZ = intersection[1];
                    Vector position = new Vector(intersectionX, fromY, intersectionZ).add(centerDirection);
                    double distance = loc.toVector().distanceSquared(position);
                    if (!(distance > longestDistance) || !border.isBounding(position.getX(), position.getZ())) continue;
                    longestDistance = distance;
                    closestX = intersectionX;
                    closestZ = intersectionZ;
                }
                if (longestDistance == Double.MIN_VALUE) {
                    return this.chunkyBorder.getPlayerData(player).getLastLocation().orElse(loc.getWorld().getSpawnLocation());
                }
                newLoc = new Location(loc.getWorld(), closestX, fromY, closestZ);
                newLoc.add(centerDirection);
                newLoc.setDirection(centerDirection);
            }
        }
        int yOffset = Version.getCurrentMinecraftVersion().isHigherThanOrEqualTo(Version.v1_15_0) ? 1 : 0;
        newLoc.setY((double)(newLoc.getWorld().getHighestBlockYAt(newLoc) + yOffset));
        return newLoc;
    }
}

