/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.BukkitWorld;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunkyborder.ChunkyBorder;

public class BorderData {
    private String world;
    private double centerX;
    private double centerZ;
    private double radiusX;
    private double radiusZ;
    private String shape;
    private boolean wrap;
    private transient Shape border;

    public BorderData() {
    }

    public BorderData(Selection selection) {
        this.world = selection.world().getName();
        this.centerX = selection.centerX();
        this.centerZ = selection.centerZ();
        this.radiusX = selection.radiusX();
        this.radiusZ = selection.radiusZ();
        this.shape = selection.shape();
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenterZ(double centerZ) {
        this.centerZ = centerZ;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public Shape getBorder() {
        if (this.border == null) {
            this.border = ShapeFactory.getShape((Selection)this.asSelection().build(), (boolean)ChunkyBorder.isChunkAligned());
            this.shape = this.border.name();
        }
        return this.border;
    }

    public void setBorder(Shape border) {
        this.border = border;
    }

    public Selection.Builder asSelection() {
        World borderWorld = Optional.ofNullable(Bukkit.getWorld((String)this.world)).map(BukkitWorld::new).orElse(null);
        return Selection.builder((World)borderWorld).center(this.centerX, this.centerZ).radiusX(this.radiusX).radiusZ(this.radiusZ).shape(this.shape);
    }
}

