/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.util.List;
import java.util.Optional;
import net.pl3x.map.api.Pl3xMap;
import net.pl3x.map.api.Pl3xMapProvider;
import org.dynmap.DynmapAPI;
import org.popcraft.chunky.integration.BlueMapIntegration;
import org.popcraft.chunky.integration.DynmapIntegration;
import org.popcraft.chunky.integration.MapIntegration;
import org.popcraft.chunky.integration.Pl3xMapIntegration;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorder;

public class BorderInitializationTask
implements Runnable {
    private ChunkyBorder chunkyBorder;

    public BorderInitializationTask(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    @Override
    public void run() {
        String label = this.chunkyBorder.getConfig().getString("map-options.label", "World Border");
        String color = this.chunkyBorder.getConfig().getString("map-options.color", "FF0000");
        boolean hideByDefault = this.chunkyBorder.getConfig().getBoolean("map-options.hide-by-default", false);
        int priority = this.chunkyBorder.getConfig().getInt("map-options.priority", 0);
        int weight = this.chunkyBorder.getConfig().getInt("map-options.weight", 3);
        List<MapIntegration> mapIntegrations = this.chunkyBorder.getMapIntegrations();
        if (this.chunkyBorder.getConfig().getBoolean("map-options.enable.bluemap", true)) {
            Optional.ofNullable(this.chunkyBorder.getServer().getPluginManager().getPlugin("BlueMap")).ifPresent(blueMap -> mapIntegrations.add((MapIntegration)new BlueMapIntegration()));
        }
        if (this.chunkyBorder.getConfig().getBoolean("map-options.enable.dynmap", true)) {
            Optional.ofNullable(this.chunkyBorder.getServer().getPluginManager().getPlugin("dynmap")).ifPresent(dynmap -> {
                DynmapAPI dynmapAPI = (DynmapAPI)dynmap;
                try {
                    dynmapAPI.getMarkerAPI();
                    mapIntegrations.add((MapIntegration)new DynmapIntegration(dynmapAPI));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            });
        }
        if (this.chunkyBorder.getConfig().getBoolean("map-options.enable.pl3xmap", true)) {
            Optional.ofNullable(this.chunkyBorder.getServer().getPluginManager().getPlugin("Pl3xMap")).ifPresent(pl3xMap -> {
                try {
                    Pl3xMap pl3xMapAPI = Pl3xMapProvider.get();
                    mapIntegrations.add((MapIntegration)new Pl3xMapIntegration(pl3xMapAPI));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        for (MapIntegration mapIntegration2 : mapIntegrations) {
            mapIntegration2.setOptions(label, color, hideByDefault, priority, weight);
        }
        for (BorderData border : this.chunkyBorder.getBorders().values()) {
            Optional world;
            if (border.getWorld() == null || !(world = this.chunkyBorder.getChunky().getPlatform().getServer().getWorld(border.getWorld())).isPresent()) continue;
            mapIntegrations.forEach(mapIntegration -> mapIntegration.addShapeMarker((World)world.get(), border.getBorder()));
        }
    }
}

