/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.client.hc4;

import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.client.hc4.Hc4Client;
import org.sonatype.spice.zapper.internal.Check;

public class Hc4ClientBuilder {
    private Parameters parameters;
    private String remoteUrl;
    private HttpHost proxyServer;
    private CredentialsProvider credentialsProvider;

    public Hc4ClientBuilder(Parameters parameters, String remoteUrl) {
        this.parameters = Check.notNull(parameters, Parameters.class);
        this.remoteUrl = Check.notNull(remoteUrl, "Remote URL is null!");
    }

    public Hc4ClientBuilder withProxy(HttpHost proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public Hc4ClientBuilder withRealm(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Hc4Client build() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(schemeRegistry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(this.parameters.getMaximumTrackCount());
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        httpClient.getParams().setParameter("http.useragent", (Object)"Zapper/1.0-HC4");
        if (this.proxyServer != null) {
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)this.proxyServer);
        }
        if (this.credentialsProvider != null) {
            httpClient.setCredentialsProvider(this.credentialsProvider);
        }
        return new Hc4Client(this.parameters, this.remoteUrl, (HttpClient)httpClient);
    }
}

