/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.spice.zapper.IOTarget;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.Range;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.fs.AbstractDirectory;
import org.sonatype.spice.zapper.internal.Check;

public class DirectoryIOTarget
extends AbstractDirectory
implements IOTarget {
    private final Map<Path, File> files = new HashMap<Path, File>();

    public DirectoryIOTarget(File root) throws IOException {
        super(root);
    }

    public void close(boolean successful) throws IOException {
        if (!successful) {
            for (File file : this.files.values()) {
                file.delete();
            }
        }
    }

    public void initializeZFile(ZFile zfile) throws IOException {
        File file = this.getFile((Path)zfile.getIdentifier());
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.setLength(zfile.getLength());
        raf.close();
        this.files.put((Path)zfile.getIdentifier(), file);
    }

    public long writeSegment(ZFile zfile, Range range, InputStream in) throws IOException {
        File file = this.files.get(zfile.getIdentifier());
        FileRange fileRange = new FileRange(file, range);
        long result = fileRange.getFileChannel().transferFrom(Channels.newChannel(in), range.getOffset(), range.getLength());
        fileRange.close();
        return result;
    }

    public void finalizeZFile(ZFile zfile) throws IOException {
        File file = this.files.get(zfile.getIdentifier());
        file.setLastModified(zfile.getLastModifiedTimestamp());
    }

    public static class FileRange {
        private final RandomAccessFile randomAccessFile;
        private final Range range;

        public FileRange(File file, Range range) throws IOException {
            this.randomAccessFile = new RandomAccessFile(file, "rw");
            this.range = Check.notNull(range, "Range is null");
            this.randomAccessFile.seek(range.getOffset());
        }

        public FileChannel getFileChannel() {
            return this.randomAccessFile.getChannel();
        }

        public Range getRange() {
            return this.range;
        }

        public void close() throws IOException {
            this.randomAccessFile.close();
        }
    }
}

