/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.util.StringUtil;

@Deprecated
public class DefaultGameModeCommand
extends VanillaCommand {
    private static final List<String> GAMEMODE_NAMES = ImmutableList.of((Object)"adventure", (Object)"creative", (Object)"survival");

    public DefaultGameModeCommand() {
        super("defaultgamemode");
        this.description = "Set the default gamemode";
        this.usageMessage = "/defaultgamemode <mode>";
        this.setPermission("bukkit.command.defaultgamemode");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("Usage: " + this.usageMessage);
            return false;
        }
        String modeArg = args[0];
        int value = -1;
        try {
            value = Integer.parseInt(modeArg);
        }
        catch (NumberFormatException numberFormatException) {}
        GameMode mode = GameMode.getByValue(value);
        if (mode == null) {
            mode = modeArg.equalsIgnoreCase("creative") || modeArg.equalsIgnoreCase("c") ? GameMode.CREATIVE : (modeArg.equalsIgnoreCase("adventure") || modeArg.equalsIgnoreCase("a") ? GameMode.ADVENTURE : GameMode.SURVIVAL);
        }
        Bukkit.getServer().setDefaultGameMode(mode);
        Command.broadcastCommandMessage(sender, "Default game mode set to " + mode.toString().toLowerCase());
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], GAMEMODE_NAMES, new ArrayList(GAMEMODE_NAMES.size()));
        }
        return ImmutableList.of();
    }
}

