/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.StringUtil;

@Deprecated
public class ScoreboardCommand
extends VanillaCommand {
    private static final List<String> MAIN_CHOICES = ImmutableList.of((Object)"objectives", (Object)"players", (Object)"teams");
    private static final List<String> OBJECTIVES_CHOICES = ImmutableList.of((Object)"list", (Object)"add", (Object)"remove", (Object)"setdisplay");
    private static final List<String> OBJECTIVES_CRITERIA = ImmutableList.of((Object)"health", (Object)"playerKillCount", (Object)"totalKillCount", (Object)"deathCount", (Object)"dummy");
    private static final List<String> PLAYERS_CHOICES = ImmutableList.of((Object)"set", (Object)"add", (Object)"remove", (Object)"reset", (Object)"list");
    private static final List<String> TEAMS_CHOICES = ImmutableList.of((Object)"add", (Object)"remove", (Object)"join", (Object)"leave", (Object)"empty", (Object)"list", (Object)"option");
    private static final List<String> TEAMS_OPTION_CHOICES = ImmutableList.of((Object)"color", (Object)"friendlyfire", (Object)"seeFriendlyInvisibles");
    private static final Map<String, DisplaySlot> OBJECTIVES_DISPLAYSLOT = ImmutableMap.of((Object)"belowName", (Object)((Object)DisplaySlot.BELOW_NAME), (Object)"list", (Object)((Object)DisplaySlot.PLAYER_LIST), (Object)"sidebar", (Object)((Object)DisplaySlot.SIDEBAR));
    private static final Map<String, ChatColor> TEAMS_OPTION_COLOR = ImmutableMap.builder().put((Object)"aqua", (Object)ChatColor.AQUA).put((Object)"black", (Object)ChatColor.BLACK).put((Object)"blue", (Object)ChatColor.BLUE).put((Object)"bold", (Object)ChatColor.BOLD).put((Object)"dark_aqua", (Object)ChatColor.DARK_AQUA).put((Object)"dark_blue", (Object)ChatColor.DARK_BLUE).put((Object)"dark_gray", (Object)ChatColor.DARK_GRAY).put((Object)"dark_green", (Object)ChatColor.DARK_GREEN).put((Object)"dark_purple", (Object)ChatColor.DARK_PURPLE).put((Object)"dark_red", (Object)ChatColor.DARK_RED).put((Object)"gold", (Object)ChatColor.GOLD).put((Object)"gray", (Object)ChatColor.GRAY).put((Object)"green", (Object)ChatColor.GREEN).put((Object)"italic", (Object)ChatColor.ITALIC).put((Object)"light_purple", (Object)ChatColor.LIGHT_PURPLE).put((Object)"obfuscated", (Object)ChatColor.MAGIC).put((Object)"red", (Object)ChatColor.RED).put((Object)"reset", (Object)ChatColor.RESET).put((Object)"strikethrough", (Object)ChatColor.STRIKETHROUGH).put((Object)"underline", (Object)ChatColor.UNDERLINE).put((Object)"white", (Object)ChatColor.WHITE).put((Object)"yellow", (Object)ChatColor.YELLOW).build();
    private static final List<String> BOOLEAN = ImmutableList.of((Object)"true", (Object)"false");

    public ScoreboardCommand() {
        super("scoreboard");
        this.description = "Scoreboard control";
        this.usageMessage = "/scoreboard";
        this.setPermission("bukkit.command.scoreboard");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        block128: {
            block130: {
                block129: {
                    block127: {
                        if (!this.testPermission(sender)) {
                            return true;
                        }
                        if (args.length < 1 || args[0].length() == 0) {
                            sender.sendMessage((Object)ChatColor.RED + "Usage: /scoreboard <objectives|players|teams>");
                            return false;
                        }
                        mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                        if (!args[0].equalsIgnoreCase("objectives")) break block127;
                        if (args.length == 1) {
                            sender.sendMessage((Object)ChatColor.RED + "Usage: /scoreboard objectives <list|add|remove|setdisplay>");
                            return false;
                        }
                        if (args[1].equalsIgnoreCase("list")) {
                            objectives = mainScoreboard.getObjectives();
                            if (objectives.isEmpty()) {
                                sender.sendMessage((Object)ChatColor.RED + "There are no objectives on the scoreboard");
                                return false;
                            }
                            sender.sendMessage((Object)ChatColor.DARK_GREEN + "Showing " + objectives.size() + " objective(s) on scoreboard");
                            for (Objective objective : objectives) {
                                sender.sendMessage("- " + objective.getName() + ": displays as '" + objective.getDisplayName() + "' and is type '" + objective.getCriteria() + "'");
                            }
                        } else if (args[1].equalsIgnoreCase("add")) {
                            if (args.length < 4) {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard objectives add <name> <criteriaType> [display name ...]");
                                return false;
                            }
                            name = args[2];
                            criteria = args[3];
                            if (criteria == null) {
                                sender.sendMessage((Object)ChatColor.RED + "Invalid objective criteria type. Valid types are: " + ScoreboardCommand.stringCollectionToString(ScoreboardCommand.OBJECTIVES_CRITERIA));
                            } else if (name.length() > 16) {
                                sender.sendMessage((Object)ChatColor.RED + "The name '" + name + "' is too long for an objective, it can be at most 16 characters long");
                            } else if (mainScoreboard.getObjective(name) != null) {
                                sender.sendMessage((Object)ChatColor.RED + "An objective with the name '" + name + "' already exists");
                            } else {
                                displayName = null;
                                if (args.length > 4 && (displayName = StringUtils.join((Object[])ArrayUtils.subarray((Object[])args, (int)4, (int)args.length), (char)' ')).length() > 32) {
                                    sender.sendMessage((Object)ChatColor.RED + "The name '" + displayName + "' is too long for an objective, it can be at most 32 characters long");
                                    return false;
                                }
                                objective = mainScoreboard.registerNewObjective(name, criteria);
                                if (displayName != null && displayName.length() > 0) {
                                    objective.setDisplayName(displayName);
                                }
                                sender.sendMessage("Added new objective '" + name + "' successfully");
                            }
                        } else if (args[1].equalsIgnoreCase("remove")) {
                            if (args.length != 3) {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard objectives remove <name>");
                                return false;
                            }
                            name = args[2];
                            objective = mainScoreboard.getObjective(name);
                            if (objective == null) {
                                sender.sendMessage((Object)ChatColor.RED + "No objective was found by the name '" + name + "'");
                            } else {
                                objective.unregister();
                                sender.sendMessage("Removed objective '" + name + "' successfully");
                            }
                        } else if (args[1].equalsIgnoreCase("setdisplay")) {
                            if (args.length != 3 && args.length != 4) {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard objectives setdisplay <slot> [objective]");
                                return false;
                            }
                            slotName = args[2];
                            slot = ScoreboardCommand.OBJECTIVES_DISPLAYSLOT.get(slotName);
                            if (slot == null) {
                                sender.sendMessage((Object)ChatColor.RED + "No such display slot '" + slotName + "'");
                            } else if (args.length == 4) {
                                objectiveName = args[3];
                                objective = mainScoreboard.getObjective(objectiveName);
                                if (objective == null) {
                                    sender.sendMessage((Object)ChatColor.RED + "No objective was found by the name '" + objectiveName + "'");
                                    return false;
                                }
                                objective.setDisplaySlot(slot);
                                sender.sendMessage("Set the display objective in slot '" + slotName + "' to '" + objective.getName() + "'");
                            } else {
                                objective = mainScoreboard.getObjective(slot);
                                if (objective != null) {
                                    objective.setDisplaySlot(null);
                                }
                                sender.sendMessage("Cleared objective display slot '" + slotName + "'");
                            }
                        }
                        break block128;
                    }
                    if (!args[0].equalsIgnoreCase("players")) break block129;
                    if (args.length == 1) {
                        sender.sendMessage((Object)ChatColor.RED + "/scoreboard players <set|add|remove|reset|list>");
                        return false;
                    }
                    if (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                        if (args.length != 5) {
                            if (args[1].equalsIgnoreCase("set")) {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard players set <player> <objective> <score>");
                            } else if (args[1].equalsIgnoreCase("add")) {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard players add <player> <objective> <count>");
                            } else {
                                sender.sendMessage((Object)ChatColor.RED + "/scoreboard players remove <player> <objective> <count>");
                            }
                            return false;
                        }
                        objectiveName = args[3];
                        objective = mainScoreboard.getObjective(objectiveName);
                        if (objective == null) {
                            sender.sendMessage((Object)ChatColor.RED + "No objective was found by the name '" + objectiveName + "'");
                            return false;
                        }
                        if (!objective.isModifiable()) {
                            sender.sendMessage((Object)ChatColor.RED + "The objective '" + objectiveName + "' is read-only and cannot be set");
                            return false;
                        }
                        valueString = args[4];
                        try {
                            value = Integer.parseInt(valueString);
                        }
                        catch (NumberFormatException v0) {
                            sender.sendMessage((Object)ChatColor.RED + "'" + valueString + "' is not a valid number");
                            return false;
                        }
                        if (value < 1 && !args[1].equalsIgnoreCase("set")) {
                            sender.sendMessage((Object)ChatColor.RED + "The number you have entered (" + value + ") is too small, it must be at least 1");
                            return false;
                        }
                        playerName = args[2];
                        if (playerName.length() > 16) {
                            sender.sendMessage((Object)ChatColor.RED + "'" + playerName + "' is too long for a player name");
                            return false;
                        }
                        score = objective.getScore(playerName);
                        newScore = args[1].equalsIgnoreCase("set") != false ? value : (args[1].equalsIgnoreCase("add") != false ? score.getScore() + value : score.getScore() - value);
                        score.setScore(newScore);
                        sender.sendMessage("Set score of " + objectiveName + " for player " + playerName + " to " + newScore);
                    } else if (args[1].equalsIgnoreCase("reset")) {
                        if (args.length != 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard players reset <player>");
                            return false;
                        }
                        playerName = args[2];
                        if (playerName.length() > 16) {
                            sender.sendMessage((Object)ChatColor.RED + "'" + playerName + "' is too long for a player name");
                            return false;
                        }
                        mainScoreboard.resetScores(playerName);
                        sender.sendMessage("Reset all scores of player " + playerName);
                    } else if (args[1].equalsIgnoreCase("list")) {
                        if (args.length > 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard players list <player>");
                            return false;
                        }
                        if (args.length == 2) {
                            entries = mainScoreboard.getEntries();
                            if (entries.isEmpty()) {
                                sender.sendMessage((Object)ChatColor.RED + "There are no tracked players on the scoreboard");
                            } else {
                                sender.sendMessage((Object)ChatColor.DARK_GREEN + "Showing " + entries.size() + " tracked players on the scoreboard");
                                sender.sendMessage(ScoreboardCommand.stringCollectionToString(entries));
                            }
                        } else {
                            playerName = args[2];
                            if (playerName.length() > 16) {
                                sender.sendMessage((Object)ChatColor.RED + "'" + playerName + "' is too long for a player name");
                                return false;
                            }
                            scores = mainScoreboard.getScores(playerName);
                            if (scores.isEmpty()) {
                                sender.sendMessage((Object)ChatColor.RED + "Player " + playerName + " has no scores recorded");
                            } else {
                                sender.sendMessage((Object)ChatColor.DARK_GREEN + "Showing " + scores.size() + " tracked objective(s) for " + playerName);
                                for (Score score : scores) {
                                    sender.sendMessage("- " + score.getObjective().getDisplayName() + ": " + score.getScore() + " (" + score.getObjective().getName() + ")");
                                }
                            }
                        }
                    }
                    break block128;
                }
                if (!args[0].equalsIgnoreCase("teams")) break block130;
                if (args.length == 1) {
                    sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams <list|add|remove|empty|join|leave|option>");
                    return false;
                }
                if (!args[1].equalsIgnoreCase("list")) ** GOTO lbl189
                if (args.length == 2) {
                    teams = mainScoreboard.getTeams();
                    if (teams.isEmpty()) {
                        sender.sendMessage((Object)ChatColor.RED + "There are no teams registered on the scoreboard");
                    } else {
                        sender.sendMessage((Object)ChatColor.DARK_GREEN + "Showing " + teams.size() + " teams on the scoreboard");
                        for (Team team : teams) {
                            sender.sendMessage("- " + team.getName() + ": '" + team.getDisplayName() + "' has " + team.getSize() + " players");
                        }
                    }
                } else if (args.length == 3) {
                    teamName = args[2];
                    team = mainScoreboard.getTeam(teamName);
                    if (team == null) {
                        sender.sendMessage((Object)ChatColor.RED + "No team was found by the name '" + teamName + "'");
                    } else {
                        players = team.getPlayers();
                        if (players.isEmpty()) {
                            sender.sendMessage((Object)ChatColor.RED + "Team " + team.getName() + " has no players");
                        } else {
                            sender.sendMessage((Object)ChatColor.DARK_GREEN + "Showing " + players.size() + " player(s) in team " + team.getName());
                            sender.sendMessage(ScoreboardCommand.offlinePlayerSetToString(players));
                        }
                    }
                } else {
                    sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams list [name]");
                    return false;
lbl189:
                    // 1 sources

                    if (args[1].equalsIgnoreCase("add")) {
                        if (args.length < 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams add <name> [display name ...]");
                            return false;
                        }
                        name = args[2];
                        if (name.length() > 16) {
                            sender.sendMessage((Object)ChatColor.RED + "The name '" + name + "' is too long for a team, it can be at most 16 characters long");
                        } else if (mainScoreboard.getTeam(name) != null) {
                            sender.sendMessage((Object)ChatColor.RED + "A team with the name '" + name + "' already exists");
                        } else {
                            displayName = null;
                            if (args.length > 3 && (displayName = StringUtils.join((Object[])ArrayUtils.subarray((Object[])args, (int)3, (int)args.length), (char)' ')).length() > 32) {
                                sender.sendMessage((Object)ChatColor.RED + "The display name '" + displayName + "' is too long for a team, it can be at most 32 characters long");
                                return false;
                            }
                            team = mainScoreboard.registerNewTeam(name);
                            if (displayName != null && displayName.length() > 0) {
                                team.setDisplayName(displayName);
                            }
                            sender.sendMessage("Added new team '" + team.getName() + "' successfully");
                        }
                    } else if (args[1].equalsIgnoreCase("remove")) {
                        if (args.length != 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams remove <name>");
                            return false;
                        }
                        name = args[2];
                        team = mainScoreboard.getTeam(name);
                        if (team == null) {
                            sender.sendMessage((Object)ChatColor.RED + "No team was found by the name '" + name + "'");
                        } else {
                            team.unregister();
                            sender.sendMessage("Removed team " + name);
                        }
                    } else if (args[1].equalsIgnoreCase("empty")) {
                        if (args.length != 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams clear <name>");
                            return false;
                        }
                        name = args[2];
                        team = mainScoreboard.getTeam(name);
                        if (team == null) {
                            sender.sendMessage((Object)ChatColor.RED + "No team was found by the name '" + name + "'");
                        } else {
                            players = team.getPlayers();
                            if (players.isEmpty()) {
                                sender.sendMessage((Object)ChatColor.RED + "Team " + team.getName() + " is already empty, cannot remove nonexistant players");
                            } else {
                                for (OfflinePlayer player : players) {
                                    team.removePlayer(player);
                                }
                                sender.sendMessage("Removed all " + players.size() + " player(s) from team " + team.getName());
                            }
                        }
                    } else if (args[1].equalsIgnoreCase("join")) {
                        if (sender instanceof Player != false ? args.length < 3 : args.length < 4) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams join <team> [player...]");
                            return false;
                        }
                        teamName = args[2];
                        team = mainScoreboard.getTeam(teamName);
                        if (team == null) {
                            sender.sendMessage((Object)ChatColor.RED + "No team was found by the name '" + teamName + "'");
                        } else {
                            addedPlayers = new HashSet<String>();
                            if (sender instanceof Player && args.length == 3) {
                                team.addPlayer((Player)sender);
                                addedPlayers.add(sender.getName());
                            } else {
                                i = 3;
                                while (i < args.length) {
                                    playerName = args[i];
                                    player = Bukkit.getPlayerExact(playerName);
                                    offlinePlayer = player != null ? player : Bukkit.getOfflinePlayer(playerName);
                                    team.addPlayer(offlinePlayer);
                                    addedPlayers.add(offlinePlayer.getName());
                                    ++i;
                                }
                            }
                            sender.sendMessage("Added " + addedPlayers.size() + " player(s) to team " + team.getName() + ": " + ScoreboardCommand.stringCollectionToString(addedPlayers));
                        }
                    } else if (args[1].equalsIgnoreCase("leave")) {
                        if (!(sender instanceof Player) && args.length < 3) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams leave [player...]");
                            return false;
                        }
                        left = new HashSet<String>();
                        noTeam = new HashSet<String>();
                        if (sender instanceof Player && args.length == 2) {
                            team = mainScoreboard.getPlayerTeam((Player)sender);
                            if (team != null) {
                                team.removePlayer((Player)sender);
                                left.add(sender.getName());
                            } else {
                                noTeam.add(sender.getName());
                            }
                        } else {
                            i = 2;
                            while (i < args.length) {
                                playerName = args[i];
                                player = Bukkit.getPlayerExact(playerName);
                                offlinePlayer = player != null ? player : Bukkit.getOfflinePlayer(playerName);
                                team = mainScoreboard.getPlayerTeam(offlinePlayer);
                                if (team != null) {
                                    team.removePlayer(offlinePlayer);
                                    left.add(offlinePlayer.getName());
                                } else {
                                    noTeam.add(offlinePlayer.getName());
                                }
                                ++i;
                            }
                        }
                        if (!left.isEmpty()) {
                            sender.sendMessage("Removed " + left.size() + " player(s) from their teams: " + ScoreboardCommand.stringCollectionToString(left));
                        }
                        if (!noTeam.isEmpty()) {
                            sender.sendMessage("Could not remove " + noTeam.size() + " player(s) from their teams: " + ScoreboardCommand.stringCollectionToString(noTeam));
                        }
                    } else if (args[1].equalsIgnoreCase("option")) {
                        if (args.length != 4 && args.length != 5) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams option <team> <friendlyfire|color|seefriendlyinvisibles> <value>");
                            return false;
                        }
                        teamName = args[2];
                        team = mainScoreboard.getTeam(teamName);
                        if (team == null) {
                            sender.sendMessage((Object)ChatColor.RED + "No team was found by the name '" + teamName + "'");
                            return false;
                        }
                        option = args[3].toLowerCase(Locale.ENGLISH);
                        if (!(option.equals("friendlyfire") || option.equals("color") || option.equals("seefriendlyinvisibles"))) {
                            sender.sendMessage((Object)ChatColor.RED + "/scoreboard teams option <team> <friendlyfire|color|seefriendlyinvisibles> <value>");
                            return false;
                        }
                        if (args.length == 4) {
                            if (option.equals("color")) {
                                sender.sendMessage((Object)ChatColor.RED + "Valid values for option color are: " + ScoreboardCommand.stringCollectionToString(ScoreboardCommand.TEAMS_OPTION_COLOR.keySet()));
                            } else {
                                sender.sendMessage((Object)ChatColor.RED + "Valid values for option " + option + " are: true and false");
                            }
                        } else {
                            value = args[4].toLowerCase(Locale.ENGLISH);
                            if (option.equals("color")) {
                                color = ScoreboardCommand.TEAMS_OPTION_COLOR.get(value);
                                if (color == null) {
                                    sender.sendMessage((Object)ChatColor.RED + "Valid values for option color are: " + ScoreboardCommand.stringCollectionToString(ScoreboardCommand.TEAMS_OPTION_COLOR.keySet()));
                                    return false;
                                }
                                team.setPrefix(color.toString());
                                team.setSuffix(ChatColor.RESET.toString());
                            } else {
                                if (!value.equals("true") && !value.equals("false")) {
                                    sender.sendMessage((Object)ChatColor.RED + "Valid values for option " + option + " are: true and false");
                                    return false;
                                }
                                if (option.equals("friendlyfire")) {
                                    team.setAllowFriendlyFire(value.equals("true"));
                                } else {
                                    team.setCanSeeFriendlyInvisibles(value.equals("true"));
                                }
                            }
                            sender.sendMessage("Set option " + option + " for team " + team.getName() + " to " + value);
                        }
                    }
                }
                break block128;
            }
            sender.sendMessage((Object)ChatColor.RED + "Usage: /scoreboard <objectives|players|teams>");
            return false;
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], MAIN_CHOICES, new ArrayList());
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("objectives")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], OBJECTIVES_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("add")) {
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], OBJECTIVES_CRITERIA, new ArrayList());
                    }
                } else if (args[1].equalsIgnoreCase("remove")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentObjectives(), new ArrayList());
                    }
                } else if (args[1].equalsIgnoreCase("setdisplay")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], OBJECTIVES_DISPLAYSLOT.keySet(), new ArrayList());
                    }
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], this.getCurrentObjectives(), new ArrayList());
                    }
                }
            } else if (args[0].equalsIgnoreCase("players")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], PLAYERS_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                    if (args.length == 3) {
                        return super.tabComplete(sender, alias, args);
                    }
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], this.getCurrentObjectives(), new ArrayList());
                    }
                } else if (args.length == 3) {
                    return StringUtil.copyPartialMatches(args[2], this.getCurrentEntries(), new ArrayList());
                }
            } else if (args[0].equalsIgnoreCase("teams")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], TEAMS_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("join")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                    }
                    if (args.length >= 4) {
                        return super.tabComplete(sender, alias, args);
                    }
                } else {
                    if (args[1].equalsIgnoreCase("leave")) {
                        return super.tabComplete(sender, alias, args);
                    }
                    if (args[1].equalsIgnoreCase("option")) {
                        if (args.length == 3) {
                            return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                        }
                        if (args.length == 4) {
                            return StringUtil.copyPartialMatches(args[3], TEAMS_OPTION_CHOICES, new ArrayList());
                        }
                        if (args.length == 5) {
                            if (args[3].equalsIgnoreCase("color")) {
                                return StringUtil.copyPartialMatches(args[4], TEAMS_OPTION_COLOR.keySet(), new ArrayList());
                            }
                            return StringUtil.copyPartialMatches(args[4], BOOLEAN, new ArrayList());
                        }
                    } else if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                    }
                }
            }
        }
        return ImmutableList.of();
    }

    private static String offlinePlayerSetToString(Set<OfflinePlayer> set) {
        StringBuilder string = new StringBuilder();
        String lastValue = null;
        for (OfflinePlayer value : set) {
            lastValue = value.getName();
            string.append(lastValue).append(", ");
        }
        string.delete(string.length() - 2, Integer.MAX_VALUE);
        if (string.length() != lastValue.length()) {
            string.insert(string.length() - lastValue.length(), "and ");
        }
        return string.toString();
    }

    private static String stringCollectionToString(Collection<String> set) {
        StringBuilder string = new StringBuilder();
        String lastValue = null;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String value;
            lastValue = value = iterator.next();
            string.append(lastValue).append(", ");
        }
        string.delete(string.length() - 2, Integer.MAX_VALUE);
        if (string.length() != lastValue.length()) {
            string.insert(string.length() - lastValue.length(), "and ");
        }
        return string.toString();
    }

    private List<String> getCurrentObjectives() {
        ArrayList<String> list = new ArrayList<String>();
        for (Objective objective : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            list.add(objective.getName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private List<String> getCurrentEntries() {
        ArrayList<String> list = new ArrayList<String>();
        for (String entry : Bukkit.getScoreboardManager().getMainScoreboard().getEntries()) {
            list.add(entry);
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private List<String> getCurrentTeams() {
        ArrayList<String> list = new ArrayList<String>();
        for (Team team : Bukkit.getScoreboardManager().getMainScoreboard().getTeams()) {
            list.add(team.getName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }
}

