/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public interface RecipeChoice
extends Predicate<ItemStack>,
Cloneable {
    @Deprecated
    public ItemStack getItemStack();

    public RecipeChoice clone();

    public static class MaterialChoice
    implements RecipeChoice {
        private List<Material> choices;

        public MaterialChoice(List<Material> choices) {
            Preconditions.checkArgument((choices != null ? 1 : 0) != 0, (Object)"choices");
            Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one choice");
            this.choices = choices;
        }

        @Override
        public boolean test(ItemStack t) {
            for (Material match : this.choices) {
                if (t.getType() != match) continue;
                return true;
            }
            return false;
        }

        @Override
        public ItemStack getItemStack() {
            ItemStack stack = new ItemStack(this.choices.get(0));
            if (this.choices.size() > 1) {
                stack.setDurability((short)Short.MAX_VALUE);
            }
            return stack;
        }

        public List<Material> getChoices() {
            return Collections.unmodifiableList(this.choices);
        }

        @Override
        public MaterialChoice clone() {
            try {
                MaterialChoice clone = (MaterialChoice)super.clone();
                clone.choices = new ArrayList<Material>(this.choices);
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.choices);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MaterialChoice other = (MaterialChoice)obj;
            return Objects.equals(this.choices, other.choices);
        }

        public String toString() {
            return "MaterialChoice{choices=" + this.choices + '}';
        }
    }
}

