/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;

public class FurnaceRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private ItemStack output;
    private RecipeChoice ingredient;
    private float experience;
    private int cookingTime;
    private String group = "";

    @Deprecated
    public FurnaceRecipe(@NotNull ItemStack result, @NotNull Material source) {
        this(NamespacedKey.randomKey(), result, source, 0, 0.0f, 200);
    }

    @Deprecated
    public FurnaceRecipe(@NotNull ItemStack result, @NotNull MaterialData source) {
        this(NamespacedKey.randomKey(), result, source.getItemType(), source.getData(), 0.0f, 200);
    }

    @Deprecated
    public FurnaceRecipe(@NotNull ItemStack result, @NotNull MaterialData source, float experience) {
        this(NamespacedKey.randomKey(), result, source.getItemType(), source.getData(), experience, 200);
    }

    @Deprecated
    public FurnaceRecipe(@NotNull ItemStack result, @NotNull Material source, int data) {
        this(NamespacedKey.randomKey(), result, source, data, 0.0f, 200);
    }

    public FurnaceRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull Material source, float experience, int cookingTime) {
        this(key, result, source, 0, experience, cookingTime);
    }

    @Deprecated
    public FurnaceRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull Material source, int data, float experience, int cookingTime) {
        this(key, result, new RecipeChoice.MaterialChoice(Collections.singletonList(source)), experience, cookingTime);
    }

    public FurnaceRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull RecipeChoice input, float experience, int cookingTime) {
        this.key = key;
        this.output = new ItemStack(result);
        this.ingredient = input;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    @NotNull
    public FurnaceRecipe setInput(@NotNull MaterialData input) {
        return this.setInput(input.getItemType(), input.getData());
    }

    @NotNull
    public FurnaceRecipe setInput(@NotNull Material input) {
        return this.setInput(input, 0);
    }

    @Deprecated
    @NotNull
    public FurnaceRecipe setInput(@NotNull Material input, int data) {
        this.ingredient = new RecipeChoice.MaterialChoice(Collections.singletonList(input));
        return this;
    }

    @NotNull
    public ItemStack getInput() {
        return this.ingredient.getItemStack();
    }

    @NotNull
    public FurnaceRecipe setInputChoice(@NotNull RecipeChoice input) {
        this.ingredient = input;
        return this;
    }

    @NotNull
    public RecipeChoice getInputChoice() {
        return this.ingredient.clone();
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.output.clone();
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public float getExperience() {
        return this.experience;
    }

    public void setCookingTime(int cookingTime) {
        Preconditions.checkArgument((cookingTime >= 0 ? 1 : 0) != 0, (Object)"cookingTime must be >= 0");
        this.cookingTime = cookingTime;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group");
        this.group = group;
    }
}

