/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.Potion;

public final class Effect
extends Enum<Effect> {
    public static final /* enum */ Effect CLICK2;
    public static final /* enum */ Effect CLICK1;
    public static final /* enum */ Effect BOW_FIRE;
    public static final /* enum */ Effect DOOR_TOGGLE;
    public static final /* enum */ Effect IRON_DOOR_TOGGLE;
    public static final /* enum */ Effect TRAPDOOR_TOGGLE;
    public static final /* enum */ Effect IRON_TRAPDOOR_TOGGLE;
    public static final /* enum */ Effect FENCE_GATE_TOGGLE;
    public static final /* enum */ Effect DOOR_CLOSE;
    public static final /* enum */ Effect IRON_DOOR_CLOSE;
    public static final /* enum */ Effect TRAPDOOR_CLOSE;
    public static final /* enum */ Effect IRON_TRAPDOOR_CLOSE;
    public static final /* enum */ Effect FENCE_GATE_CLOSE;
    public static final /* enum */ Effect EXTINGUISH;
    public static final /* enum */ Effect RECORD_PLAY;
    public static final /* enum */ Effect GHAST_SHRIEK;
    public static final /* enum */ Effect GHAST_SHOOT;
    public static final /* enum */ Effect BLAZE_SHOOT;
    public static final /* enum */ Effect ZOMBIE_CHEW_WOODEN_DOOR;
    public static final /* enum */ Effect ZOMBIE_CHEW_IRON_DOOR;
    public static final /* enum */ Effect ZOMBIE_DESTROY_DOOR;
    public static final /* enum */ Effect SMOKE;
    public static final /* enum */ Effect STEP_SOUND;
    public static final /* enum */ Effect POTION_BREAK;
    public static final /* enum */ Effect ENDER_SIGNAL;
    public static final /* enum */ Effect MOBSPAWNER_FLAMES;
    public static final /* enum */ Effect BREWING_STAND_BREW;
    public static final /* enum */ Effect CHORUS_FLOWER_GROW;
    public static final /* enum */ Effect CHORUS_FLOWER_DEATH;
    public static final /* enum */ Effect PORTAL_TRAVEL;
    public static final /* enum */ Effect ENDEREYE_LAUNCH;
    public static final /* enum */ Effect FIREWORK_SHOOT;
    public static final /* enum */ Effect VILLAGER_PLANT_GROW;
    public static final /* enum */ Effect DRAGON_BREATH;
    public static final /* enum */ Effect ANVIL_BREAK;
    public static final /* enum */ Effect ANVIL_USE;
    public static final /* enum */ Effect ANVIL_LAND;
    public static final /* enum */ Effect ENDERDRAGON_SHOOT;
    public static final /* enum */ Effect WITHER_BREAK_BLOCK;
    public static final /* enum */ Effect WITHER_SHOOT;
    public static final /* enum */ Effect ZOMBIE_INFECT;
    public static final /* enum */ Effect ZOMBIE_CONVERTED_VILLAGER;
    public static final /* enum */ Effect BAT_TAKEOFF;
    public static final /* enum */ Effect END_GATEWAY_SPAWN;
    public static final /* enum */ Effect ENDERDRAGON_GROWL;
    public static final /* enum */ Effect FIREWORKS_SPARK;
    public static final /* enum */ Effect CRIT;
    public static final /* enum */ Effect MAGIC_CRIT;
    public static final /* enum */ Effect POTION_SWIRL;
    public static final /* enum */ Effect POTION_SWIRL_TRANSPARENT;
    public static final /* enum */ Effect SPELL;
    public static final /* enum */ Effect INSTANT_SPELL;
    public static final /* enum */ Effect WITCH_MAGIC;
    public static final /* enum */ Effect NOTE;
    public static final /* enum */ Effect PORTAL;
    public static final /* enum */ Effect FLYING_GLYPH;
    public static final /* enum */ Effect FLAME;
    public static final /* enum */ Effect LAVA_POP;
    public static final /* enum */ Effect FOOTSTEP;
    public static final /* enum */ Effect SPLASH;
    public static final /* enum */ Effect PARTICLE_SMOKE;
    public static final /* enum */ Effect EXPLOSION_HUGE;
    public static final /* enum */ Effect EXPLOSION_LARGE;
    public static final /* enum */ Effect EXPLOSION;
    public static final /* enum */ Effect VOID_FOG;
    public static final /* enum */ Effect SMALL_SMOKE;
    public static final /* enum */ Effect CLOUD;
    public static final /* enum */ Effect COLOURED_DUST;
    public static final /* enum */ Effect SNOWBALL_BREAK;
    public static final /* enum */ Effect WATERDRIP;
    public static final /* enum */ Effect LAVADRIP;
    public static final /* enum */ Effect SNOW_SHOVEL;
    public static final /* enum */ Effect SLIME;
    public static final /* enum */ Effect HEART;
    public static final /* enum */ Effect VILLAGER_THUNDERCLOUD;
    public static final /* enum */ Effect HAPPY_VILLAGER;
    public static final /* enum */ Effect LARGE_SMOKE;
    public static final /* enum */ Effect ITEM_BREAK;
    public static final /* enum */ Effect TILE_BREAK;
    public static final /* enum */ Effect TILE_DUST;
    private final int id;
    private final Type type;
    private final Class<?> data;
    private static final Map<Integer, Effect> BY_ID;
    private static final Map<String, Effect> BY_NAME;
    private final String particleName;
    private static final /* synthetic */ Effect[] ENUM$VALUES;

    static {
        Effect effect;
        CLICK2 = new Effect(1000, Type.SOUND);
        CLICK1 = new Effect(1001, Type.SOUND);
        BOW_FIRE = new Effect(1002, Type.SOUND);
        DOOR_TOGGLE = new Effect(1006, Type.SOUND);
        IRON_DOOR_TOGGLE = new Effect(1005, Type.SOUND);
        TRAPDOOR_TOGGLE = new Effect(1007, Type.SOUND);
        IRON_TRAPDOOR_TOGGLE = new Effect(1037, Type.SOUND);
        FENCE_GATE_TOGGLE = new Effect(1008, Type.SOUND);
        DOOR_CLOSE = new Effect(1012, Type.SOUND);
        IRON_DOOR_CLOSE = new Effect(1011, Type.SOUND);
        TRAPDOOR_CLOSE = new Effect(1013, Type.SOUND);
        IRON_TRAPDOOR_CLOSE = new Effect(1036, Type.SOUND);
        FENCE_GATE_CLOSE = new Effect(1014, Type.SOUND);
        EXTINGUISH = new Effect(1009, Type.SOUND);
        RECORD_PLAY = new Effect(1010, Type.SOUND, Material.class);
        GHAST_SHRIEK = new Effect(1015, Type.SOUND);
        GHAST_SHOOT = new Effect(1016, Type.SOUND);
        BLAZE_SHOOT = new Effect(1018, Type.SOUND);
        ZOMBIE_CHEW_WOODEN_DOOR = new Effect(1019, Type.SOUND);
        ZOMBIE_CHEW_IRON_DOOR = new Effect(1020, Type.SOUND);
        ZOMBIE_DESTROY_DOOR = new Effect(1021, Type.SOUND);
        SMOKE = new Effect(2000, Type.VISUAL, BlockFace.class);
        STEP_SOUND = new Effect(2001, Type.SOUND, Material.class);
        POTION_BREAK = new Effect(2002, Type.VISUAL, Potion.class);
        ENDER_SIGNAL = new Effect(2003, Type.VISUAL);
        MOBSPAWNER_FLAMES = new Effect(2004, Type.VISUAL);
        BREWING_STAND_BREW = new Effect(1035, Type.SOUND);
        CHORUS_FLOWER_GROW = new Effect(1033, Type.SOUND);
        CHORUS_FLOWER_DEATH = new Effect(1034, Type.SOUND);
        PORTAL_TRAVEL = new Effect(1032, Type.SOUND);
        ENDEREYE_LAUNCH = new Effect(1003, Type.SOUND);
        FIREWORK_SHOOT = new Effect(1004, Type.SOUND);
        VILLAGER_PLANT_GROW = new Effect(2005, Type.VISUAL, Integer.class);
        DRAGON_BREATH = new Effect(2006, Type.VISUAL);
        ANVIL_BREAK = new Effect(1029, Type.SOUND);
        ANVIL_USE = new Effect(1030, Type.SOUND);
        ANVIL_LAND = new Effect(1031, Type.SOUND);
        ENDERDRAGON_SHOOT = new Effect(1017, Type.SOUND);
        WITHER_BREAK_BLOCK = new Effect(1022, Type.SOUND);
        WITHER_SHOOT = new Effect(1024, Type.SOUND);
        ZOMBIE_INFECT = new Effect(1026, Type.SOUND);
        ZOMBIE_CONVERTED_VILLAGER = new Effect(1027, Type.SOUND);
        BAT_TAKEOFF = new Effect(1025, Type.SOUND);
        END_GATEWAY_SPAWN = new Effect(3000, Type.VISUAL);
        ENDERDRAGON_GROWL = new Effect(3001, Type.SOUND);
        FIREWORKS_SPARK = new Effect("fireworksSpark", Type.PARTICLE);
        CRIT = new Effect("crit", Type.PARTICLE);
        MAGIC_CRIT = new Effect("magicCrit", Type.PARTICLE);
        POTION_SWIRL = new Effect("mobSpell", Type.PARTICLE);
        POTION_SWIRL_TRANSPARENT = new Effect("mobSpellAmbient", Type.PARTICLE);
        SPELL = new Effect("spell", Type.PARTICLE);
        INSTANT_SPELL = new Effect("instantSpell", Type.PARTICLE);
        WITCH_MAGIC = new Effect("witchMagic", Type.PARTICLE);
        NOTE = new Effect("note", Type.PARTICLE);
        PORTAL = new Effect("portal", Type.PARTICLE);
        FLYING_GLYPH = new Effect("enchantmenttable", Type.PARTICLE);
        FLAME = new Effect("flame", Type.PARTICLE);
        LAVA_POP = new Effect("lava", Type.PARTICLE);
        FOOTSTEP = new Effect("footstep", Type.PARTICLE);
        SPLASH = new Effect("splash", Type.PARTICLE);
        PARTICLE_SMOKE = new Effect("smoke", Type.PARTICLE);
        EXPLOSION_HUGE = new Effect("hugeexplosion", Type.PARTICLE);
        EXPLOSION_LARGE = new Effect("largeexplode", Type.PARTICLE);
        EXPLOSION = new Effect("explode", Type.PARTICLE);
        VOID_FOG = new Effect("depthsuspend", Type.PARTICLE);
        SMALL_SMOKE = new Effect("townaura", Type.PARTICLE);
        CLOUD = new Effect("cloud", Type.PARTICLE);
        COLOURED_DUST = new Effect("reddust", Type.PARTICLE);
        SNOWBALL_BREAK = new Effect("snowballpoof", Type.PARTICLE);
        WATERDRIP = new Effect("dripWater", Type.PARTICLE);
        LAVADRIP = new Effect("dripLava", Type.PARTICLE);
        SNOW_SHOVEL = new Effect("snowshovel", Type.PARTICLE);
        SLIME = new Effect("slime", Type.PARTICLE);
        HEART = new Effect("heart", Type.PARTICLE);
        VILLAGER_THUNDERCLOUD = new Effect("angryVillager", Type.PARTICLE);
        HAPPY_VILLAGER = new Effect("happyVillager", Type.PARTICLE);
        LARGE_SMOKE = new Effect("largesmoke", Type.PARTICLE);
        ITEM_BREAK = new Effect("iconcrack", Type.PARTICLE, Material.class);
        TILE_BREAK = new Effect("blockcrack", Type.PARTICLE, MaterialData.class);
        TILE_DUST = new Effect("blockdust", Type.PARTICLE, MaterialData.class);
        ENUM$VALUES = new Effect[]{CLICK2, CLICK1, BOW_FIRE, DOOR_TOGGLE, IRON_DOOR_TOGGLE, TRAPDOOR_TOGGLE, IRON_TRAPDOOR_TOGGLE, FENCE_GATE_TOGGLE, DOOR_CLOSE, IRON_DOOR_CLOSE, TRAPDOOR_CLOSE, IRON_TRAPDOOR_CLOSE, FENCE_GATE_CLOSE, EXTINGUISH, RECORD_PLAY, GHAST_SHRIEK, GHAST_SHOOT, BLAZE_SHOOT, ZOMBIE_CHEW_WOODEN_DOOR, ZOMBIE_CHEW_IRON_DOOR, ZOMBIE_DESTROY_DOOR, SMOKE, STEP_SOUND, POTION_BREAK, ENDER_SIGNAL, MOBSPAWNER_FLAMES, BREWING_STAND_BREW, CHORUS_FLOWER_GROW, CHORUS_FLOWER_DEATH, PORTAL_TRAVEL, ENDEREYE_LAUNCH, FIREWORK_SHOOT, VILLAGER_PLANT_GROW, DRAGON_BREATH, ANVIL_BREAK, ANVIL_USE, ANVIL_LAND, ENDERDRAGON_SHOOT, WITHER_BREAK_BLOCK, WITHER_SHOOT, ZOMBIE_INFECT, ZOMBIE_CONVERTED_VILLAGER, BAT_TAKEOFF, END_GATEWAY_SPAWN, ENDERDRAGON_GROWL, FIREWORKS_SPARK, CRIT, MAGIC_CRIT, POTION_SWIRL, POTION_SWIRL_TRANSPARENT, SPELL, INSTANT_SPELL, WITCH_MAGIC, NOTE, PORTAL, FLYING_GLYPH, FLAME, LAVA_POP, FOOTSTEP, SPLASH, PARTICLE_SMOKE, EXPLOSION_HUGE, EXPLOSION_LARGE, EXPLOSION, VOID_FOG, SMALL_SMOKE, CLOUD, COLOURED_DUST, SNOWBALL_BREAK, WATERDRIP, LAVADRIP, SNOW_SHOVEL, SLIME, HEART, VILLAGER_THUNDERCLOUD, HAPPY_VILLAGER, LARGE_SMOKE, ITEM_BREAK, TILE_BREAK, TILE_DUST};
        BY_ID = Maps.newHashMap();
        BY_NAME = Maps.newHashMap();
        Effect[] effectArray = Effect.values();
        int n = effectArray.length;
        int n2 = 0;
        while (n2 < n) {
            effect = effectArray[n2];
            if (effect.type != Type.PARTICLE) {
                BY_ID.put(effect.id, effect);
            }
            ++n2;
        }
        effectArray = Effect.values();
        n = effectArray.length;
        n2 = 0;
        while (n2 < n) {
            effect = effectArray[n2];
            if (effect.type == Type.PARTICLE) {
                BY_NAME.put(effect.particleName, effect);
            }
            ++n2;
        }
    }

    private Effect(int id, Type type) {
        this(id, type, null);
    }

    private Effect(int id, Type type, Class<?> data) {
        this.id = id;
        this.type = type;
        this.data = data;
        this.particleName = null;
    }

    private Effect(String particleName, Type type, Class<?> data) {
        this.particleName = particleName;
        this.type = type;
        this.id = 0;
        this.data = data;
    }

    private Effect(String particleName, Type type) {
        this.particleName = particleName;
        this.type = type;
        this.id = 0;
        this.data = null;
    }

    @Deprecated
    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.particleName;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getData() {
        return this.data;
    }

    @Deprecated
    public static Effect getById(int id) {
        return BY_ID.get(id);
    }

    public static Effect getByName(String name) {
        return BY_NAME.get(name);
    }

    public static Effect[] values() {
        Effect[] effectArray = ENUM$VALUES;
        int n = effectArray.length;
        Effect[] effectArray2 = new Effect[n];
        System.arraycopy(ENUM$VALUES, 0, effectArray2, 0, n);
        return effectArray2;
    }

    public static Effect valueOf(String string) {
        return Enum.valueOf(Effect.class, string);
    }

    public static enum Type {
        SOUND,
        VISUAL,
        PARTICLE;

    }
}

