/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.event.BulkTableEvent;
import com.avaje.ebean.event.BulkTableEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEventListenerMap {
    private final HashMap<String, Entry> map = new HashMap();

    public BulkEventListenerMap(List<BulkTableEventListener> listeners) {
        if (listeners != null) {
            for (BulkTableEventListener l : listeners) {
                Set<String> tables = l.registeredTables();
                for (String tableName : tables) {
                    this.register(tableName, l);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void process(BulkTableEvent event) {
        Entry entry = this.map.get(event.getTableName());
        if (entry != null) {
            entry.process(event);
        }
    }

    private void register(String tableName, BulkTableEventListener l) {
        String upperTableName = tableName.trim().toUpperCase();
        Entry entry = this.map.get(upperTableName);
        if (entry == null) {
            entry = new Entry();
            this.map.put(upperTableName, entry);
        }
        entry.add(l);
    }

    private static class Entry {
        List<BulkTableEventListener> listeners = new ArrayList<BulkTableEventListener>();

        private Entry() {
        }

        private void add(BulkTableEventListener l) {
            this.listeners.add(l);
        }

        private void process(BulkTableEvent event) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).process(event);
            }
        }
    }
}

