/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import us.myles.ViaVersion.ViaManager;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.ViaAPI;
import us.myles.ViaVersion.api.command.ViaCommandSender;
import us.myles.ViaVersion.api.configuration.ConfigurationProvider;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.platform.TaskId;
import us.myles.ViaVersion.api.platform.ViaInjector;
import us.myles.ViaVersion.api.platform.ViaPlatform;
import us.myles.ViaVersion.api.platform.ViaPlatformLoader;
import us.myles.ViaVersion.bungee.commands.BungeeCommand;
import us.myles.ViaVersion.bungee.commands.BungeeCommandHandler;
import us.myles.ViaVersion.bungee.commands.BungeeCommandSender;
import us.myles.ViaVersion.bungee.platform.BungeeTaskId;
import us.myles.ViaVersion.bungee.platform.BungeeViaAPI;
import us.myles.ViaVersion.bungee.platform.BungeeViaConfig;
import us.myles.ViaVersion.bungee.platform.BungeeViaInjector;
import us.myles.ViaVersion.bungee.platform.BungeeViaLoader;
import us.myles.ViaVersion.bungee.service.ProtocolDetectorService;
import us.myles.ViaVersion.commands.ViaCommandHandler;
import us.myles.ViaVersion.dump.PluginInfo;
import us.myles.ViaVersion.util.GsonUtil;

public class BungeePlugin
extends Plugin
implements ViaPlatform,
Listener {
    private BungeeViaAPI api;
    private BungeeViaConfig config;
    private BungeeCommandHandler commandHandler;

    public void onLoad() {
        this.api = new BungeeViaAPI();
        this.config = new BungeeViaConfig(this.getDataFolder());
        this.commandHandler = new BungeeCommandHandler();
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeCommand(this.commandHandler));
        Via.init((ViaManager)ViaManager.builder().platform((ViaPlatform)this).injector((ViaInjector)new BungeeViaInjector()).loader((ViaPlatformLoader)new BungeeViaLoader(this)).commandHandler((ViaCommandHandler)this.commandHandler).build());
    }

    public void onEnable() {
        Via.getManager().init();
    }

    public String getPlatformName() {
        return this.getProxy().getName();
    }

    public String getPlatformVersion() {
        return this.getProxy().getVersion();
    }

    public String getPluginVersion() {
        return this.getDescription().getVersion();
    }

    public TaskId runAsync(Runnable runnable) {
        return new BungeeTaskId(this.getProxy().getScheduler().runAsync((Plugin)this, runnable).getId());
    }

    public TaskId runSync(Runnable runnable) {
        return this.runAsync(runnable);
    }

    public TaskId runSync(Runnable runnable, Long ticks) {
        return new BungeeTaskId(this.getProxy().getScheduler().schedule((Plugin)this, runnable, ticks * 50L, TimeUnit.MILLISECONDS).getId());
    }

    public TaskId runRepeatingSync(Runnable runnable, Long ticks) {
        return new BungeeTaskId(this.getProxy().getScheduler().schedule((Plugin)this, runnable, 0L, ticks * 50L, TimeUnit.MILLISECONDS).getId());
    }

    public void cancelTask(TaskId taskId) {
        if (taskId == null) {
            return;
        }
        if (taskId.getObject() == null) {
            return;
        }
        if (taskId instanceof BungeeTaskId) {
            this.getProxy().getScheduler().cancel(((Integer)taskId.getObject()).intValue());
        }
    }

    public ViaCommandSender[] getOnlinePlayers() {
        ViaCommandSender[] array = new ViaCommandSender[this.getProxy().getPlayers().size()];
        int i = 0;
        for (ProxiedPlayer player : this.getProxy().getPlayers()) {
            array[i++] = new BungeeCommandSender((CommandSender)player);
        }
        return array;
    }

    public void sendMessage(UUID uuid, String message) {
        this.getProxy().getPlayer(uuid).sendMessage(TextComponent.fromLegacyText((String)message));
    }

    public boolean kickPlayer(UUID uuid, String message) {
        if (this.getProxy().getPlayer(uuid) != null) {
            this.getProxy().getPlayer(uuid).disconnect(TextComponent.fromLegacyText((String)message));
            return true;
        }
        return false;
    }

    public boolean isPluginEnabled() {
        return true;
    }

    public ViaAPI getApi() {
        return this.api;
    }

    public BungeeViaConfig getConf() {
        return this.config;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.config;
    }

    public void onReload() {
    }

    public JsonObject getDump() {
        JsonObject platformSpecific = new JsonObject();
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
        for (Plugin p : ProxyServer.getInstance().getPluginManager().getPlugins()) {
            plugins.add(new PluginInfo(true, p.getDescription().getName(), p.getDescription().getVersion(), p.getDescription().getMain(), Arrays.asList(p.getDescription().getAuthor())));
        }
        platformSpecific.add("plugins", GsonUtil.getGson().toJsonTree(plugins));
        platformSpecific.add("servers", GsonUtil.getGson().toJsonTree(ProtocolDetectorService.getDetectedIds()));
        return platformSpecific;
    }

    public boolean isOldClientsAllowed() {
        return true;
    }

    @EventHandler
    public void onQuit(PlayerDisconnectEvent e) {
        UserConnection userConnection = (UserConnection)Via.getManager().getPortedPlayers().get(e.getPlayer().getUniqueId());
        if (!(userConnection == null || userConnection.getChannel() != null && userConnection.getChannel().isOpen())) {
            Via.getManager().removePortedClient(e.getPlayer().getUniqueId());
        }
    }
}

