/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.bungee.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.exception.CancelException;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.util.PipelineUtil;

@ChannelHandler.Sharable
public class BungeeDecodeHandler
extends MessageToMessageDecoder<ByteBuf> {
    private final UserConnection info;

    public BungeeDecodeHandler(UserConnection info) {
        this.info = info;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> out) throws Exception {
        if (bytebuf.readableBytes() > 0) {
            if (this.info.isPendingDisconnect()) {
                return;
            }
            boolean second = this.info.incrementReceived();
            if (second && this.info.handlePPS()) {
                return;
            }
            if (this.info.isActive()) {
                int id = (Integer)Type.VAR_INT.read(bytebuf);
                ByteBuf newPacket = ctx.alloc().buffer();
                try {
                    if (id == 1000) {
                        newPacket.writeBytes(bytebuf);
                    } else {
                        PacketWrapper wrapper = new PacketWrapper(id, bytebuf, this.info);
                        ProtocolInfo protInfo = (ProtocolInfo)this.info.get(ProtocolInfo.class);
                        protInfo.getPipeline().transform(Direction.INCOMING, protInfo.getState(), wrapper);
                        wrapper.writeToBuffer(newPacket);
                    }
                    bytebuf.clear();
                    bytebuf = newPacket;
                }
                catch (Throwable e) {
                    bytebuf.clear();
                    newPacket.release();
                    throw e;
                }
            } else {
                bytebuf.retain();
            }
            out.add(bytebuf);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (PipelineUtil.containsCause((Throwable)cause, CancelException.class)) {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

