/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.bungee.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.bungee.util.BungeePipelineUtil;
import us.myles.ViaVersion.exception.CancelException;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.util.PipelineUtil;

@ChannelHandler.Sharable
public class BungeeEncodeHandler
extends MessageToMessageEncoder<ByteBuf> {
    private final UserConnection info;
    private boolean handledCompression = false;

    public BungeeEncodeHandler(UserConnection info) {
        this.info = info;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> out) throws Exception {
        if (bytebuf.readableBytes() == 0) {
            throw new CancelException();
        }
        boolean needsCompress = false;
        if (!this.handledCompression && ctx.pipeline().names().indexOf("compress") > ctx.pipeline().names().indexOf("via-encoder")) {
            bytebuf = BungeePipelineUtil.decompress(ctx, bytebuf);
            ChannelHandler encoder = ctx.pipeline().get("via-decoder");
            ChannelHandler decoder = ctx.pipeline().get("via-encoder");
            ctx.pipeline().remove(encoder);
            ctx.pipeline().remove(decoder);
            ctx.pipeline().addAfter("decompress", "via-decoder", encoder);
            ctx.pipeline().addAfter("compress", "via-encoder", decoder);
            needsCompress = true;
            this.handledCompression = true;
        }
        this.info.incrementSent();
        if (this.info.isActive()) {
            int id = (Integer)Type.VAR_INT.read(bytebuf);
            ByteBuf oldPacket = bytebuf.copy();
            bytebuf.clear();
            try {
                PacketWrapper wrapper = new PacketWrapper(id, oldPacket, this.info);
                ProtocolInfo protInfo = (ProtocolInfo)this.info.get(ProtocolInfo.class);
                protInfo.getPipeline().transform(Direction.OUTGOING, protInfo.getState(), wrapper);
                wrapper.writeToBuffer(bytebuf);
            }
            catch (Throwable e) {
                bytebuf.clear();
                throw e;
            }
            finally {
                oldPacket.release();
            }
        }
        if (needsCompress) {
            ByteBuf old = bytebuf;
            bytebuf = BungeePipelineUtil.compress(ctx, bytebuf);
            old.release();
            out.add(bytebuf);
        } else {
            out.add(bytebuf.retain());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (PipelineUtil.containsCause((Throwable)cause, CancelException.class)) {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

