/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.bungee.platform;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import lombok.NonNull;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.ViaAPI;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.bungee.platform.BungeeBossBar;
import us.myles.ViaVersion.bungee.service.ProtocolDetectorService;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public class BungeeViaAPI
implements ViaAPI<ProxiedPlayer> {
    public int getPlayerVersion(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked @NonNull but is null");
        }
        if (!this.isPorted(player.getUniqueId())) {
            return player.getPendingConnection().getVersion();
        }
        return ((ProtocolInfo)this.getPortedPlayers().get(player.getUniqueId()).get(ProtocolInfo.class)).getProtocolVersion();
    }

    public int getPlayerVersion(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        if (!this.isPorted(uuid)) {
            ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
            if (player != null) {
                return player.getPendingConnection().getVersion();
            }
            return ProtocolRegistry.SERVER_PROTOCOL;
        }
        return ((ProtocolInfo)this.getPortedPlayers().get(uuid).get(ProtocolInfo.class)).getProtocolVersion();
    }

    public boolean isPorted(UUID playerUUID) {
        return this.getPortedPlayers().containsKey(playerUUID);
    }

    public String getVersion() {
        return Via.getPlatform().getPluginVersion();
    }

    public void sendRawPacket(UUID uuid, ByteBuf packet) throws IllegalArgumentException {
        if (!this.isPorted(uuid)) {
            throw new IllegalArgumentException("This player is not controlled by ViaVersion!");
        }
        UserConnection ci = this.getPortedPlayers().get(uuid);
        ci.sendRawPacket(packet);
    }

    public void sendRawPacket(ProxiedPlayer player, ByteBuf packet) throws IllegalArgumentException {
        this.sendRawPacket(player.getUniqueId(), packet);
    }

    public BossBar createBossBar(String title, BossColor color, BossStyle style) {
        return new BungeeBossBar(title, 1.0f, color, style);
    }

    public BossBar createBossBar(String title, float health, BossColor color, BossStyle style) {
        return new BungeeBossBar(title, health, color, style);
    }

    public SortedSet<Integer> getSupportedVersions() {
        TreeSet<Integer> outputSet = new TreeSet<Integer>(ProtocolRegistry.getSupportedVersions());
        outputSet.removeAll(Via.getPlatform().getConf().getBlockedProtocols());
        return outputSet;
    }

    public Map<UUID, UserConnection> getPortedPlayers() {
        return Via.getManager().getPortedPlayers();
    }

    public void probeServer(ServerInfo serverInfo) {
        ProtocolDetectorService.probeServer(serverInfo);
    }
}

