/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.bungee.platform;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import us.myles.ViaVersion.api.ViaVersionConfig;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.bungee.providers.BungeeVersionProvider;
import us.myles.ViaVersion.util.Config;

public class BungeeViaConfig
extends Config
implements ViaVersionConfig {
    private static List<String> UNSUPPORTED = Arrays.asList("nms-player-ticking", "item-cache", "anti-xray-patch", "quick-move-action-fix", "velocity-ping-interval", "velocity-ping-save", "velocity-servers", "blockconnection-method");

    public BungeeViaConfig(File configFile) {
        super(new File(configFile, "config.yml"));
        this.reloadConfig();
    }

    public URL getDefaultConfigURL() {
        return BungeeViaConfig.class.getClassLoader().getResource("assets/viaversion/config.yml");
    }

    protected void handleConfig(Map<String, Object> config) {
        Map servers = !(config.get("bungee-servers") instanceof Map) ? new HashMap() : (Map)config.get("bungee-servers");
        for (Map.Entry entry : new HashSet(servers.entrySet())) {
            if (entry.getValue() instanceof Integer) continue;
            if (entry.getValue() instanceof String) {
                ProtocolVersion found = ProtocolVersion.getClosest((String)((String)entry.getValue()));
                if (found != null) {
                    servers.put(entry.getKey(), found.getId());
                    continue;
                }
                servers.remove(entry.getKey());
                continue;
            }
            servers.remove(entry.getKey());
        }
        if (!servers.containsKey("default")) {
            servers.put("default", BungeeVersionProvider.getLowestSupportedVersion());
        }
        config.put("bungee-servers", servers);
    }

    public List<String> getUnsupportedOptions() {
        return UNSUPPORTED;
    }

    public boolean isCheckForUpdates() {
        return this.getBoolean("checkforupdates", true);
    }

    public boolean isPreventCollision() {
        return this.getBoolean("prevent-collision", true);
    }

    public boolean isNewEffectIndicator() {
        return this.getBoolean("use-new-effect-indicator", true);
    }

    public boolean isShowNewDeathMessages() {
        return this.getBoolean("use-new-deathmessages", true);
    }

    public boolean isSuppressMetadataErrors() {
        return this.getBoolean("suppress-metadata-errors", false);
    }

    public boolean isShieldBlocking() {
        return this.getBoolean("shield-blocking", true);
    }

    public boolean isHologramPatch() {
        return this.getBoolean("hologram-patch", false);
    }

    public boolean isPistonAnimationPatch() {
        return this.getBoolean("piston-animation-patch", false);
    }

    public boolean isBossbarPatch() {
        return this.getBoolean("bossbar-patch", true);
    }

    public boolean isBossbarAntiflicker() {
        return this.getBoolean("bossbar-anti-flicker", false);
    }

    public boolean isUnknownEntitiesSuppressed() {
        return false;
    }

    public double getHologramYOffset() {
        return this.getDouble("hologram-y", -0.96);
    }

    public boolean isBlockBreakPatch() {
        return false;
    }

    public int getMaxPPS() {
        return this.getInt("max-pps", 800);
    }

    public String getMaxPPSKickMessage() {
        return this.getString("max-pps-kick-msg", "Sending packets too fast? lag?");
    }

    public int getTrackingPeriod() {
        return this.getInt("tracking-period", 6);
    }

    public int getWarningPPS() {
        return this.getInt("tracking-warning-pps", 120);
    }

    public int getMaxWarnings() {
        return this.getInt("tracking-max-warnings", 3);
    }

    public String getMaxWarningsKickMessage() {
        return this.getString("tracking-max-kick-msg", "You are sending too many packets, :(");
    }

    public boolean isAntiXRay() {
        return false;
    }

    public boolean isSendSupportedVersions() {
        return this.getBoolean("send-supported-versions", false);
    }

    public boolean isStimulatePlayerTick() {
        return this.getBoolean("simulate-pt", true);
    }

    public boolean isItemCache() {
        return false;
    }

    public boolean isNMSPlayerTicking() {
        return false;
    }

    public boolean isReplacePistons() {
        return this.getBoolean("replace-pistons", false);
    }

    public int getPistonReplacementId() {
        return this.getInt("replacement-piston-id", 0);
    }

    public boolean isAutoTeam() {
        return this.isPreventCollision() && this.getBoolean("auto-team", true);
    }

    public boolean isForceJsonTransform() {
        return this.getBoolean("force-json-transform", false);
    }

    public boolean is1_12NBTArrayFix() {
        return this.getBoolean("chat-nbt-fix", true);
    }

    public boolean is1_12QuickMoveActionFix() {
        return false;
    }

    public List<Integer> getBlockedProtocols() {
        return this.getIntegerList("block-protocols");
    }

    public String getBlockedDisconnectMsg() {
        return this.getString("block-disconnect-msg", "You are using an unsupported Minecraft version!");
    }

    public String getReloadDisconnectMsg() {
        return this.getString("reload-disconnect-msg", "Server reload, please rejoin!");
    }

    public boolean isMinimizeCooldown() {
        return this.getBoolean("minimize-cooldown", true);
    }

    public int getBungeePingInterval() {
        return this.getInt("bungee-ping-interval", 60);
    }

    public boolean isBungeePingSave() {
        return this.getBoolean("bungee-ping-save", true);
    }

    public Map<String, Integer> getBungeeServerProtocols() {
        return (Map)this.get("bungee-servers", Map.class, new HashMap());
    }

    public boolean is1_13TeamColourFix() {
        return this.getBoolean("team-colour-fix", true);
    }

    public boolean isSuppress1_13ConversionErrors() {
        return this.getBoolean("suppress-1_13-conversion-errors", false);
    }

    public boolean isDisable1_13AutoComplete() {
        return this.getBoolean("disable-1_13-auto-complete", false);
    }

    public boolean isServersideBlockConnections() {
        return this.getBoolean("serverside-blockconnections", false);
    }

    public String getBlockConnectionMethod() {
        return "packet";
    }

    public boolean isReduceBlockStorageMemory() {
        return this.getBoolean("reduce-blockstorage-memory", false);
    }

    public boolean isStemWhenBlockAbove() {
        return this.getBoolean("flowerstem-when-block-above", false);
    }

    public boolean isSnowCollisionFix() {
        return this.getBoolean("fix-low-snow-collision", false);
    }

    public int get1_13TabCompleteDelay() {
        return this.getInt("1_13-tab-complete-delay", 0);
    }

    public boolean isLeftHandedHandling() {
        return this.getBoolean("left-handed-handling", true);
    }
}

