/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.bungee.platform;

import com.google.gson.JsonObject;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.util.List;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.platform.ViaInjector;
import us.myles.ViaVersion.bungee.handlers.BungeeChannelInitializer;
import us.myles.ViaVersion.util.ReflectionUtil;

public class BungeeViaInjector
implements ViaInjector {
    public void inject() throws Exception {
        try {
            try {
                Class<?> pipelineUtils = Class.forName("net.md_5.bungee.netty.PipelineUtils");
                Field field = pipelineUtils.getDeclaredField("SERVER_CHILD");
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                BungeeChannelInitializer newInit = new BungeeChannelInitializer((ChannelInitializer<Channel>)((ChannelInitializer)field.get(null)));
                field.set(null, (Object)newInit);
            }
            catch (NoSuchFieldException e) {
                throw new Exception("Unable to find core component 'childHandler', please check your plugins. issue: ");
            }
        }
        catch (Exception e) {
            Via.getPlatform().getLogger().severe("Unable to inject ViaVersion, please post these details on our GitHub and ensure you're using a compatible server version.");
            throw e;
        }
    }

    public void uninject() {
        Via.getPlatform().getLogger().severe("ViaVersion cannot remove itself from Bungee without a reboot!");
    }

    public int getServerProtocolVersion() throws Exception {
        return (Integer)((List)ReflectionUtil.getStatic(Class.forName("net.md_5.bungee.protocol.ProtocolConstants"), (String)"SUPPORTED_VERSION_IDS", List.class)).get(0);
    }

    public String getEncoderName() {
        return "via-encoder";
    }

    public String getDecoderName() {
        return "via-decoder";
    }

    private ChannelInitializer<Channel> getChannelInitializer() throws Exception {
        Class<?> pipelineUtils = Class.forName("net.md_5.bungee.netty.PipelineUtils");
        Field field = pipelineUtils.getDeclaredField("SERVER_CHILD");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        return (ChannelInitializer)field.get(null);
    }

    public JsonObject getDump() {
        JsonObject data = new JsonObject();
        try {
            ChannelInitializer<Channel> initializer = this.getChannelInitializer();
            data.addProperty("currentInitializer", initializer.getClass().getName());
            if (initializer instanceof BungeeChannelInitializer) {
                data.addProperty("originalInitializer", ((BungeeChannelInitializer)initializer).getOriginal().getClass().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

