/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api;

import java.util.UUID;
import lombok.NonNull;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public abstract class ViaListener {
    private final Class<? extends Protocol> requiredPipeline;
    private boolean registered = false;

    protected UserConnection getUserConnection(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        return Via.getManager().getConnection(uuid);
    }

    protected boolean isOnPipe(UUID uuid) {
        UserConnection userConnection = this.getUserConnection(uuid);
        return userConnection != null && userConnection.get(ProtocolInfo.class).getPipeline().contains(this.requiredPipeline);
    }

    public abstract void register();

    protected Class<? extends Protocol> getRequiredPipeline() {
        return this.requiredPipeline;
    }

    protected boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public ViaListener(Class<? extends Protocol> requiredPipeline) {
        this.requiredPipeline = requiredPipeline;
    }
}

