/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.data;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.ViaVersionConfig;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.util.PipelineUtil;

public class UserConnection {
    @NonNull
    private final Channel channel;
    Map<Class, StoredObject> storedObjects = new ConcurrentHashMap<Class, StoredObject>();
    private boolean active = true;
    private boolean pendingDisconnect = false;
    private Object lastPacket;
    private long sentPackets = 0L;
    private long receivedPackets = 0L;
    private long startTime = 0L;
    private long intervalPackets = 0L;
    private long packetsPerSecond = -1L;
    private int secondsObserved = 0;
    private int warnings = 0;
    private ReadWriteLock velocityLock = new ReentrantReadWriteLock();

    public UserConnection(Channel channel) {
        this.channel = channel;
    }

    public <T extends StoredObject> T get(Class<T> objectClass) {
        return (T)this.storedObjects.get(objectClass);
    }

    public boolean has(Class<? extends StoredObject> objectClass) {
        return this.storedObjects.containsKey(objectClass);
    }

    public void put(StoredObject object) {
        this.storedObjects.put(object.getClass(), object);
    }

    public void clearStoredObjects() {
        this.storedObjects.clear();
    }

    public void sendRawPacket(final ByteBuf packet, boolean currentThread) {
        final ChannelHandler handler = this.channel.pipeline().get(Via.getManager().getInjector().getEncoderName());
        if (currentThread) {
            this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
        } else {
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    UserConnection.this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
                }
            });
        }
    }

    public ChannelFuture sendRawPacketFuture(ByteBuf packet) {
        ChannelHandler handler = this.channel.pipeline().get(Via.getManager().getInjector().getEncoderName());
        ChannelFuture future = this.channel.pipeline().context(handler).writeAndFlush((Object)packet);
        return future;
    }

    public void sendRawPacket(ByteBuf packet) {
        this.sendRawPacket(packet, false);
    }

    public void incrementSent() {
        ++this.sentPackets;
    }

    public boolean incrementReceived() {
        long diff = System.currentTimeMillis() - this.startTime;
        if (diff >= 1000L) {
            this.packetsPerSecond = this.intervalPackets;
            this.startTime = System.currentTimeMillis();
            this.intervalPackets = 1L;
            return true;
        }
        ++this.intervalPackets;
        ++this.receivedPackets;
        return false;
    }

    public boolean handlePPS() {
        ViaVersionConfig conf = Via.getConfig();
        if (conf.getMaxPPS() > 0 && this.getPacketsPerSecond() >= (long)conf.getMaxPPS()) {
            this.disconnect(conf.getMaxPPSKickMessage().replace("%pps", Long.toString(this.getPacketsPerSecond())));
            return true;
        }
        if (conf.getMaxWarnings() > 0 && conf.getTrackingPeriod() > 0) {
            if (this.getSecondsObserved() > conf.getTrackingPeriod()) {
                this.setWarnings(0);
                this.setSecondsObserved(1);
            } else {
                this.setSecondsObserved(this.getSecondsObserved() + 1);
                if (this.getPacketsPerSecond() >= (long)conf.getWarningPPS()) {
                    this.setWarnings(this.getWarnings() + 1);
                }
                if (this.getWarnings() >= conf.getMaxWarnings()) {
                    this.disconnect(conf.getMaxWarningsKickMessage().replace("%pps", Long.toString(this.getPacketsPerSecond())));
                    return true;
                }
            }
        }
        return false;
    }

    public void disconnect(final String reason) {
        if (!this.getChannel().isOpen()) {
            return;
        }
        if (this.pendingDisconnect) {
            return;
        }
        this.pendingDisconnect = true;
        if (this.get(ProtocolInfo.class).getUuid() != null) {
            final UUID uuid = this.get(ProtocolInfo.class).getUuid();
            Via.getPlatform().runSync(new Runnable(){

                @Override
                public void run() {
                    if (!Via.getPlatform().kickPlayer(uuid, ChatColor.translateAlternateColorCodes((char)'&', (String)reason))) {
                        UserConnection.this.getChannel().close();
                    }
                }
            });
        }
    }

    public void sendRawPacketToServer(ByteBuf packet, boolean currentThread) {
        final ByteBuf buf = packet.alloc().buffer();
        try {
            Type.VAR_INT.write(buf, 1000);
        }
        catch (Exception e) {
            Via.getPlatform().getLogger().warning("Type.VAR_INT.write thrown an exception: " + e);
        }
        buf.writeBytes(packet);
        packet.release();
        final ChannelHandlerContext context = PipelineUtil.getPreviousContext(Via.getManager().getInjector().getDecoderName(), this.getChannel().pipeline());
        if (currentThread) {
            if (context != null) {
                context.fireChannelRead((Object)buf);
            } else {
                this.getChannel().pipeline().fireChannelRead((Object)buf);
            }
        } else {
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    if (context != null) {
                        context.fireChannelRead((Object)buf);
                    } else {
                        UserConnection.this.getChannel().pipeline().fireChannelRead((Object)buf);
                    }
                }
            });
        }
    }

    public void sendRawPacketToServer(ByteBuf packet) {
        this.sendRawPacketToServer(packet, false);
    }

    @NonNull
    public Channel getChannel() {
        return this.channel;
    }

    public Map<Class, StoredObject> getStoredObjects() {
        return this.storedObjects;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPendingDisconnect() {
        return this.pendingDisconnect;
    }

    public Object getLastPacket() {
        return this.lastPacket;
    }

    public long getSentPackets() {
        return this.sentPackets;
    }

    public long getReceivedPackets() {
        return this.receivedPackets;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getIntervalPackets() {
        return this.intervalPackets;
    }

    public long getPacketsPerSecond() {
        return this.packetsPerSecond;
    }

    public int getSecondsObserved() {
        return this.secondsObserved;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public ReadWriteLock getVelocityLock() {
        return this.velocityLock;
    }

    public void setStoredObjects(Map<Class, StoredObject> storedObjects) {
        this.storedObjects = storedObjects;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setPendingDisconnect(boolean pendingDisconnect) {
        this.pendingDisconnect = pendingDisconnect;
    }

    public void setLastPacket(Object lastPacket) {
        this.lastPacket = lastPacket;
    }

    public void setSentPackets(long sentPackets) {
        this.sentPackets = sentPackets;
    }

    public void setReceivedPackets(long receivedPackets) {
        this.receivedPackets = receivedPackets;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setIntervalPackets(long intervalPackets) {
        this.intervalPackets = intervalPackets;
    }

    public void setPacketsPerSecond(long packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
    }

    public void setSecondsObserved(int secondsObserved) {
        this.secondsObserved = secondsObserved;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public void setVelocityLock(ReadWriteLock velocityLock) {
        this.velocityLock = velocityLock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserConnection)) {
            return false;
        }
        UserConnection other = (UserConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Map<Class, StoredObject> this$storedObjects = this.getStoredObjects();
        Map<Class, StoredObject> other$storedObjects = other.getStoredObjects();
        if (this$storedObjects == null ? other$storedObjects != null : !((Object)this$storedObjects).equals(other$storedObjects)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isPendingDisconnect() != other.isPendingDisconnect()) {
            return false;
        }
        Object this$lastPacket = this.getLastPacket();
        Object other$lastPacket = other.getLastPacket();
        if (this$lastPacket == null ? other$lastPacket != null : !this$lastPacket.equals(other$lastPacket)) {
            return false;
        }
        if (this.getSentPackets() != other.getSentPackets()) {
            return false;
        }
        if (this.getReceivedPackets() != other.getReceivedPackets()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getIntervalPackets() != other.getIntervalPackets()) {
            return false;
        }
        if (this.getPacketsPerSecond() != other.getPacketsPerSecond()) {
            return false;
        }
        if (this.getSecondsObserved() != other.getSecondsObserved()) {
            return false;
        }
        if (this.getWarnings() != other.getWarnings()) {
            return false;
        }
        ReadWriteLock this$velocityLock = this.getVelocityLock();
        ReadWriteLock other$velocityLock = other.getVelocityLock();
        return !(this$velocityLock == null ? other$velocityLock != null : !this$velocityLock.equals(other$velocityLock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Map<Class, StoredObject> $storedObjects = this.getStoredObjects();
        result = result * 59 + ($storedObjects == null ? 43 : ((Object)$storedObjects).hashCode());
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isPendingDisconnect() ? 79 : 97);
        Object $lastPacket = this.getLastPacket();
        result = result * 59 + ($lastPacket == null ? 43 : $lastPacket.hashCode());
        long $sentPackets = this.getSentPackets();
        result = result * 59 + (int)($sentPackets >>> 32 ^ $sentPackets);
        long $receivedPackets = this.getReceivedPackets();
        result = result * 59 + (int)($receivedPackets >>> 32 ^ $receivedPackets);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $intervalPackets = this.getIntervalPackets();
        result = result * 59 + (int)($intervalPackets >>> 32 ^ $intervalPackets);
        long $packetsPerSecond = this.getPacketsPerSecond();
        result = result * 59 + (int)($packetsPerSecond >>> 32 ^ $packetsPerSecond);
        result = result * 59 + this.getSecondsObserved();
        result = result * 59 + this.getWarnings();
        ReadWriteLock $velocityLock = this.getVelocityLock();
        result = result * 59 + ($velocityLock == null ? 43 : $velocityLock.hashCode());
        return result;
    }

    public String toString() {
        return "UserConnection(channel=" + this.getChannel() + ", storedObjects=" + this.getStoredObjects() + ", active=" + this.isActive() + ", pendingDisconnect=" + this.isPendingDisconnect() + ", lastPacket=" + this.getLastPacket() + ", sentPackets=" + this.getSentPackets() + ", receivedPackets=" + this.getReceivedPackets() + ", startTime=" + this.getStartTime() + ", intervalPackets=" + this.getIntervalPackets() + ", packetsPerSecond=" + this.getPacketsPerSecond() + ", secondsObserved=" + this.getSecondsObserved() + ", warnings=" + this.getWarnings() + ", velocityLock=" + this.getVelocityLock() + ")";
    }
}

