/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.minecraft.chunks;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import java.util.Arrays;
import java.util.List;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;

public class BaseChunk
implements Chunk {
    protected int x;
    protected int z;
    protected boolean groundUp;
    protected int bitmask;
    protected ChunkSection[] sections;
    protected int[] biomeData;
    protected List<CompoundTag> blockEntities;

    @Override
    public boolean isBiomeData() {
        return this.biomeData != null;
    }

    public BaseChunk(int x, int z, boolean groundUp, int bitmask, ChunkSection[] sections, int[] biomeData, List<CompoundTag> blockEntities) {
        this.x = x;
        this.z = z;
        this.groundUp = groundUp;
        this.bitmask = bitmask;
        this.sections = sections;
        this.biomeData = biomeData;
        this.blockEntities = blockEntities;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public boolean isGroundUp() {
        return this.groundUp;
    }

    @Override
    public int getBitmask() {
        return this.bitmask;
    }

    @Override
    public ChunkSection[] getSections() {
        return this.sections;
    }

    @Override
    public int[] getBiomeData() {
        return this.biomeData;
    }

    @Override
    public List<CompoundTag> getBlockEntities() {
        return this.blockEntities;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setGroundUp(boolean groundUp) {
        this.groundUp = groundUp;
    }

    public void setBitmask(int bitmask) {
        this.bitmask = bitmask;
    }

    public void setSections(ChunkSection[] sections) {
        this.sections = sections;
    }

    public void setBiomeData(int[] biomeData) {
        this.biomeData = biomeData;
    }

    public void setBlockEntities(List<CompoundTag> blockEntities) {
        this.blockEntities = blockEntities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseChunk)) {
            return false;
        }
        BaseChunk other = (BaseChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        if (this.isGroundUp() != other.isGroundUp()) {
            return false;
        }
        if (this.getBitmask() != other.getBitmask()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSections(), other.getSections())) {
            return false;
        }
        if (!Arrays.equals(this.getBiomeData(), other.getBiomeData())) {
            return false;
        }
        List<CompoundTag> this$blockEntities = this.getBlockEntities();
        List<CompoundTag> other$blockEntities = other.getBlockEntities();
        return !(this$blockEntities == null ? other$blockEntities != null : !((Object)this$blockEntities).equals(other$blockEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        result = result * 59 + (this.isGroundUp() ? 79 : 97);
        result = result * 59 + this.getBitmask();
        result = result * 59 + Arrays.deepHashCode(this.getSections());
        result = result * 59 + Arrays.hashCode(this.getBiomeData());
        List<CompoundTag> $blockEntities = this.getBlockEntities();
        result = result * 59 + ($blockEntities == null ? 43 : ((Object)$blockEntities).hashCode());
        return result;
    }

    public String toString() {
        return "BaseChunk(x=" + this.getX() + ", z=" + this.getZ() + ", groundUp=" + this.isGroundUp() + ", bitmask=" + this.getBitmask() + ", sections=" + Arrays.deepToString(this.getSections()) + ", biomeData=" + Arrays.toString(this.getBiomeData()) + ", blockEntities=" + this.getBlockEntities() + ")";
    }
}

