/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.minecraft.chunks;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.myles.ViaVersion.api.minecraft.chunks.NibbleArray;

public class ChunkSection {
    public static final int SIZE = 4096;
    public static final int LIGHT_LENGTH = 2048;
    private List<Integer> palette = new ArrayList<Integer>();
    private Map<Integer, Integer> inversePalette = new HashMap<Integer, Integer>();
    private final int[] blocks = new int[4096];
    private NibbleArray blockLight = new NibbleArray(4096);
    private NibbleArray skyLight;
    private int nonAirBlocksCount;

    public ChunkSection() {
        this.addPaletteEntry(0);
    }

    public void setBlock(int x, int y, int z, int type, int data) {
        this.setFlatBlock(ChunkSection.index(x, y, z), type << 4 | data & 0xF);
    }

    public void setFlatBlock(int x, int y, int z, int type) {
        this.setFlatBlock(ChunkSection.index(x, y, z), type);
    }

    public int getBlockId(int x, int y, int z) {
        return this.getFlatBlock(x, y, z) >> 4;
    }

    public int getBlockData(int x, int y, int z) {
        return this.getFlatBlock(x, y, z) & 0xF;
    }

    public int getFlatBlock(int x, int y, int z) {
        int index = this.blocks[ChunkSection.index(x, y, z)];
        return this.palette.get(index);
    }

    public int getFlatBlock(int idx) {
        int index = this.blocks[idx];
        return this.palette.get(index);
    }

    public void setBlock(int idx, int type, int data) {
        this.setFlatBlock(idx, type << 4 | data & 0xF);
    }

    public void setPaletteIndex(int idx, int index) {
        this.blocks[idx] = index;
    }

    public int getPaletteIndex(int idx) {
        return this.blocks[idx];
    }

    public int getPaletteSize() {
        return this.palette.size();
    }

    public int getPaletteEntry(int index) {
        if (index < 0 || index >= this.palette.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.palette.get(index);
    }

    public void setPaletteEntry(int index, int id) {
        if (index < 0 || index >= this.palette.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.palette.set(index, id);
        this.inversePalette.put(id, index);
    }

    public void replacePaletteEntry(int oldId, int newId) {
        Integer index = this.inversePalette.remove(oldId);
        if (index == null) {
            return;
        }
        this.inversePalette.put(newId, index);
        for (int i = 0; i < this.palette.size(); ++i) {
            if (this.palette.get(i) != oldId) continue;
            this.palette.set(i, newId);
        }
    }

    public void addPaletteEntry(int id) {
        this.inversePalette.put(id, this.palette.size());
        this.palette.add(id);
    }

    public void clearPalette() {
        this.palette.clear();
        this.inversePalette.clear();
    }

    public void setFlatBlock(int idx, int id) {
        Integer index = this.inversePalette.get(id);
        if (index == null) {
            index = this.palette.size();
            this.palette.add(id);
            this.inversePalette.put(id, index);
        }
        this.blocks[idx] = index;
    }

    public void setBlockLight(byte[] data) {
        if (data.length != 2048) {
            throw new IllegalArgumentException("Data length != 2048");
        }
        if (this.blockLight == null) {
            this.blockLight = new NibbleArray(data);
        } else {
            this.blockLight.setHandle(data);
        }
    }

    public void setSkyLight(byte[] data) {
        if (data.length != 2048) {
            throw new IllegalArgumentException("Data length != 2048");
        }
        if (this.skyLight == null) {
            this.skyLight = new NibbleArray(data);
        } else {
            this.skyLight.setHandle(data);
        }
    }

    public byte[] getBlockLight() {
        return this.blockLight == null ? null : this.blockLight.getHandle();
    }

    public byte[] getSkyLight() {
        return this.skyLight == null ? null : this.skyLight.getHandle();
    }

    public void readBlockLight(ByteBuf input) {
        if (this.blockLight == null) {
            this.blockLight = new NibbleArray(4096);
        }
        input.readBytes(this.blockLight.getHandle());
    }

    public void readSkyLight(ByteBuf input) {
        if (this.skyLight == null) {
            this.skyLight = new NibbleArray(4096);
        }
        input.readBytes(this.skyLight.getHandle());
    }

    private static int index(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public void writeBlockLight(ByteBuf output) {
        output.writeBytes(this.blockLight.getHandle());
    }

    public void writeSkyLight(ByteBuf output) {
        output.writeBytes(this.skyLight.getHandle());
    }

    public boolean hasSkyLight() {
        return this.skyLight != null;
    }

    public boolean hasBlockLight() {
        return this.blockLight != null;
    }

    public int getNonAirBlocksCount() {
        return this.nonAirBlocksCount;
    }

    public void setNonAirBlocksCount(int nonAirBlocksCount) {
        this.nonAirBlocksCount = nonAirBlocksCount;
    }
}

