/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.platform.ViaPlatform;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.packets.PacketType;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public class ProtocolPipeline
extends Protocol {
    private List<Protocol> protocolList;
    private UserConnection userConnection;

    public ProtocolPipeline(UserConnection userConnection) {
        this.init(userConnection);
    }

    @Override
    protected void registerPackets() {
        this.protocolList = new CopyOnWriteArrayList<Protocol>();
        this.protocolList.add(ProtocolRegistry.BASE_PROTOCOL);
    }

    @Override
    public void init(UserConnection userConnection) {
        this.userConnection = userConnection;
        ProtocolInfo protocolInfo = new ProtocolInfo(userConnection);
        protocolInfo.setPipeline(this);
        userConnection.put(protocolInfo);
        for (Protocol protocol : this.protocolList) {
            protocol.init(userConnection);
        }
    }

    public void add(Protocol protocol) {
        ArrayList<Protocol> toMove;
        if (this.protocolList != null) {
            this.protocolList.add(protocol);
            protocol.init(this.userConnection);
            toMove = new ArrayList<Protocol>();
            for (Protocol p : this.protocolList) {
                if (!ProtocolRegistry.isBaseProtocol(p)) continue;
                toMove.add(p);
            }
        } else {
            throw new NullPointerException("Tried to add protocol to early");
        }
        this.protocolList.removeAll(toMove);
        this.protocolList.addAll(toMove);
    }

    @Override
    public void transform(Direction direction, State state, PacketWrapper packetWrapper) throws Exception {
        int originalID = packetWrapper.getId();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(this.protocolList);
        if (direction == Direction.OUTGOING) {
            Collections.reverse(protocols);
        }
        packetWrapper.apply(direction, state, 0, protocols);
        super.transform(direction, state, packetWrapper);
        if (Via.getManager().isDebug()) {
            String packet = "UNKNOWN";
            int serverProtocol = this.userConnection.get(ProtocolInfo.class).getServerProtocolVersion();
            int clientProtocol = this.userConnection.get(ProtocolInfo.class).getProtocolVersion();
            if (serverProtocol >= ProtocolVersion.v1_8.getId() && serverProtocol <= ProtocolVersion.v1_9_3.getId()) {
                PacketType type = serverProtocol <= ProtocolVersion.v1_8.getId() ? (direction == Direction.INCOMING ? PacketType.findNewPacket(state, direction, originalID) : PacketType.findOldPacket(state, direction, originalID)) : PacketType.findNewPacket(state, direction, originalID);
                if (type != null) {
                    if (type == PacketType.PLAY_CHUNK_DATA) {
                        return;
                    }
                    if (type == PacketType.PLAY_TIME_UPDATE) {
                        return;
                    }
                    if (type == PacketType.PLAY_KEEP_ALIVE) {
                        return;
                    }
                    if (type == PacketType.PLAY_KEEP_ALIVE_REQUEST) {
                        return;
                    }
                    if (type == PacketType.PLAY_ENTITY_LOOK_MOVE) {
                        return;
                    }
                    if (type == PacketType.PLAY_ENTITY_LOOK) {
                        return;
                    }
                    if (type == PacketType.PLAY_ENTITY_RELATIVE_MOVE) {
                        return;
                    }
                    if (type == PacketType.PLAY_PLAYER_POSITION_LOOK_REQUEST) {
                        return;
                    }
                    if (type == PacketType.PLAY_PLAYER_LOOK_REQUEST) {
                        return;
                    }
                    if (type == PacketType.PLAY_PLAYER_POSITION_REQUEST) {
                        return;
                    }
                    packet = type.name();
                }
            }
            String name = packet + "[" + clientProtocol + "]";
            ViaPlatform platform = Via.getPlatform();
            String actualUsername = packetWrapper.user().get(ProtocolInfo.class).getUsername();
            String username = actualUsername != null ? actualUsername + " " : "";
            platform.getLogger().log(Level.INFO, "{0}{1}: {2} {3} -> {4} [{5}] Value: {6}", new Object[]{username, direction, state, originalID, packetWrapper.getId(), name, packetWrapper});
        }
    }

    public boolean contains(Class<? extends Protocol> pipeClass) {
        for (Protocol protocol : this.protocolList) {
            if (!protocol.getClass().equals(pipeClass)) continue;
            return true;
        }
        return false;
    }

    public boolean filter(Object o, List list) throws Exception {
        for (Protocol protocol : this.protocolList) {
            if (!protocol.isFiltered(o.getClass())) continue;
            protocol.filterPacket(this.userConnection, o, list);
            return true;
        }
        return false;
    }

    public List<Protocol> pipes() {
        return this.protocolList;
    }

    public void cleanPipes() {
        this.pipes().clear();
        this.registerPackets();
    }
}

