/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.protocols.base.BaseProtocol;
import us.myles.ViaVersion.protocols.base.BaseProtocol1_7;
import us.myles.ViaVersion.protocols.protocol1_10to1_9_3.Protocol1_10To1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_11_1to1_11.Protocol1_11_1To1_11;
import us.myles.ViaVersion.protocols.protocol1_11to1_10.Protocol1_11To1_10;
import us.myles.ViaVersion.protocols.protocol1_12_1to1_12.Protocol1_12_1To1_12;
import us.myles.ViaVersion.protocols.protocol1_12_2to1_12_1.Protocol1_12_2To1_12_1;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.Protocol1_12To1_11_1;
import us.myles.ViaVersion.protocols.protocol1_13_1to1_13.Protocol1_13_1To1_13;
import us.myles.ViaVersion.protocols.protocol1_13_2to1_13_1.Protocol1_13_2To1_13_1;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.Protocol1_13To1_12_2;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.Protocol1_9_1_2To1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9_1to1_9.Protocol1_9_1To1_9;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.Protocol1_9_3To1_9_1_2;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_9_1.Protocol1_9To1_9_1;

public class ProtocolRegistry {
    public static final Protocol BASE_PROTOCOL = new BaseProtocol();
    public static int SERVER_PROTOCOL = -1;
    private static final Map<Integer, Map<Integer, Protocol>> registryMap = new ConcurrentHashMap<Integer, Map<Integer, Protocol>>();
    private static final Map<Pair<Integer, Integer>, List<Pair<Integer, Protocol>>> pathCache = new ConcurrentHashMap<Pair<Integer, Integer>, List<Pair<Integer, Protocol>>>();
    private static final List<Protocol> registerList = Lists.newCopyOnWriteArrayList();
    private static final Set<Integer> supportedVersions = Sets.newConcurrentHashSet();
    private static final List<Pair<Range<Integer>, Protocol>> baseProtocols = Lists.newCopyOnWriteArrayList();

    public static void registerProtocol(Protocol protocol, List<Integer> supported, Integer output) {
        if (pathCache.size() > 0) {
            pathCache.clear();
        }
        for (Integer version : supported) {
            if (!registryMap.containsKey(version)) {
                registryMap.put(version, new HashMap());
            }
            registryMap.get(version).put(output, protocol);
        }
        if (Via.getPlatform().isPluginEnabled()) {
            protocol.registerListeners();
            protocol.register(Via.getManager().getProviders());
            ProtocolRegistry.refreshVersions();
        } else {
            registerList.add(protocol);
        }
    }

    public static void registerBaseProtocol(Protocol baseProtocol, Range<Integer> supportedProtocols) {
        baseProtocols.add(new Pair<Range<Integer>, Protocol>(supportedProtocols, baseProtocol));
        if (Via.getPlatform().isPluginEnabled()) {
            baseProtocol.registerListeners();
            baseProtocol.register(Via.getManager().getProviders());
            ProtocolRegistry.refreshVersions();
        } else {
            registerList.add(baseProtocol);
        }
    }

    public static void refreshVersions() {
        supportedVersions.clear();
        supportedVersions.add(SERVER_PROTOCOL);
        for (ProtocolVersion versions : ProtocolVersion.getProtocols()) {
            List<Pair<Integer, Protocol>> paths = ProtocolRegistry.getProtocolPath(versions.getId(), SERVER_PROTOCOL);
            if (paths == null) continue;
            supportedVersions.add(versions.getId());
            for (Pair<Integer, Protocol> path : paths) {
                supportedVersions.add(path.getKey());
            }
        }
    }

    public static SortedSet<Integer> getSupportedVersions() {
        return Collections.unmodifiableSortedSet(new TreeSet<Integer>(supportedVersions));
    }

    public static boolean isWorkingPipe() {
        for (Map<Integer, Protocol> maps : registryMap.values()) {
            if (!maps.containsKey(SERVER_PROTOCOL)) continue;
            return true;
        }
        return false;
    }

    public static void onServerLoaded() {
        for (Protocol protocol : registerList) {
            protocol.registerListeners();
            protocol.register(Via.getManager().getProviders());
        }
        registerList.clear();
    }

    private static List<Pair<Integer, Protocol>> getProtocolPath(List<Pair<Integer, Protocol>> current, int clientVersion, int serverVersion) {
        if (clientVersion == serverVersion) {
            return null;
        }
        if (current.size() > 50) {
            return null;
        }
        Map<Integer, Protocol> inputMap = registryMap.get(clientVersion);
        if (inputMap == null) {
            return null;
        }
        Protocol protocol = inputMap.get(serverVersion);
        if (protocol != null) {
            current.add(new Pair<Integer, Protocol>(serverVersion, protocol));
            return current;
        }
        List<Pair<Integer, Protocol>> shortest = null;
        for (Map.Entry<Integer, Protocol> entry : inputMap.entrySet()) {
            Pair<Integer, Protocol> pair;
            if (entry.getKey().equals(serverVersion) || current.contains(pair = new Pair<Integer, Protocol>(entry.getKey(), entry.getValue()))) continue;
            List<Pair<Integer, Protocol>> newCurrent = new ArrayList<Pair<Integer, Protocol>>(current);
            newCurrent.add(pair);
            if ((newCurrent = ProtocolRegistry.getProtocolPath(newCurrent, entry.getKey(), serverVersion)) == null || shortest != null && shortest.size() <= newCurrent.size()) continue;
            shortest = newCurrent;
        }
        return shortest;
    }

    public static List<Pair<Integer, Protocol>> getProtocolPath(int clientVersion, int serverVersion) {
        Pair<Integer, Integer> protocolKey = new Pair<Integer, Integer>(clientVersion, serverVersion);
        List<Pair<Integer, Protocol>> protocolList = pathCache.get(protocolKey);
        if (protocolList != null) {
            return protocolList;
        }
        List<Pair<Integer, Protocol>> outputPath = ProtocolRegistry.getProtocolPath(new ArrayList<Pair<Integer, Protocol>>(), clientVersion, serverVersion);
        if (outputPath != null) {
            pathCache.put(protocolKey, outputPath);
        }
        return outputPath;
    }

    public static Protocol getBaseProtocol(int serverVersion) {
        for (Pair rangeProtocol : Lists.reverse(baseProtocols)) {
            if (!((Range)rangeProtocol.getKey()).contains((Comparable)Integer.valueOf(serverVersion))) continue;
            return (Protocol)rangeProtocol.getValue();
        }
        throw new IllegalStateException("No Base Protocol for " + serverVersion);
    }

    public static boolean isBaseProtocol(Protocol protocol) {
        for (Pair<Range<Integer>, Protocol> p : baseProtocols) {
            if (p.getValue() != protocol) continue;
            return true;
        }
        return false;
    }

    static {
        ProtocolRegistry.registerBaseProtocol(BASE_PROTOCOL, (Range<Integer>)Range.lessThan((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        ProtocolRegistry.registerBaseProtocol(new BaseProtocol1_7(), (Range<Integer>)Range.all());
        ProtocolRegistry.registerProtocol(new Protocol1_9To1_8(), Collections.singletonList(ProtocolVersion.v1_9.getId()), ProtocolVersion.v1_8.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_1To1_9(), Arrays.asList(ProtocolVersion.v1_9_1.getId(), ProtocolVersion.v1_9_2.getId()), ProtocolVersion.v1_9.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_3To1_9_1_2(), Collections.singletonList(ProtocolVersion.v1_9_3.getId()), ProtocolVersion.v1_9_2.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9To1_9_1(), Collections.singletonList(ProtocolVersion.v1_9.getId()), ProtocolVersion.v1_9_2.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_1_2To1_9_3_4(), Arrays.asList(ProtocolVersion.v1_9_1.getId(), ProtocolVersion.v1_9_2.getId()), ProtocolVersion.v1_9_3.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_10To1_9_3_4(), Collections.singletonList(ProtocolVersion.v1_10.getId()), ProtocolVersion.v1_9_3.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_11To1_10(), Collections.singletonList(ProtocolVersion.v1_11.getId()), ProtocolVersion.v1_10.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_11_1To1_11(), Collections.singletonList(ProtocolVersion.v1_11_1.getId()), ProtocolVersion.v1_11.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_12To1_11_1(), Collections.singletonList(ProtocolVersion.v1_12.getId()), ProtocolVersion.v1_11_1.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_12_1To1_12(), Collections.singletonList(ProtocolVersion.v1_12_1.getId()), ProtocolVersion.v1_12.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_12_2To1_12_1(), Collections.singletonList(ProtocolVersion.v1_12_2.getId()), ProtocolVersion.v1_12_1.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_13To1_12_2(), Collections.singletonList(ProtocolVersion.v1_13.getId()), ProtocolVersion.v1_12_2.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_13_1To1_13(), Arrays.asList(ProtocolVersion.v1_13_1.getId()), ProtocolVersion.v1_13.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_13_2To1_13_1(), Arrays.asList(ProtocolVersion.v1_13_2.getId()), ProtocolVersion.v1_13_1.getId());
    }
}

