/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.type.types;

import io.netty.buffer.ByteBuf;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.TypeConverter;

public class FloatType
extends Type<Float>
implements TypeConverter<Float> {
    public FloatType() {
        super(Float.class);
    }

    @Override
    public Float read(ByteBuf buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void write(ByteBuf buffer, Float object) {
        buffer.writeFloat(object.floatValue());
    }

    @Override
    public Float from(Object o) {
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof Boolean) {
            return Float.valueOf((Boolean)o != false ? 1.0f : 0.0f);
        }
        return (Float)o;
    }
}

