/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.type.types.minecraft;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.TagRegistry;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import us.myles.ViaVersion.api.type.Type;

public class NBTType
extends Type<CompoundTag> {
    public NBTType() {
        super(CompoundTag.class);
    }

    @Override
    public CompoundTag read(ByteBuf buffer) throws Exception {
        Preconditions.checkArgument((buffer.readableBytes() <= 0x200000 ? 1 : 0) != 0, (String)"Cannot read NBT (got %s bytes)", (Object[])new Object[]{buffer.readableBytes()});
        int readerIndex = buffer.readerIndex();
        byte b = buffer.readByte();
        if (b == 0) {
            return null;
        }
        buffer.readerIndex(readerIndex);
        ByteBufInputStream bytebufStream = new ByteBufInputStream(buffer);
        try (DataInputStream dataInputStream = new DataInputStream((InputStream)bytebufStream);){
            CompoundTag compoundTag = (CompoundTag)NBTIO.readTag((DataInput)dataInputStream);
            return compoundTag;
        }
    }

    @Override
    public void write(ByteBuf buffer, CompoundTag object) throws Exception {
        if (object == null) {
            buffer.writeByte(0);
        } else {
            ByteBufOutputStream bytebufStream = new ByteBufOutputStream(buffer);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)bytebufStream);
            NBTIO.writeTag((DataOutput)dataOutputStream, (Tag)object);
            dataOutputStream.close();
        }
    }

    static {
        TagRegistry.unregister((int)60);
        TagRegistry.unregister((int)61);
        TagRegistry.unregister((int)65);
    }
}

