/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.boss;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossFlag;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;

public abstract class CommonBoss<T>
extends BossBar<T> {
    private UUID uuid;
    private String title;
    private float health;
    private BossColor color;
    private BossStyle style;
    private Set<UUID> players;
    private boolean visible;
    private Set<BossFlag> flags;

    public CommonBoss(String title, float health, BossColor color, BossStyle style) {
        Preconditions.checkNotNull((Object)title, (Object)"Title cannot be null");
        Preconditions.checkArgument((health >= 0.0f && health <= 1.0f ? 1 : 0) != 0, (Object)"Health must be between 0 and 1");
        this.uuid = UUID.randomUUID();
        this.title = title;
        this.health = health;
        this.color = color == null ? BossColor.PURPLE : color;
        this.style = style == null ? BossStyle.SOLID : style;
        this.players = new HashSet<UUID>();
        this.flags = new HashSet<BossFlag>();
        this.visible = true;
    }

    @Override
    public BossBar setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked @NonNull but is null");
        }
        this.title = title;
        this.sendPacket(UpdateAction.UPDATE_TITLE);
        return this;
    }

    @Override
    public BossBar setHealth(float health) {
        Preconditions.checkArgument((health >= 0.0f && health <= 1.0f ? 1 : 0) != 0, (Object)"Health must be between 0 and 1");
        this.health = health;
        this.sendPacket(UpdateAction.UPDATE_HEALTH);
        return this;
    }

    @Override
    public BossColor getColor() {
        return this.color;
    }

    @Override
    public BossBar setColor(@NonNull BossColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked @NonNull but is null");
        }
        this.color = color;
        this.sendPacket(UpdateAction.UPDATE_STYLE);
        return this;
    }

    @Override
    public BossBar setStyle(@NonNull BossStyle style) {
        if (style == null) {
            throw new NullPointerException("style is marked @NonNull but is null");
        }
        this.style = style;
        this.sendPacket(UpdateAction.UPDATE_STYLE);
        return this;
    }

    @Override
    public BossBar addPlayer(UUID player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            if (this.visible) {
                UserConnection user = Via.getManager().getConnection(player);
                this.sendPacket(player, this.getPacket(UpdateAction.ADD, user));
            }
        }
        return this;
    }

    @Override
    public BossBar removePlayer(UUID uuid) {
        if (this.players.contains(uuid)) {
            this.players.remove(uuid);
            UserConnection user = Via.getManager().getConnection(uuid);
            this.sendPacket(uuid, this.getPacket(UpdateAction.REMOVE, user));
        }
        return this;
    }

    @Override
    public BossBar addFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked @NonNull but is null");
        }
        if (!this.hasFlag(flag)) {
            this.flags.add(flag);
        }
        this.sendPacket(UpdateAction.UPDATE_FLAGS);
        return this;
    }

    @Override
    public BossBar removeFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked @NonNull but is null");
        }
        if (this.hasFlag(flag)) {
            this.flags.remove((Object)flag);
        }
        this.sendPacket(UpdateAction.UPDATE_FLAGS);
        return this;
    }

    @Override
    public boolean hasFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked @NonNull but is null");
        }
        return this.flags.contains((Object)flag);
    }

    @Override
    public Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.players);
    }

    @Override
    public BossBar show() {
        this.setVisible(true);
        return this;
    }

    @Override
    public BossBar hide() {
        this.setVisible(false);
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    private void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.sendPacket(value ? UpdateAction.ADD : UpdateAction.REMOVE);
        }
    }

    private void sendPacket(UpdateAction action) {
        for (UUID uuid : new ArrayList<UUID>(this.players)) {
            UserConnection connection = Via.getManager().getConnection(uuid);
            PacketWrapper wrapper = this.getPacket(action, connection);
            this.sendPacket(uuid, wrapper);
        }
    }

    private void sendPacket(UUID uuid, PacketWrapper wrapper) {
        if (!Via.getAPI().isPorted(uuid) || Via.getAPI().getPlayerVersion(uuid) < ProtocolVersion.v1_9.getId()) {
            this.players.remove(uuid);
            return;
        }
        try {
            wrapper.send(Protocol1_9To1_8.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PacketWrapper getPacket(UpdateAction action, UserConnection connection) {
        try {
            PacketWrapper wrapper = new PacketWrapper(12, null, connection);
            wrapper.write(Type.UUID, this.uuid);
            wrapper.write(Type.VAR_INT, action.getId());
            switch (action) {
                case ADD: {
                    Protocol1_9To1_8.FIX_JSON.write(wrapper, this.title);
                    wrapper.write(Type.FLOAT, Float.valueOf(this.health));
                    wrapper.write(Type.VAR_INT, this.color.getId());
                    wrapper.write(Type.VAR_INT, this.style.getId());
                    wrapper.write(Type.BYTE, (byte)this.flagToBytes());
                    break;
                }
                case REMOVE: {
                    break;
                }
                case UPDATE_HEALTH: {
                    wrapper.write(Type.FLOAT, Float.valueOf(this.health));
                    break;
                }
                case UPDATE_TITLE: {
                    Protocol1_9To1_8.FIX_JSON.write(wrapper, this.title);
                    break;
                }
                case UPDATE_STYLE: {
                    wrapper.write(Type.VAR_INT, this.color.getId());
                    wrapper.write(Type.VAR_INT, this.style.getId());
                    break;
                }
                case UPDATE_FLAGS: {
                    wrapper.write(Type.BYTE, (byte)this.flagToBytes());
                }
            }
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int flagToBytes() {
        int bitmask = 0;
        for (BossFlag flag : this.flags) {
            bitmask |= flag.getId();
        }
        return bitmask;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public BossStyle getStyle() {
        return this.style;
    }

    public Set<BossFlag> getFlags() {
        return this.flags;
    }

    private static enum UpdateAction {
        ADD(0),
        REMOVE(1),
        UPDATE_HEALTH(2),
        UPDATE_TITLE(3),
        UPDATE_STYLE(4),
        UPDATE_FLAGS(5);

        private final int id;

        private UpdateAction(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

