/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.base;

import com.google.common.base.Joiner;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.base.BaseProtocol;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.base.VersionProvider;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;
import us.myles.ViaVersion.util.GsonUtil;

public class BaseProtocol1_7
extends Protocol {
    @Override
    protected void registerPackets() {
        this.registerOutgoing(State.STATUS, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ProtocolInfo info = wrapper.user().get(ProtocolInfo.class);
                        String originalStatus = wrapper.get(Type.STRING, 0);
                        try {
                            JsonObject version;
                            JsonElement json = (JsonElement)GsonUtil.getGson().fromJson(originalStatus, JsonElement.class);
                            int protocolVersion = 0;
                            if (json.isJsonObject()) {
                                if (json.getAsJsonObject().has("version")) {
                                    version = json.getAsJsonObject().get("version").getAsJsonObject();
                                    if (version.has("protocol")) {
                                        protocolVersion = Long.valueOf(version.get("protocol").getAsLong()).intValue();
                                    }
                                } else {
                                    version = new JsonObject();
                                    json.getAsJsonObject().add("version", (JsonElement)version);
                                }
                            } else {
                                json = new JsonObject();
                                version = new JsonObject();
                                json.getAsJsonObject().add("version", (JsonElement)version);
                            }
                            if (Via.getConfig().isSendSupportedVersions()) {
                                version.add("supportedVersions", GsonUtil.getGson().toJsonTree(Via.getAPI().getSupportedVersions()));
                            }
                            if (ProtocolRegistry.SERVER_PROTOCOL == -1) {
                                ProtocolRegistry.SERVER_PROTOCOL = protocolVersion;
                            }
                            if (Via.getManager().getProviders().get(VersionProvider.class) == null) {
                                wrapper.user().setActive(false);
                                return;
                            }
                            int protocol = Via.getManager().getProviders().get(VersionProvider.class).getServerProtocol(wrapper.user());
                            List<Pair<Integer, Protocol>> protocols = null;
                            if (info.getProtocolVersion() >= protocol || Via.getPlatform().isOldClientsAllowed()) {
                                protocols = ProtocolRegistry.getProtocolPath(info.getProtocolVersion(), protocol);
                            }
                            if (protocols != null) {
                                if (protocolVersion != 9999) {
                                    version.addProperty("protocol", (Number)info.getProtocolVersion());
                                }
                            } else {
                                wrapper.user().setActive(false);
                            }
                            if (Via.getConfig().getBlockedProtocols().contains(info.getProtocolVersion())) {
                                version.addProperty("protocol", (Number)-1);
                            }
                            wrapper.set(Type.STRING, 0, GsonUtil.getGson().toJson(json));
                        }
                        catch (JsonParseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.STATUS, 1, 1);
        this.registerOutgoing(State.LOGIN, 0, 0);
        this.registerOutgoing(State.LOGIN, 1, 1);
        this.registerOutgoing(State.LOGIN, 2, 2, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ProtocolInfo info = wrapper.user().get(ProtocolInfo.class);
                        info.setState(State.PLAY);
                        String stringUUID = wrapper.get(Type.STRING, 0);
                        if (stringUUID.length() == 32) {
                            stringUUID = BaseProtocol1_7.addDashes(stringUUID);
                        }
                        UUID uuid = UUID.fromString(stringUUID);
                        info.setUuid(uuid);
                        info.setUsername(wrapper.get(Type.STRING, 1));
                        Via.getManager().addPortedClient(wrapper.user());
                        if (info.getPipeline().pipes().size() == 2 && info.getPipeline().pipes().get(1).getClass() == BaseProtocol1_7.class && info.getPipeline().pipes().get(0).getClass() == BaseProtocol.class) {
                            wrapper.user().setActive(false);
                        }
                        if (Via.getManager().isDebug()) {
                            Via.getPlatform().getLogger().log(Level.INFO, "{0} logged in with protocol {1}, Route: {2}", new Object[]{wrapper.get(Type.STRING, 1), info.getProtocolVersion(), Joiner.on((String)", ").join(info.getPipeline().pipes(), (Object)", ", new Object[0])});
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.LOGIN, 3, 3);
        this.registerIncoming(State.LOGIN, 4, 4);
        this.registerIncoming(State.STATUS, 0, 0);
        this.registerIncoming(State.STATUS, 1, 1);
        this.registerIncoming(State.LOGIN, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(final PacketWrapper wrapper) throws Exception {
                        int protocol = wrapper.user().get(ProtocolInfo.class).getProtocolVersion();
                        if (Via.getConfig().getBlockedProtocols().contains(protocol)) {
                            if (!wrapper.user().getChannel().isOpen()) {
                                return;
                            }
                            PacketWrapper disconnectPacket = new PacketWrapper(0, null, wrapper.user());
                            Protocol1_9To1_8.FIX_JSON.write(disconnectPacket, ChatColor.translateAlternateColorCodes((char)'&', (String)Via.getConfig().getBlockedDisconnectMsg()));
                            wrapper.cancel();
                            ChannelFuture future = disconnectPacket.sendFuture(BaseProtocol.class);
                            future.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                                public void operationComplete(Future<? super Void> future) throws Exception {
                                    wrapper.user().getChannel().close();
                                }
                            });
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.LOGIN, 1, 1);
        this.registerIncoming(State.LOGIN, 2, 2);
    }

    @Override
    public void init(UserConnection userConnection) {
    }

    public static String addDashes(String trimmedUUID) {
        StringBuilder idBuff = new StringBuilder(trimmedUUID);
        idBuff.insert(20, '-');
        idBuff.insert(16, '-');
        idBuff.insert(12, '-');
        idBuff.insert(8, '-');
        return idBuff.toString();
    }
}

