/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_11to1_10.storage;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.entities.Entity1_11Types;

public class EntityTracker
extends StoredObject {
    private final Map<Integer, Entity1_11Types.EntityType> clientEntityTypes = new ConcurrentHashMap<Integer, Entity1_11Types.EntityType>();
    private final Set<Integer> holograms = Sets.newConcurrentHashSet();

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public void removeEntity(int entityId) {
        this.clientEntityTypes.remove(entityId);
        if (this.isHologram(entityId)) {
            this.removeHologram(entityId);
        }
    }

    public void addEntity(int entityId, Entity1_11Types.EntityType type) {
        this.clientEntityTypes.put(entityId, type);
    }

    public boolean has(int entityId) {
        return this.clientEntityTypes.containsKey(entityId);
    }

    public Optional<Entity1_11Types.EntityType> get(int id) {
        return Optional.fromNullable((Object)((Object)this.clientEntityTypes.get(id)));
    }

    public void addHologram(int entId) {
        this.holograms.add(entId);
    }

    public boolean isHologram(int entId) {
        return this.holograms.contains(entId);
    }

    public void removeHologram(int entId) {
        this.holograms.remove(entId);
    }
}

