/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_12to1_11_1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import us.myles.ViaVersion.api.data.UserConnection;

public class ChatItemRewriter {
    private static Pattern indexRemoval = Pattern.compile("\\d+:(?=([^\"\\\\]*(\\\\.|\"([^\"\\\\]*\\\\.)*[^\"\\\\]*\"))*[^\"]*$)");

    public static void toClient(JsonElement element, UserConnection user) {
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (obj.has("hoverEvent")) {
                String type;
                JsonObject hoverEvent;
                if (obj.get("hoverEvent") instanceof JsonObject && (hoverEvent = (JsonObject)obj.get("hoverEvent")).has("action") && hoverEvent.has("value") && ((type = hoverEvent.get("action").getAsString()).equals("show_item") || type.equals("show_entity")) && hoverEvent.get("value").isJsonPrimitive() && hoverEvent.get("value").getAsJsonPrimitive().isString()) {
                    String value = hoverEvent.get("value").getAsString();
                    value = indexRemoval.matcher(value).replaceAll("");
                    hoverEvent.addProperty("value", value);
                }
            } else if (obj.has("extra")) {
                ChatItemRewriter.toClient(obj.get("extra"), user);
            }
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            for (JsonElement value : array) {
                ChatItemRewriter.toClient(value, user);
            }
        }
    }
}

