/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_12to1_11_1;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.base.Optional;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.entities.Entity1_12Types;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;
import us.myles.ViaVersion.api.platform.providers.ViaProviders;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.version.Types1_12;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.ChatItemRewriter;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.MetadataRewriter;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.TranslateRewriter;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.packets.InventoryPackets;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.providers.InventoryQuickMoveProvider;
import us.myles.ViaVersion.protocols.protocol1_12to1_11_1.storage.EntityTracker;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.types.Chunk1_9_3_4Type;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;

public class Protocol1_12To1_11_1
extends Protocol {
    @Override
    protected void registerPackets() {
        InventoryPackets.register(this);
        this.registerOutgoing(State.PLAY, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.UUID);
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int entityId = wrapper.get(Type.VAR_INT, 0);
                        byte type = wrapper.get(Type.BYTE, 0);
                        Entity1_12Types.EntityType entType = Entity1_12Types.getTypeFromId(type, true);
                        wrapper.user().get(EntityTracker.class).addEntity(entityId, entType);
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 3, 3, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.UUID);
                this.map(Type.VAR_INT);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_12.METADATA_LIST);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int entityId = wrapper.get(Type.VAR_INT, 0);
                        int type = wrapper.get(Type.VAR_INT, 1);
                        Entity1_12Types.EntityType entType = Entity1_12Types.getTypeFromId(type, false);
                        wrapper.user().get(EntityTracker.class).addEntity(entityId, entType);
                        MetadataRewriter.handleMetadata(entityId, entType, wrapper.get(Types1_12.METADATA_LIST, 0), wrapper.user());
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 15, 15, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING, Protocol1_9To1_8.FIX_JSON);
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (!Via.getConfig().is1_12NBTArrayFix()) {
                            return;
                        }
                        try {
                            JsonElement obj = new JsonParser().parse(wrapper.get(Type.STRING, 0));
                            if (!TranslateRewriter.toClient(obj, wrapper.user())) {
                                wrapper.cancel();
                                return;
                            }
                            ChatItemRewriter.toClient(obj, wrapper.user());
                            wrapper.set(Type.STRING, 0, obj.toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 32, 32, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                        Chunk1_9_3_4Type type = new Chunk1_9_3_4Type(clientWorld);
                        Chunk chunk = wrapper.passthrough(type);
                        for (int i = 0; i < chunk.getSections().length; ++i) {
                            ChunkSection section = chunk.getSections()[i];
                            if (section == null) continue;
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    for (int x = 0; x < 16; ++x) {
                                        int block = section.getBlockId(x, y, z);
                                        if (block != 26) continue;
                                        CompoundTag tag = new CompoundTag("");
                                        tag.put((Tag)new IntTag("color", 14));
                                        tag.put((Tag)new IntTag("x", x + (chunk.getX() << 4)));
                                        tag.put((Tag)new IntTag("y", y + (i << 4)));
                                        tag.put((Tag)new IntTag("z", z + (chunk.getZ() << 4)));
                                        tag.put((Tag)new StringTag("id", "minecraft:bed"));
                                        chunk.getBlockEntities().add(tag);
                                    }
                                }
                            }
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 35, 35, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientWorld clientChunks = wrapper.user().get(ClientWorld.class);
                        int dimensionId = wrapper.get(Type.INT, 1);
                        clientChunks.setEnvironment(dimensionId);
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 40, 37);
        this.registerOutgoing(State.PLAY, 37, 38);
        this.registerOutgoing(State.PLAY, 38, 39);
        this.registerOutgoing(State.PLAY, 39, 40);
        this.registerOutgoing(State.PLAY, 48, 49, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT_ARRAY);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Integer[] integerArray = wrapper.get(Type.VAR_INT_ARRAY, 0);
                        int n = integerArray.length;
                        for (int i = 0; i < n; ++i) {
                            int entity = integerArray[i];
                            wrapper.user().get(EntityTracker.class).removeEntity(entity);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 49, 50);
        this.registerOutgoing(State.PLAY, 50, 51);
        this.registerOutgoing(State.PLAY, 51, 52, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                        int dimensionId = wrapper.get(Type.INT, 0);
                        clientWorld.setEnvironment(dimensionId);
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 52, 53);
        this.registerOutgoing(State.PLAY, 53, 55);
        this.registerOutgoing(State.PLAY, 54, 56);
        this.registerOutgoing(State.PLAY, 55, 57);
        this.registerOutgoing(State.PLAY, 56, 58);
        this.registerOutgoing(State.PLAY, 57, 59, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Types1_12.METADATA_LIST);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int entityId = wrapper.get(Type.VAR_INT, 0);
                        Optional<Entity1_12Types.EntityType> type = wrapper.user().get(EntityTracker.class).get(entityId);
                        if (!type.isPresent()) {
                            return;
                        }
                        MetadataRewriter.handleMetadata(entityId, (Entity1_12Types.EntityType)((Object)type.get()), wrapper.get(Types1_12.METADATA_LIST, 0), wrapper.user());
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 58, 60);
        this.registerOutgoing(State.PLAY, 59, 61);
        this.registerOutgoing(State.PLAY, 61, 63);
        this.registerOutgoing(State.PLAY, 62, 64);
        this.registerOutgoing(State.PLAY, 63, 65);
        this.registerOutgoing(State.PLAY, 64, 66);
        this.registerOutgoing(State.PLAY, 65, 67);
        this.registerOutgoing(State.PLAY, 66, 68);
        this.registerOutgoing(State.PLAY, 67, 69);
        this.registerOutgoing(State.PLAY, 68, 70);
        this.registerOutgoing(State.PLAY, 69, 71);
        this.registerOutgoing(State.PLAY, 70, 72, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int id = wrapper.get(Type.VAR_INT, 0);
                        if ((id = Protocol1_12To1_11_1.this.getNewSoundId(id)) == -1) {
                            wrapper.cancel();
                        }
                        wrapper.set(Type.VAR_INT, 0, id);
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 71, 73);
        this.registerOutgoing(State.PLAY, 72, 74);
        this.registerOutgoing(State.PLAY, 73, 75);
        this.registerOutgoing(State.PLAY, 74, 77);
        this.registerOutgoing(State.PLAY, 75, 78);
        this.registerIncoming(State.PLAY, 1, 1, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 1, 2);
        this.registerIncoming(State.PLAY, 2, 3);
        this.registerIncoming(State.PLAY, 3, 4);
        this.registerIncoming(State.PLAY, 4, 5, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.BYTE);
                this.map(Type.VAR_INT);
                this.map(Type.BOOLEAN);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String locale = wrapper.get(Type.STRING, 0);
                        if (locale.length() > 7) {
                            wrapper.set(Type.STRING, 0, locale.substring(0, 7));
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 5, 6);
        this.registerIncoming(State.PLAY, 6, 7);
        this.registerIncoming(State.PLAY, 8, 9);
        this.registerIncoming(State.PLAY, 9, 10);
        this.registerIncoming(State.PLAY, 10, 11);
        this.registerIncoming(State.PLAY, 11, 12);
        this.registerIncoming(State.PLAY, 15, 13);
        this.registerIncoming(State.PLAY, 12, 14);
        this.registerIncoming(State.PLAY, 13, 15);
        this.registerIncoming(State.PLAY, 14, 16);
        this.registerIncoming(State.PLAY, 16, 17);
        this.registerIncoming(State.PLAY, 17, 18);
        this.registerIncoming(State.PLAY, 18, 19);
        this.registerIncoming(State.PLAY, 19, 20);
        this.registerIncoming(State.PLAY, 20, 21);
        this.registerIncoming(State.PLAY, 21, 22);
        this.registerIncoming(State.PLAY, 23, 23, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 22, 24);
        this.registerIncoming(State.PLAY, 25, 25, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 23, 26);
        this.registerIncoming(State.PLAY, 25, 28);
        this.registerIncoming(State.PLAY, 26, 29);
        this.registerIncoming(State.PLAY, 27, 30);
        this.registerIncoming(State.PLAY, 28, 31);
        this.registerIncoming(State.PLAY, 29, 32);
    }

    private int getNewSoundId(int id) {
        int newId = id;
        if (id >= 26) {
            newId += 2;
        }
        if (id >= 70) {
            newId += 4;
        }
        if (id >= 74) {
            ++newId;
        }
        if (id >= 143) {
            newId += 3;
        }
        if (id >= 185) {
            ++newId;
        }
        if (id >= 263) {
            newId += 7;
        }
        if (id >= 301) {
            newId += 33;
        }
        if (id >= 317) {
            newId += 2;
        }
        if (id >= 491) {
            newId += 3;
        }
        return newId;
    }

    @Override
    protected void register(ViaProviders providers) {
        providers.register(InventoryQuickMoveProvider.class, new InventoryQuickMoveProvider());
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new EntityTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
    }
}

