/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13_1to1_13.packets;

import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;

public class InventoryPackets {
    public static void register(Protocol protocol) {
        protocol.registerOutgoing(State.PLAY, 23, 23, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.FLAT_ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item stack = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toClient(stack);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 21, 21, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.FLAT_ITEM_ARRAY, Type.FLAT_ITEM_ARRAY);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item[] stacks;
                        for (Item stack : stacks = wrapper.get(Type.FLAT_ITEM_ARRAY, 0)) {
                            InventoryPackets.toClient(stack);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 25, 25, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String channel = wrapper.get(Type.STRING, 0);
                        if (channel.equals("minecraft:trader_list") || channel.equals("trader_list")) {
                            wrapper.passthrough(Type.INT);
                            int size = wrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
                            for (int i = 0; i < size; ++i) {
                                InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                                InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                                boolean secondItem = wrapper.passthrough(Type.BOOLEAN);
                                if (secondItem) {
                                    InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                                }
                                wrapper.passthrough(Type.BOOLEAN);
                                wrapper.passthrough(Type.INT);
                                wrapper.passthrough(Type.INT);
                            }
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 66, 66, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.map(Type.FLAT_ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item stack = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toClient(stack);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 84, 84, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int recipesNo = wrapper.passthrough(Type.VAR_INT);
                        for (int i = 0; i < recipesNo; ++i) {
                            int i2;
                            Item[] items;
                            int i1;
                            wrapper.passthrough(Type.STRING);
                            String type = wrapper.passthrough(Type.STRING);
                            if (type.equals("crafting_shapeless")) {
                                wrapper.passthrough(Type.STRING);
                                int ingredientsNo = wrapper.passthrough(Type.VAR_INT);
                                for (i1 = 0; i1 < ingredientsNo; ++i1) {
                                    items = wrapper.passthrough(Type.FLAT_ITEM_ARRAY_VAR_INT);
                                    for (i2 = 0; i2 < items.length; ++i2) {
                                        InventoryPackets.toClient(items[i2]);
                                    }
                                }
                                InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                                continue;
                            }
                            if (type.equals("crafting_shaped")) {
                                int ingredientsNo = wrapper.passthrough(Type.VAR_INT) * wrapper.passthrough(Type.VAR_INT);
                                wrapper.passthrough(Type.STRING);
                                for (i1 = 0; i1 < ingredientsNo; ++i1) {
                                    items = wrapper.passthrough(Type.FLAT_ITEM_ARRAY_VAR_INT);
                                    for (i2 = 0; i2 < items.length; ++i2) {
                                        InventoryPackets.toClient(items[i2]);
                                    }
                                }
                                InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                                continue;
                            }
                            if (!type.equals("smelting")) continue;
                            wrapper.passthrough(Type.STRING);
                            Item[] items2 = wrapper.passthrough(Type.FLAT_ITEM_ARRAY_VAR_INT);
                            for (int i22 = 0; i22 < items2.length; ++i22) {
                                InventoryPackets.toClient(items2[i22]);
                            }
                            InventoryPackets.toClient(wrapper.passthrough(Type.FLAT_ITEM));
                            wrapper.passthrough(Type.FLOAT);
                            wrapper.passthrough(Type.VAR_INT);
                        }
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 8, 8, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.VAR_INT);
                this.map(Type.FLAT_ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item item = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toServer(item);
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 36, 36, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.SHORT);
                this.map(Type.FLAT_ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item item = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toServer(item);
                    }
                });
            }
        });
    }

    public static void toClient(Item item) {
        if (item == null) {
            return;
        }
        item.setId((short)InventoryPackets.getNewItemId(item.getId()));
    }

    public static int getNewItemId(int itemId) {
        if (itemId >= 443) {
            return itemId + 5;
        }
        return itemId;
    }

    public static void toServer(Item item) {
        if (item == null) {
            return;
        }
        item.setId((short)InventoryPackets.getOldItemId(item.getId()));
    }

    public static int getOldItemId(int newId) {
        if (newId >= 448) {
            return newId - 5;
        }
        return newId;
    }
}

