/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.EnumMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.entities.Entity1_13Types;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.platform.providers.ViaProviders;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.remapper.ValueCreator;
import us.myles.ViaVersion.api.remapper.ValueTransformer;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.ChatRewriter;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.TabCompleteThread;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.providers.BlockConnectionProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.providers.PacketBlockConnectionProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.BlockIdData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.RecipeData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.EntityPackets;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.InventoryPackets;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.WorldPackets;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.BlockEntityProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.PaintingProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.BlockConnectionStorage;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.BlockStorage;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.EntityTracker;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.TabCompleteTracker;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.types.Particle1_13Type;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import us.myles.ViaVersion.util.GsonUtil;

public class Protocol1_13To1_12_2
extends Protocol {
    public static final Particle1_13Type PARTICLE_TYPE = new Particle1_13Type();
    public static final PacketHandler POS_TO_3_INT = new PacketHandler(){

        @Override
        public void handle(PacketWrapper wrapper) throws Exception {
            Position position = wrapper.read(Type.POSITION);
            wrapper.write(Type.INT, position.getX().intValue());
            wrapper.write(Type.INT, position.getY().intValue());
            wrapper.write(Type.INT, position.getZ().intValue());
        }
    };
    public static final PacketHandler SEND_DECLARE_COMMANDS_AND_TAGS = new PacketHandler(){

        @Override
        public void handle(PacketWrapper w) throws Exception {
            w.create(17, new ValueCreator(){

                @Override
                public void write(PacketWrapper wrapper) {
                    wrapper.write(Type.VAR_INT, 2);
                    wrapper.write(Type.VAR_INT, 0);
                    wrapper.write(Type.VAR_INT, 1);
                    wrapper.write(Type.VAR_INT, 1);
                    wrapper.write(Type.VAR_INT, 22);
                    wrapper.write(Type.VAR_INT, 0);
                    wrapper.write(Type.STRING, "args");
                    wrapper.write(Type.STRING, "brigadier:string");
                    wrapper.write(Type.VAR_INT, 2);
                    wrapper.write(Type.STRING, "minecraft:ask_server");
                    wrapper.write(Type.VAR_INT, 0);
                }
            }).send(Protocol1_13To1_12_2.class);
            w.create(85, new ValueCreator(){

                @Override
                public void write(PacketWrapper wrapper) throws Exception {
                    wrapper.write(Type.VAR_INT, MappingData.blockTags.size());
                    for (Map.Entry<String, Integer[]> tag : MappingData.blockTags.entrySet()) {
                        wrapper.write(Type.STRING, tag.getKey());
                        wrapper.write(Type.VAR_INT_ARRAY, tag.getValue().clone());
                    }
                    wrapper.write(Type.VAR_INT, MappingData.itemTags.size());
                    for (Map.Entry<String, Integer[]> tag : MappingData.itemTags.entrySet()) {
                        wrapper.write(Type.STRING, tag.getKey());
                        wrapper.write(Type.VAR_INT_ARRAY, tag.getValue().clone());
                    }
                    wrapper.write(Type.VAR_INT, MappingData.fluidTags.size());
                    for (Map.Entry<String, Integer[]> tag : MappingData.fluidTags.entrySet()) {
                        wrapper.write(Type.STRING, tag.getKey());
                        wrapper.write(Type.VAR_INT_ARRAY, tag.getValue().clone());
                    }
                }
            }).send(Protocol1_13To1_12_2.class);
        }
    };
    protected static EnumMap<ChatColor, Character> SCOREBOARD_TEAM_NAME_REWRITE = new EnumMap(ChatColor.class);

    @Override
    protected void registerPackets() {
        EntityPackets.register(this);
        WorldPackets.register(this);
        InventoryPackets.register(this);
        this.registerOutgoing(State.LOGIN, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.set(Type.STRING, 0, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 0)));
                    }
                });
            }
        });
        this.registerOutgoing(State.STATUS, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String response = wrapper.get(Type.STRING, 0);
                        try {
                            JsonObject json = (JsonObject)GsonUtil.getGson().fromJson(response, JsonObject.class);
                            if (json.has("favicon")) {
                                json.addProperty("favicon", json.get("favicon").getAsString().replace("\n", ""));
                            }
                            wrapper.set(Type.STRING, 0, GsonUtil.getGson().toJson((JsonElement)json));
                        }
                        catch (JsonParseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 7, 7, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 12, 12, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UUID);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int action = wrapper.get(Type.VAR_INT, 0);
                        if (action == 0 || action == 3) {
                            wrapper.write(Type.STRING, ChatRewriter.processTranslate(wrapper.read(Type.STRING)));
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 15, 14, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.set(Type.STRING, 0, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 0)));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 14, 16, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        int length;
                        int index;
                        wrapper.write(Type.VAR_INT, wrapper.user().get(TabCompleteTracker.class).getTransactionId());
                        String input = wrapper.user().get(TabCompleteTracker.class).getInput();
                        if (input.endsWith(" ") || input.length() == 0) {
                            index = input.length();
                            length = 0;
                        } else {
                            int lastSpace;
                            index = lastSpace = input.lastIndexOf(" ") + 1;
                            length = input.length() - lastSpace;
                        }
                        wrapper.write(Type.VAR_INT, index);
                        wrapper.write(Type.VAR_INT, length);
                        int count = wrapper.passthrough(Type.VAR_INT);
                        for (int i = 0; i < count; ++i) {
                            String suggestion = wrapper.read(Type.STRING);
                            if (suggestion.startsWith("/") && index == 0) {
                                suggestion = suggestion.substring(1);
                            }
                            wrapper.write(Type.STRING, suggestion);
                            wrapper.write(Type.BOOLEAN, false);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 17, 18);
        this.registerOutgoing(State.PLAY, 18, 19);
        this.registerOutgoing(State.PLAY, 19, 20, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.set(Type.STRING, 1, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 1)));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 23, 24, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int item = wrapper.read(Type.VAR_INT);
                        int ticks = wrapper.read(Type.VAR_INT);
                        wrapper.cancel();
                        if (item == 383) {
                            Integer newItem;
                            for (int i = 0; i < 44 && (newItem = (Integer)MappingData.oldToNewItems.get((Object)(item << 16 | i))) != null; ++i) {
                                PacketWrapper packet = wrapper.create(24);
                                packet.write(Type.VAR_INT, newItem);
                                packet.write(Type.VAR_INT, ticks);
                                packet.send(Protocol1_13To1_12_2.class);
                            }
                        } else {
                            Integer newItem;
                            for (int i = 0; i < 16 && (newItem = (Integer)MappingData.oldToNewItems.get((Object)(item << 4 | i))) != null; ++i) {
                                PacketWrapper packet = wrapper.create(24);
                                packet.write(Type.VAR_INT, newItem);
                                packet.write(Type.VAR_INT, ticks);
                                packet.send(Protocol1_13To1_12_2.class);
                            }
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 26, 27, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.set(Type.STRING, 0, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 0)));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 27, 28);
        this.registerOutgoing(State.PLAY, 28, 30);
        this.registerOutgoing(State.PLAY, 30, 32);
        this.registerOutgoing(State.PLAY, 31, 33);
        this.registerOutgoing(State.PLAY, 33, 35, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.POSITION);
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int id = wrapper.get(Type.INT, 0);
                        int data = wrapper.get(Type.INT, 1);
                        if (id == 1010) {
                            data = (Integer)MappingData.oldToNewItems.get((Object)(data << 4));
                            wrapper.set(Type.INT, 1, data);
                        } else if (id == 2001) {
                            int blockId = data & 0xFFF;
                            int blockData = data >> 12;
                            data = WorldPackets.toNewId(blockId << 4 | blockData);
                            wrapper.set(Type.INT, 1, data);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 35, 37, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int entityId = wrapper.get(Type.INT, 0);
                        wrapper.user().get(EntityTracker.class).addEntity(entityId, Entity1_13Types.EntityType.PLAYER);
                        ClientWorld clientChunks = wrapper.user().get(ClientWorld.class);
                        int dimensionId = wrapper.get(Type.INT, 1);
                        clientChunks.setEnvironment(dimensionId);
                    }
                });
                this.handler(SEND_DECLARE_COMMANDS_AND_TAGS);
            }
        });
        this.registerOutgoing(State.PLAY, 36, 38, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BOOLEAN);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int iconCount = wrapper.passthrough(Type.VAR_INT);
                        for (int i = 0; i < iconCount; ++i) {
                            byte directionAndType = wrapper.read(Type.BYTE);
                            int type = (directionAndType & 0xF0) >> 4;
                            wrapper.write(Type.VAR_INT, type);
                            wrapper.passthrough(Type.BYTE);
                            wrapper.passthrough(Type.BYTE);
                            byte direction = (byte)(directionAndType & 0xF);
                            wrapper.write(Type.BYTE, direction);
                            wrapper.write(Type.OPTIONAL_CHAT, null);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 37, 39);
        this.registerOutgoing(State.PLAY, 38, 40);
        this.registerOutgoing(State.PLAY, 39, 41);
        this.registerOutgoing(State.PLAY, 40, 42);
        this.registerOutgoing(State.PLAY, 41, 43);
        this.registerOutgoing(State.PLAY, 42, 44);
        this.registerOutgoing(State.PLAY, 43, 45, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "viaversion:legacy/" + wrapper.read(Type.VAR_INT));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 44, 46);
        this.registerOutgoing(State.PLAY, 45, 47, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (wrapper.get(Type.VAR_INT, 0) == 2) {
                            wrapper.passthrough(Type.VAR_INT);
                            wrapper.passthrough(Type.INT);
                            wrapper.write(Type.STRING, ChatRewriter.processTranslate(wrapper.read(Type.STRING)));
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 46, 48);
        this.registerOutgoing(State.PLAY, 47, 50);
        this.registerOutgoing(State.PLAY, 48, 51);
        this.registerOutgoing(State.PLAY, 49, 52, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.BOOLEAN);
                this.map(Type.BOOLEAN);
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.BOOLEAN, false);
                        wrapper.write(Type.BOOLEAN, false);
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int action = wrapper.get(Type.VAR_INT, 0);
                        for (int i = 0; i < (action == 0 ? 2 : 1); ++i) {
                            Integer[] ids = wrapper.read(Type.VAR_INT_ARRAY);
                            String[] stringIds = new String[ids.length];
                            for (int j = 0; j < ids.length; ++j) {
                                stringIds[j] = "viaversion:legacy/" + ids[j];
                            }
                            wrapper.write(Type.STRING_ARRAY, stringIds);
                        }
                        if (action == 0) {
                            wrapper.create(84, new ValueCreator(){

                                @Override
                                public void write(PacketWrapper wrapper) throws Exception {
                                    wrapper.write(Type.VAR_INT, RecipeData.recipes.size());
                                    for (Map.Entry<String, RecipeData.Recipe> entry : RecipeData.recipes.entrySet()) {
                                        wrapper.write(Type.STRING, entry.getKey());
                                        wrapper.write(Type.STRING, entry.getValue().getType());
                                        switch (entry.getValue().getType()) {
                                            case "crafting_shapeless": {
                                                int i;
                                                Item[] clone;
                                                wrapper.write(Type.STRING, entry.getValue().getGroup());
                                                wrapper.write(Type.VAR_INT, entry.getValue().getIngredients().length);
                                                for (Item[] ingredient : entry.getValue().getIngredients()) {
                                                    clone = (Item[])ingredient.clone();
                                                    for (i = 0; i < clone.length; ++i) {
                                                        if (clone[i] == null) continue;
                                                        clone[i] = new Item(clone[i].getId(), clone[i].getAmount(), 0, null);
                                                    }
                                                    wrapper.write(Type.FLAT_ITEM_ARRAY_VAR_INT, clone);
                                                }
                                                wrapper.write(Type.FLAT_ITEM, new Item(entry.getValue().getResult().getId(), entry.getValue().getResult().getAmount(), 0, null));
                                                break;
                                            }
                                            case "crafting_shaped": {
                                                int i;
                                                Item[] clone;
                                                wrapper.write(Type.VAR_INT, entry.getValue().getWidth());
                                                wrapper.write(Type.VAR_INT, entry.getValue().getHeight());
                                                wrapper.write(Type.STRING, entry.getValue().getGroup());
                                                for (Item[] ingredient : entry.getValue().getIngredients()) {
                                                    clone = (Item[])ingredient.clone();
                                                    for (i = 0; i < clone.length; ++i) {
                                                        if (clone[i] == null) continue;
                                                        clone[i] = new Item(clone[i].getId(), clone[i].getAmount(), 0, null);
                                                    }
                                                    wrapper.write(Type.FLAT_ITEM_ARRAY_VAR_INT, clone);
                                                }
                                                wrapper.write(Type.FLAT_ITEM, new Item(entry.getValue().getResult().getId(), entry.getValue().getResult().getAmount(), 0, null));
                                                break;
                                            }
                                            case "smelting": {
                                                wrapper.write(Type.STRING, entry.getValue().getGroup());
                                                Item[] clone = (Item[])entry.getValue().getIngredient().clone();
                                                for (int i = 0; i < clone.length; ++i) {
                                                    if (clone[i] == null) continue;
                                                    clone[i] = new Item(clone[i].getId(), clone[i].getAmount(), 0, null);
                                                }
                                                wrapper.write(Type.FLAT_ITEM_ARRAY_VAR_INT, clone);
                                                wrapper.write(Type.FLAT_ITEM, new Item(entry.getValue().getResult().getId(), entry.getValue().getResult().getAmount(), 0, null));
                                                wrapper.write(Type.FLOAT, Float.valueOf(entry.getValue().getExperience()));
                                                wrapper.write(Type.VAR_INT, entry.getValue().getCookingTime());
                                                break;
                                            }
                                        }
                                    }
                                }
                            }).send(Protocol1_13To1_12_2.class, true, true);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 51, 54);
        this.registerOutgoing(State.PLAY, 52, 55);
        this.registerOutgoing(State.PLAY, 53, 56, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                        int dimensionId = wrapper.get(Type.INT, 0);
                        clientWorld.setEnvironment(dimensionId);
                        if (Via.getConfig().isServersideBlockConnections()) {
                            ConnectionData.clearBlockStorage(wrapper.user());
                        }
                    }
                });
                this.handler(SEND_DECLARE_COMMANDS_AND_TAGS);
            }
        });
        this.registerOutgoing(State.PLAY, 54, 57);
        this.registerOutgoing(State.PLAY, 55, 58);
        this.registerOutgoing(State.PLAY, 56, 59);
        this.registerOutgoing(State.PLAY, 57, 60);
        this.registerOutgoing(State.PLAY, 58, 61);
        this.registerOutgoing(State.PLAY, 59, 62);
        this.registerOutgoing(State.PLAY, 61, 64);
        this.registerOutgoing(State.PLAY, 62, 65);
        this.registerOutgoing(State.PLAY, 64, 67);
        this.registerOutgoing(State.PLAY, 65, 68);
        this.registerOutgoing(State.PLAY, 66, 69, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        byte mode = wrapper.get(Type.BYTE, 0);
                        if (mode == 0 || mode == 2) {
                            String value = wrapper.read(Type.STRING);
                            value = ChatRewriter.legacyTextToJson(value);
                            wrapper.write(Type.STRING, value);
                            String type = wrapper.read(Type.STRING);
                            wrapper.write(Type.VAR_INT, type.equals("integer") ? 0 : 1);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 67, 70);
        this.registerOutgoing(State.PLAY, 68, 71, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        byte action = wrapper.get(Type.BYTE, 0);
                        if (action == 0 || action == 2) {
                            String displayName = wrapper.read(Type.STRING);
                            displayName = ChatRewriter.legacyTextToJson(displayName);
                            wrapper.write(Type.STRING, displayName);
                            String prefix = wrapper.read(Type.STRING);
                            String suffix = wrapper.read(Type.STRING);
                            wrapper.passthrough(Type.BYTE);
                            wrapper.passthrough(Type.STRING);
                            wrapper.passthrough(Type.STRING);
                            int colour = wrapper.read(Type.BYTE).intValue();
                            if (colour == -1) {
                                colour = 21;
                            }
                            if (Via.getConfig().is1_13TeamColourFix()) {
                                colour = Protocol1_13To1_12_2.this.getLastColor(prefix).ordinal();
                                suffix = Protocol1_13To1_12_2.this.getLastColor(prefix).toString() + suffix;
                            }
                            wrapper.write(Type.VAR_INT, colour);
                            wrapper.write(Type.STRING, ChatRewriter.legacyTextToJson(prefix));
                            wrapper.write(Type.STRING, ChatRewriter.legacyTextToJson(suffix));
                        }
                        if (action == 0 || action == 3 || action == 4) {
                            String[] names = wrapper.read(Type.STRING_ARRAY);
                            for (int i = 0; i < names.length; ++i) {
                                names[i] = Protocol1_13To1_12_2.this.rewriteTeamMemberName(names[i]);
                            }
                            wrapper.write(Type.STRING_ARRAY, names);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 69, 72, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String displayName = wrapper.read(Type.STRING);
                        displayName = Protocol1_13To1_12_2.this.rewriteTeamMemberName(displayName);
                        wrapper.write(Type.STRING, displayName);
                        byte action = wrapper.read(Type.BYTE);
                        wrapper.write(Type.BYTE, action);
                        wrapper.passthrough(Type.STRING);
                        if (action != 1) {
                            wrapper.passthrough(Type.VAR_INT);
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 70, 73);
        this.registerOutgoing(State.PLAY, 71, 74);
        this.registerOutgoing(State.PLAY, 72, 75, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int action = wrapper.get(Type.VAR_INT, 0);
                        if (action >= 0 && action <= 2) {
                            wrapper.write(Type.STRING, ChatRewriter.processTranslate(wrapper.read(Type.STRING)));
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 73, 77, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int soundId = wrapper.get(Type.VAR_INT, 0);
                        wrapper.set(Type.VAR_INT, 0, Protocol1_13To1_12_2.this.getNewSoundID(soundId));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 74, 78, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.set(Type.STRING, 0, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 0)));
                        wrapper.set(Type.STRING, 1, ChatRewriter.processTranslate(wrapper.get(Type.STRING, 1)));
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 75, 79);
        this.registerOutgoing(State.PLAY, 76, 80);
        this.registerOutgoing(State.PLAY, 77, 81, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.passthrough(Type.BOOLEAN);
                        int size = wrapper.passthrough(Type.VAR_INT);
                        for (int i = 0; i < size; ++i) {
                            wrapper.passthrough(Type.STRING);
                            if (wrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                                wrapper.passthrough(Type.STRING);
                            }
                            if (wrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                                wrapper.write(Type.STRING, ChatRewriter.processTranslate(wrapper.read(Type.STRING)));
                                wrapper.write(Type.STRING, ChatRewriter.processTranslate(wrapper.read(Type.STRING)));
                                Item icon = wrapper.read(Type.ITEM);
                                InventoryPackets.toClient(icon);
                                wrapper.write(Type.FLAT_ITEM, icon);
                                wrapper.passthrough(Type.VAR_INT);
                                int flags = wrapper.passthrough(Type.INT);
                                if ((flags & 1) != 0) {
                                    wrapper.passthrough(Type.STRING);
                                }
                                wrapper.passthrough(Type.FLOAT);
                                wrapper.passthrough(Type.FLOAT);
                            }
                            wrapper.passthrough(Type.STRING_ARRAY);
                            int arrayLength = wrapper.passthrough(Type.VAR_INT);
                            for (int array = 0; array < arrayLength; ++array) {
                                wrapper.passthrough(Type.STRING_ARRAY);
                            }
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.PLAY, 78, 82);
        this.registerOutgoing(State.PLAY, 79, 83);
        this.registerIncoming(State.LOGIN, -1, 2, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, -1, 1, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 1, 5, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (Via.getConfig().isDisable1_13AutoComplete()) {
                            wrapper.cancel();
                        }
                        int tid = wrapper.read(Type.VAR_INT);
                        wrapper.user().get(TabCompleteTracker.class).setTransactionId(tid);
                    }
                });
                this.map(Type.STRING, new ValueTransformer<String, String>(Type.STRING){

                    @Override
                    public String transform(PacketWrapper wrapper, String inputValue) {
                        wrapper.user().get(TabCompleteTracker.class).setInput(inputValue);
                        return "/" + inputValue;
                    }
                });
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.BOOLEAN, false);
                        wrapper.write(Type.OPTIONAL_POSITION, null);
                        if (!wrapper.isCancelled() && Via.getConfig().get1_13TabCompleteDelay() > 0) {
                            TabCompleteTracker tracker = wrapper.user().get(TabCompleteTracker.class);
                            wrapper.cancel();
                            tracker.setTimeToSend(System.currentTimeMillis() + (long)(Via.getConfig().get1_13TabCompleteDelay() * 50));
                            tracker.setLastTabComplete(wrapper.get(Type.STRING, 0));
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 5, 6);
        this.registerIncoming(State.PLAY, 6, 7);
        this.registerIncoming(State.PLAY, 8, 9);
        this.registerIncoming(State.PLAY, 9, 11, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item item = wrapper.read(Type.FLAT_ITEM);
                        boolean isSigning = wrapper.read(Type.BOOLEAN);
                        InventoryPackets.toServer(item);
                        wrapper.write(Type.STRING, isSigning ? "MC|BSign" : "MC|BEdit");
                        wrapper.write(Type.ITEM, item);
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, -1, 12, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 10, 13);
        this.registerIncoming(State.PLAY, 11, 14);
        this.registerIncoming(State.PLAY, 12, 15);
        this.registerIncoming(State.PLAY, 13, 16);
        this.registerIncoming(State.PLAY, 14, 17);
        this.registerIncoming(State.PLAY, 15, 18);
        this.registerIncoming(State.PLAY, 16, 19);
        this.registerIncoming(State.PLAY, 17, 20);
        this.registerIncoming(State.PLAY, 9, 21, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|PickItem");
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 18, 22, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.VAR_INT, Integer.parseInt(wrapper.read(Type.STRING).substring(18)));
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 19, 23);
        this.registerIncoming(State.PLAY, 20, 24);
        this.registerIncoming(State.PLAY, 21, 25);
        this.registerIncoming(State.PLAY, 22, 26);
        this.registerIncoming(State.PLAY, 23, 27, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int type = wrapper.get(Type.VAR_INT, 0);
                        if (type == 0) {
                            wrapper.write(Type.INT, Integer.parseInt(wrapper.read(Type.STRING).substring(18)));
                        }
                        if (type == 1) {
                            wrapper.passthrough(Type.BOOLEAN);
                            wrapper.passthrough(Type.BOOLEAN);
                            wrapper.read(Type.BOOLEAN);
                            wrapper.read(Type.BOOLEAN);
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 9, 28, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|ItemName");
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 24, 29);
        this.registerIncoming(State.PLAY, 25, 30);
        this.registerIncoming(State.PLAY, 9, 31, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|TrSel");
                    }
                });
                this.map(Type.VAR_INT, Type.INT);
            }
        });
        this.registerIncoming(State.PLAY, 9, 32, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|Beacon");
                    }
                });
                this.map(Type.VAR_INT, Type.INT);
                this.map(Type.VAR_INT, Type.INT);
            }
        });
        this.registerIncoming(State.PLAY, 26, 33);
        this.registerIncoming(State.PLAY, 9, 34, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|AutoCmd");
                    }
                });
                this.handler(POS_TO_3_INT);
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int mode = wrapper.read(Type.VAR_INT);
                        byte flags = wrapper.read(Type.BYTE);
                        String stringMode = mode == 0 ? "SEQUENCE" : (mode == 1 ? "AUTO" : "REDSTONE");
                        wrapper.write(Type.BOOLEAN, (flags & 1) != 0);
                        wrapper.write(Type.STRING, stringMode);
                        wrapper.write(Type.BOOLEAN, (flags & 2) != 0);
                        wrapper.write(Type.BOOLEAN, (flags & 4) != 0);
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 9, 35, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|AdvCmd");
                        wrapper.write(Type.BYTE, (byte)1);
                    }
                });
                this.map(Type.VAR_INT, Type.INT);
            }
        });
        this.registerIncoming(State.PLAY, 9, 37, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        wrapper.write(Type.STRING, "MC|Struct");
                    }
                });
                this.handler(POS_TO_3_INT);
                this.map(Type.VAR_INT, new ValueTransformer<Integer, Byte>(Type.BYTE){

                    @Override
                    public Byte transform(PacketWrapper wrapper, Integer action) throws Exception {
                        return (byte)(action + 1);
                    }
                });
                this.map(Type.VAR_INT, new ValueTransformer<Integer, String>(Type.STRING){

                    @Override
                    public String transform(PacketWrapper wrapper, Integer mode) throws Exception {
                        return mode == 0 ? "SAVE" : (mode == 1 ? "LOAD" : (mode == 2 ? "CORNER" : "DATA"));
                    }
                });
                this.map(Type.STRING);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.BYTE, Type.INT);
                this.map(Type.VAR_INT, new ValueTransformer<Integer, String>(Type.STRING){

                    @Override
                    public String transform(PacketWrapper wrapper, Integer mirror) throws Exception {
                        return mirror == 0 ? "NONE" : (mirror == 1 ? "LEFT_RIGHT" : "FRONT_BACK");
                    }
                });
                this.map(Type.VAR_INT, new ValueTransformer<Integer, String>(Type.STRING){

                    @Override
                    public String transform(PacketWrapper wrapper, Integer rotation) throws Exception {
                        return rotation == 0 ? "NONE" : (rotation == 1 ? "CLOCKWISE_90" : (rotation == 2 ? "CLOCKWISE_180" : "COUNTERCLOCKWISE_90"));
                    }
                });
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        float integrity = wrapper.read(Type.FLOAT).floatValue();
                        long seed = wrapper.read(Type.VAR_LONG);
                        byte flags = wrapper.read(Type.BYTE);
                        wrapper.write(Type.BOOLEAN, (flags & 1) != 0);
                        wrapper.write(Type.BOOLEAN, (flags & 2) != 0);
                        wrapper.write(Type.BOOLEAN, (flags & 4) != 0);
                        wrapper.write(Type.FLOAT, Float.valueOf(integrity));
                        wrapper.write(Type.VAR_LONG, seed);
                    }
                });
            }
        });
        this.registerIncoming(State.PLAY, 28, 38);
        this.registerIncoming(State.PLAY, 29, 39);
        this.registerIncoming(State.PLAY, 30, 40);
        this.registerIncoming(State.PLAY, 31, 41);
        this.registerIncoming(State.PLAY, 32, 42);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new EntityTracker(userConnection));
        userConnection.put(new TabCompleteTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
        userConnection.put(new BlockStorage(userConnection));
        if (Via.getConfig().isServersideBlockConnections() && Via.getManager().getProviders().get(BlockConnectionProvider.class) instanceof PacketBlockConnectionProvider) {
            userConnection.put(new BlockConnectionStorage(userConnection));
        }
        if (Via.getConfig().get1_13TabCompleteDelay() > 0) {
            Via.getPlatform().runRepeatingSync(new TabCompleteThread(), 1L);
        }
    }

    @Override
    protected void register(ViaProviders providers) {
        providers.register(BlockEntityProvider.class, new BlockEntityProvider());
        providers.register(PaintingProvider.class, new PaintingProvider());
    }

    private int getNewSoundID(int oldID) {
        return MappingData.soundMappings.getNewSound(oldID);
    }

    public ChatColor getLastColor(String input) {
        int length = input.length();
        block3: for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null) continue;
            switch (color) {
                case MAGIC: 
                case BOLD: 
                case STRIKETHROUGH: 
                case UNDERLINE: 
                case ITALIC: 
                case RESET: {
                    continue block3;
                }
                default: {
                    return color;
                }
            }
        }
        return ChatColor.RESET;
    }

    protected String rewriteTeamMemberName(String name) {
        if (ChatColor.stripColor((String)name).length() == 0) {
            StringBuilder newName = new StringBuilder();
            for (int i = 1; i < name.length(); i += 2) {
                char colorChar = name.charAt(i);
                Character rewrite = SCOREBOARD_TEAM_NAME_REWRITE.get(ChatColor.getByChar((char)colorChar));
                if (rewrite == null) {
                    rewrite = Character.valueOf(colorChar);
                }
                newName.append('\u00a7').append(rewrite);
            }
            name = newName.toString();
        }
        return name;
    }

    static {
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.BLACK, Character.valueOf('g'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_BLUE, Character.valueOf('h'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_GREEN, Character.valueOf('i'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_AQUA, Character.valueOf('j'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_RED, Character.valueOf('p'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_PURPLE, Character.valueOf('q'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.GOLD, Character.valueOf('s'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.GRAY, Character.valueOf('t'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.DARK_GRAY, Character.valueOf('u'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.BLUE, Character.valueOf('v'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.GREEN, Character.valueOf('w'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.AQUA, Character.valueOf('x'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.RED, Character.valueOf('y'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.LIGHT_PURPLE, Character.valueOf('z'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.YELLOW, Character.valueOf('!'));
        SCOREBOARD_TEAM_NAME_REWRITE.put(ChatColor.WHITE, Character.valueOf('?'));
        MappingData.init();
        ConnectionData.init();
        RecipeData.init();
        BlockIdData.init();
    }
}

