/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.BlockFace;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.StairConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;

public abstract class AbstractFenceConnectionHandler
extends ConnectionHandler {
    private final String blockConnections;
    private Set<Integer> blockStates = new HashSet<Integer>();
    private Map<Byte, Integer> connectedBlockStates = new HashMap<Byte, Integer>();
    private static final StairConnectionHandler STAIR_CONNECTION_HANDLER = new StairConnectionHandler();

    public AbstractFenceConnectionHandler(String blockConnections) {
        this.blockConnections = blockConnections;
    }

    public ConnectionData.ConnectorInitAction getInitAction(final String key) {
        final AbstractFenceConnectionHandler handler = this;
        return new ConnectionData.ConnectorInitAction(){

            @Override
            public void check(WrappedBlockData blockData) {
                if (key.equals(blockData.getMinecraftKey())) {
                    if (blockData.hasData("waterlogged") && blockData.getValue("waterlogged").equals("true")) {
                        return;
                    }
                    AbstractFenceConnectionHandler.this.blockStates.add(blockData.getSavedBlockStateId());
                    ConnectionData.connectionHandlerMap.put(blockData.getSavedBlockStateId(), handler);
                    AbstractFenceConnectionHandler.this.connectedBlockStates.put(AbstractFenceConnectionHandler.this.getStates(blockData), blockData.getSavedBlockStateId());
                }
            }
        };
    }

    protected byte getStates(WrappedBlockData blockData) {
        byte states = 0;
        if (blockData.getValue("east").equals("true")) {
            states = (byte)(states | 1);
        }
        if (blockData.getValue("north").equals("true")) {
            states = (byte)(states | 2);
        }
        if (blockData.getValue("south").equals("true")) {
            states = (byte)(states | 4);
        }
        if (blockData.getValue("west").equals("true")) {
            states = (byte)(states | 8);
        }
        return states;
    }

    protected byte getStates(UserConnection user, Position position, int blockState) {
        boolean pre1_12;
        byte states = 0;
        boolean bl = pre1_12 = user.get(ProtocolInfo.class).getServerProtocolVersion() < ProtocolVersion.v1_12.getId();
        if (this.connects(BlockFace.EAST, this.getBlockData(user, position.getRelative(BlockFace.EAST)), pre1_12)) {
            states = (byte)(states | 1);
        }
        if (this.connects(BlockFace.NORTH, this.getBlockData(user, position.getRelative(BlockFace.NORTH)), pre1_12)) {
            states = (byte)(states | 2);
        }
        if (this.connects(BlockFace.SOUTH, this.getBlockData(user, position.getRelative(BlockFace.SOUTH)), pre1_12)) {
            states = (byte)(states | 4);
        }
        if (this.connects(BlockFace.WEST, this.getBlockData(user, position.getRelative(BlockFace.WEST)), pre1_12)) {
            states = (byte)(states | 8);
        }
        return states;
    }

    @Override
    public int getBlockData(UserConnection user, Position position) {
        return STAIR_CONNECTION_HANDLER.connect(user, position, super.getBlockData(user, position));
    }

    @Override
    public int connect(UserConnection user, Position position, int blockState) {
        Integer newBlockState = this.connectedBlockStates.get(this.getStates(user, position, blockState));
        return newBlockState == null ? blockState : newBlockState;
    }

    protected boolean connects(BlockFace side, int blockState, boolean pre1_12) {
        return this.blockStates.contains(blockState) || this.blockConnections != null && ConnectionData.blockConnectionData.containsKey(blockState) && ConnectionData.blockConnectionData.get(blockState).connectsTo(this.blockConnections, side.opposite(), pre1_12);
    }

    public Set<Integer> getBlockStates() {
        return this.blockStates;
    }
}

