/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.BlockFace;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;

public class AbstractStempConnectionHandler
extends ConnectionHandler {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST};
    private int baseStateId;
    private Set<Integer> blockId = new HashSet<Integer>();
    private Map<BlockFace, Integer> stemps = new HashMap<BlockFace, Integer>();

    public AbstractStempConnectionHandler(String baseStateId) {
        this.baseStateId = ConnectionData.getId(baseStateId);
    }

    public ConnectionData.ConnectorInitAction getInitAction(final String blockId, final String toKey) {
        final AbstractStempConnectionHandler handler = this;
        return new ConnectionData.ConnectorInitAction(){

            @Override
            public void check(WrappedBlockData blockData) {
                if (blockData.getSavedBlockStateId() == AbstractStempConnectionHandler.this.baseStateId || blockId.equals(blockData.getMinecraftKey())) {
                    if (blockData.getSavedBlockStateId() != AbstractStempConnectionHandler.this.baseStateId) {
                        handler.blockId.add(blockData.getSavedBlockStateId());
                    }
                    ConnectionData.connectionHandlerMap.put(blockData.getSavedBlockStateId(), handler);
                }
                if (blockData.getMinecraftKey().equals(toKey)) {
                    String facing = blockData.getValue("facing").toUpperCase();
                    AbstractStempConnectionHandler.this.stemps.put(BlockFace.valueOf(facing), blockData.getSavedBlockStateId());
                }
            }
        };
    }

    @Override
    public int connect(UserConnection user, Position position, int blockState) {
        if (blockState != this.baseStateId) {
            return blockState;
        }
        for (BlockFace blockFace : BLOCK_FACES) {
            if (!this.blockId.contains(this.getBlockData(user, position.getRelative(blockFace)))) continue;
            return this.stemps.get((Object)blockFace);
        }
        return this.baseStateId;
    }
}

