/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.BlockChangeRecord;
import us.myles.ViaVersion.api.minecraft.BlockFace;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.Protocol1_13To1_12_2;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.BasicFenceConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.BlockData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ChestConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ChorusPlantConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.DoorConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.FlowerConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.GlassConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.MelonConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.NetherFenceConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.PumpkinConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.RedstoneConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.SnowyGrassConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.StairConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.TripwireConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.WallConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.providers.BlockConnectionProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.providers.PacketBlockConnectionProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;

public class ConnectionData {
    static Map<Integer, String> idToKey = new HashMap<Integer, String>();
    static Map<String, Integer> keyToId = new HashMap<String, Integer>();
    static Map<Integer, ConnectionHandler> connectionHandlerMap = new HashMap<Integer, ConnectionHandler>();
    static Map<Integer, BlockData> blockConnectionData = new HashMap<Integer, BlockData>();
    static Set<Integer> occludingStates = new HashSet<Integer>();

    public static void update(UserConnection user, Position position) {
        for (BlockFace face : BlockFace.values()) {
            Position pos = new Position(position.getX() + (long)face.getModX(), position.getY() + (long)face.getModY(), position.getZ() + (long)face.getModZ());
            int blockState = Via.getManager().getProviders().get(BlockConnectionProvider.class).getBlockdata(user, pos);
            if (!ConnectionData.connects(blockState)) continue;
            int newBlockState = ConnectionData.connect(user, pos, blockState);
            PacketWrapper blockUpdatePacket = new PacketWrapper(11, null, user);
            blockUpdatePacket.write(Type.POSITION, pos);
            blockUpdatePacket.write(Type.VAR_INT, newBlockState);
            try {
                blockUpdatePacket.send(Protocol1_13To1_12_2.class, true, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void updateChunkSectionNeighbours(UserConnection user, int chunkX, int chunkZ, int chunkSectionY) {
        for (int chunkDeltaX = -1; chunkDeltaX <= 1; ++chunkDeltaX) {
            for (int chunkDeltaZ = -1; chunkDeltaZ <= 1; ++chunkDeltaZ) {
                int blockY;
                if (Math.abs(chunkDeltaX) + Math.abs(chunkDeltaZ) == 0) continue;
                ArrayList<BlockChangeRecord> updates = new ArrayList<BlockChangeRecord>();
                if (Math.abs(chunkDeltaX) + Math.abs(chunkDeltaZ) == 2) {
                    for (blockY = chunkSectionY * 16; blockY < chunkSectionY * 16 + 16; ++blockY) {
                        int blockPosX = chunkDeltaX == 1 ? 0 : 15;
                        int blockPosZ = chunkDeltaZ == 1 ? 0 : 15;
                        ConnectionData.updateBlock(user, new Position((long)(chunkX + chunkDeltaX << 4) + (long)blockPosX, Long.valueOf(blockY), (long)(chunkZ + chunkDeltaZ << 4) + (long)blockPosZ), updates);
                    }
                } else {
                    for (blockY = chunkSectionY * 16; blockY < chunkSectionY * 16 + 16; ++blockY) {
                        int zEnd;
                        int zStart;
                        int xEnd;
                        int xStart;
                        if (chunkDeltaX == 1) {
                            xStart = 0;
                            xEnd = 2;
                            zStart = 0;
                            zEnd = 16;
                        } else if (chunkDeltaX == -1) {
                            xStart = 14;
                            xEnd = 16;
                            zStart = 0;
                            zEnd = 16;
                        } else if (chunkDeltaZ == 1) {
                            xStart = 0;
                            xEnd = 16;
                            zStart = 0;
                            zEnd = 2;
                        } else {
                            xStart = 0;
                            xEnd = 16;
                            zStart = 14;
                            zEnd = 16;
                        }
                        for (int blockX = xStart; blockX < xEnd; ++blockX) {
                            for (int blockZ = zStart; blockZ < zEnd; ++blockZ) {
                                ConnectionData.updateBlock(user, new Position((long)(chunkX + chunkDeltaX << 4) + (long)blockX, Long.valueOf(blockY), (long)(chunkZ + chunkDeltaZ << 4) + (long)blockZ), updates);
                            }
                        }
                    }
                }
                if (updates.isEmpty()) continue;
                PacketWrapper wrapper = new PacketWrapper(15, null, user);
                wrapper.write(Type.INT, chunkX + chunkDeltaX);
                wrapper.write(Type.INT, chunkZ + chunkDeltaZ);
                wrapper.write(Type.BLOCK_CHANGE_RECORD_ARRAY, updates.toArray(new BlockChangeRecord[0]));
                try {
                    wrapper.send(Protocol1_13To1_12_2.class);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void updateBlock(UserConnection user, Position pos, List<BlockChangeRecord> records) {
        int blockState = Via.getManager().getProviders().get(BlockConnectionProvider.class).getBlockdata(user, pos);
        if (!ConnectionData.connects(blockState)) {
            return;
        }
        int newBlockState = ConnectionData.connect(user, pos, blockState);
        records.add(new BlockChangeRecord((short)((pos.getX() & 0xFL) << 4 | pos.getZ() & 0xFL), pos.getY().shortValue(), newBlockState));
    }

    public static BlockConnectionProvider getProvider() {
        return Via.getManager().getProviders().get(BlockConnectionProvider.class);
    }

    public static void updateBlockStorage(UserConnection userConnection, Position position, int blockState) {
        if (!ConnectionData.needStoreBlocks()) {
            return;
        }
        if (ConnectionData.isWelcome(blockState)) {
            ConnectionData.getProvider().storeBlock(userConnection, position, blockState);
        } else {
            ConnectionData.getProvider().removeBlock(userConnection, position);
        }
    }

    public static void clearBlockStorage(UserConnection connection) {
        if (!ConnectionData.needStoreBlocks()) {
            return;
        }
        ConnectionData.getProvider().clearStorage(connection);
    }

    public static boolean needStoreBlocks() {
        return ConnectionData.getProvider().storesBlocks();
    }

    public static void connectBlocks(UserConnection user, Chunk chunk) {
        long xOff = chunk.getX() << 4;
        long zOff = chunk.getZ() << 4;
        for (int i = 0; i < chunk.getSections().length; ++i) {
            ChunkSection section = chunk.getSections()[i];
            if (section == null) continue;
            boolean willConnect = false;
            for (int p = 0; p < section.getPaletteSize(); ++p) {
                int id = section.getPaletteEntry(p);
                if (!ConnectionData.connects(id)) continue;
                willConnect = true;
                break;
            }
            if (!willConnect) continue;
            long yOff = i << 4;
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int block = section.getFlatBlock(x, y, z);
                        if (!ConnectionData.connects(block)) continue;
                        block = ConnectionData.connect(user, new Position(xOff + (long)x, yOff + (long)y, zOff + (long)z), block);
                        section.setFlatBlock(x, y, z, block);
                    }
                }
            }
            ConnectionData.updateChunkSectionNeighbours(user, chunk.getX(), chunk.getZ(), i);
        }
    }

    public static void init() {
        if (!Via.getConfig().isServersideBlockConnections()) {
            return;
        }
        Via.getPlatform().getLogger().info("Loading block connection mappings ...");
        JsonObject mapping1_13 = MappingData.loadData("mapping-1.13.json");
        JsonObject blocks1_13 = mapping1_13.getAsJsonObject("blocks");
        for (Object blockState : blocks1_13.entrySet()) {
            Integer id = Integer.parseInt((String)blockState.getKey());
            String key = ((JsonElement)blockState.getValue()).getAsString();
            idToKey.put(id, key);
            keyToId.put(key, id);
        }
        if (!Via.getConfig().isReduceBlockStorageMemory()) {
            JsonObject mappingBlockConnections = MappingData.loadData("blockConnections.json");
            for (Object entry : mappingBlockConnections.entrySet()) {
                int id = keyToId.get(entry.getKey());
                BlockData blockData = new BlockData();
                for (Map.Entry type : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                    String name = (String)type.getKey();
                    JsonObject object = ((JsonElement)type.getValue()).getAsJsonObject();
                    boolean[] data = new boolean[6];
                    for (BlockFace value : BlockFace.values()) {
                        String face = value.toString().toLowerCase();
                        if (!object.has(face)) continue;
                        data[value.ordinal()] = object.getAsJsonPrimitive(face).getAsBoolean();
                    }
                    blockData.put(name, data);
                }
                if (((String)entry.getKey()).contains("stairs")) {
                    blockData.put("allFalseIfStairPre1_12", new boolean[6]);
                }
                blockConnectionData.put(id, blockData);
            }
        }
        JsonObject blockData = MappingData.loadData("blockData.json");
        JsonArray occluding = blockData.getAsJsonArray("occluding");
        for (JsonElement jsonElement : occluding) {
            occludingStates.add(keyToId.get(jsonElement.getAsString()));
        }
        ArrayList<ConnectorInitAction> initActions = new ArrayList<ConnectorInitAction>();
        initActions.add(PumpkinConnectionHandler.init());
        initActions.addAll(BasicFenceConnectionHandler.init());
        initActions.add(NetherFenceConnectionHandler.init());
        initActions.addAll(WallConnectionHandler.init());
        initActions.add(MelonConnectionHandler.init());
        initActions.addAll(GlassConnectionHandler.init());
        initActions.add(ChestConnectionHandler.init());
        initActions.add(DoorConnectionHandler.init());
        initActions.add(RedstoneConnectionHandler.init());
        initActions.add(StairConnectionHandler.init());
        initActions.add(FlowerConnectionHandler.init());
        initActions.addAll(ChorusPlantConnectionHandler.init());
        initActions.add(TripwireConnectionHandler.init());
        initActions.add(SnowyGrassConnectionHandler.init());
        for (String key : keyToId.keySet()) {
            WrappedBlockData wrappedBlockData = WrappedBlockData.fromString(key);
            for (ConnectorInitAction action : initActions) {
                action.check(wrappedBlockData);
            }
        }
        if (Via.getConfig().getBlockConnectionMethod().equalsIgnoreCase("packet")) {
            Via.getManager().getProviders().register(BlockConnectionProvider.class, new PacketBlockConnectionProvider());
        }
    }

    public static boolean isWelcome(int blockState) {
        return blockConnectionData.containsKey(blockState) || connectionHandlerMap.containsKey(blockState);
    }

    public static boolean connects(int blockState) {
        return connectionHandlerMap.containsKey(blockState);
    }

    public static int connect(UserConnection user, Position position, int blockState) {
        if (connectionHandlerMap.containsKey(blockState)) {
            ConnectionHandler handler = connectionHandlerMap.get(blockState);
            return handler.connect(user, position, blockState);
        }
        return blockState;
    }

    public static int getId(String key) {
        return keyToId.containsKey(key) ? keyToId.get(key) : -1;
    }

    public static String getKey(int id) {
        return idToKey.get(id);
    }

    static interface ConnectorInitAction {
        public void check(WrappedBlockData var1);
    }
}

