/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.BlockFace;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.BlockData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;

public class RedstoneConnectionHandler
extends ConnectionHandler {
    private static Set<Integer> redstone = new HashSet<Integer>();
    private static Map<Short, Integer> connectedBlockStates = new HashMap<Short, Integer>();
    private static Map<Integer, Integer> powerMappings = new HashMap<Integer, Integer>();

    static ConnectionData.ConnectorInitAction init() {
        final RedstoneConnectionHandler connectionHandler = new RedstoneConnectionHandler();
        String redstoneKey = "minecraft:redstone_wire";
        return new ConnectionData.ConnectorInitAction(){

            @Override
            public void check(WrappedBlockData blockData) {
                if (!"minecraft:redstone_wire".equals(blockData.getMinecraftKey())) {
                    return;
                }
                redstone.add(blockData.getSavedBlockStateId());
                ConnectionData.connectionHandlerMap.put(blockData.getSavedBlockStateId(), connectionHandler);
                connectedBlockStates.put(RedstoneConnectionHandler.getStates(blockData), blockData.getSavedBlockStateId());
                powerMappings.put(blockData.getSavedBlockStateId(), Integer.valueOf(blockData.getValue("power")));
            }
        };
    }

    private static short getStates(WrappedBlockData data) {
        short b = 0;
        b = (short)(b | RedstoneConnectionHandler.getState(data.getValue("east")));
        b = (short)(b | RedstoneConnectionHandler.getState(data.getValue("north")) << 2);
        b = (short)(b | RedstoneConnectionHandler.getState(data.getValue("south")) << 4);
        b = (short)(b | RedstoneConnectionHandler.getState(data.getValue("west")) << 6);
        b = (short)(b | Integer.valueOf(data.getValue("power")) << 8);
        return b;
    }

    private static int getState(String value) {
        switch (value) {
            case "none": {
                return 0;
            }
            case "side": {
                return 1;
            }
            case "up": {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int connect(UserConnection user, Position position, int blockState) {
        short b = 0;
        b = (short)(b | this.connects(user, position, BlockFace.EAST));
        b = (short)(b | this.connects(user, position, BlockFace.NORTH) << 2);
        b = (short)(b | this.connects(user, position, BlockFace.SOUTH) << 4);
        b = (short)(b | this.connects(user, position, BlockFace.WEST) << 6);
        Integer newBlockState = connectedBlockStates.get(b = (short)((short)(b | powerMappings.get(blockState) << 8)));
        return newBlockState == null ? blockState : newBlockState;
    }

    private int connects(UserConnection user, Position position, BlockFace side) {
        Position relative = position.getRelative(side);
        int blockState = this.getBlockData(user, relative);
        if (this.connects(side, blockState)) {
            return 1;
        }
        int up = this.getBlockData(user, relative.getRelative(BlockFace.TOP));
        if (redstone.contains(up) && !ConnectionData.occludingStates.contains(this.getBlockData(user, position.getRelative(BlockFace.TOP)))) {
            return 2;
        }
        int down = this.getBlockData(user, relative.getRelative(BlockFace.BOTTOM));
        if (redstone.contains(down) && !ConnectionData.occludingStates.contains(this.getBlockData(user, relative))) {
            return 1;
        }
        return 0;
    }

    private boolean connects(BlockFace side, int blockState) {
        BlockData blockData = ConnectionData.blockConnectionData.get(blockState);
        return blockData != null && blockData.connectsTo("redstoneConnections", side.opposite(), false);
    }
}

