/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.util.GsonUtil;

public class MappingData {
    public static BiMap<Integer, Integer> oldToNewItems = HashBiMap.create();
    public static Map<String, Integer[]> blockTags = new HashMap<String, Integer[]>();
    public static Map<String, Integer[]> itemTags = new HashMap<String, Integer[]>();
    public static Map<String, Integer[]> fluidTags = new HashMap<String, Integer[]>();
    public static BiMap<Short, String> oldEnchantmentsIds = HashBiMap.create();
    public static Map<String, String> translateMapping = new HashMap<String, String>();
    public static Map<String, String> mojangTranslation = new HashMap<String, String>();
    public static EnchantmentMappings enchantmentMappings;
    public static SoundMappings soundMappings;
    public static BlockMappings blockMappings;

    public static void init() {
        JsonObject mapping1_12 = MappingData.loadData("mapping-1.12.json");
        JsonObject mapping1_13 = MappingData.loadData("mapping-1.13.json");
        Via.getPlatform().getLogger().info("Loading block mapping...");
        blockMappings = new BlockMappingsShortArray(mapping1_12.getAsJsonObject("blocks"), mapping1_13.getAsJsonObject("blocks"));
        Via.getPlatform().getLogger().info("Loading item mapping...");
        MappingData.mapIdentifiers(oldToNewItems, mapping1_12.getAsJsonObject("items"), mapping1_13.getAsJsonObject("items"));
        Via.getPlatform().getLogger().info("Loading new tags...");
        MappingData.loadTags(blockTags, mapping1_13.getAsJsonObject("block_tags"));
        MappingData.loadTags(itemTags, mapping1_13.getAsJsonObject("item_tags"));
        MappingData.loadTags(fluidTags, mapping1_13.getAsJsonObject("fluid_tags"));
        Via.getPlatform().getLogger().info("Loading enchantments...");
        MappingData.loadEnchantments(oldEnchantmentsIds, mapping1_12.getAsJsonObject("enchantments"));
        enchantmentMappings = new EnchantmentMappingByteArray(mapping1_12.getAsJsonObject("enchantments"), mapping1_13.getAsJsonObject("enchantments"));
        Via.getPlatform().getLogger().info("Loading sound mapping...");
        soundMappings = new SoundMappingShortArray(mapping1_12.getAsJsonArray("sounds"), mapping1_13.getAsJsonArray("sounds"));
        Via.getPlatform().getLogger().info("Loading translation mappping");
        translateMapping = new HashMap<String, String>();
        Map translateData = (Map)GsonUtil.getGson().fromJson((Reader)new InputStreamReader(MappingData.class.getClassLoader().getResourceAsStream("assets/viaversion/data/mapping-lang-1.12-1.13.json")), new TypeToken<Map<String, String>>(){}.getType());
        try {
            String[] lines;
            try (InputStreamReader reader = new InputStreamReader(MappingData.class.getClassLoader().getResourceAsStream("mojang-translations/en_US.properties"), StandardCharsets.UTF_8);){
                lines = CharStreams.toString((Readable)reader).split("\n");
            }
            for (String line : lines) {
                String[] keyAndTranslation;
                if (line.isEmpty() || (keyAndTranslation = line.split("=", 2)).length != 2) continue;
                String key = keyAndTranslation[0];
                String translation = keyAndTranslation[1].replaceAll("%(\\d\\$)?d", "%$1s");
                if (!translateData.containsKey(key)) {
                    translateMapping.put(key, translation);
                    continue;
                }
                String dataValue = (String)translateData.get(keyAndTranslation[0]);
                if (dataValue == null) continue;
                translateMapping.put(key, dataValue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject loadData(String name) {
        InputStream stream = MappingData.class.getClassLoader().getResourceAsStream("assets/viaversion/data/" + name);
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            JsonObject jsonObject;
            JsonObject jsonObject2 = jsonObject = (JsonObject)GsonUtil.getGson().fromJson((Reader)reader, JsonObject.class);
            return jsonObject2;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void mapIdentifiers(Map<Integer, Integer> output, JsonObject oldIdentifiers, JsonObject newIdentifiers) {
        for (Map.Entry entry : oldIdentifiers.entrySet()) {
            Map.Entry<String, JsonElement> value = MappingData.findValue(newIdentifiers, ((JsonElement)entry.getValue()).getAsString());
            if (value == null) {
                if (Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug()) continue;
                Via.getPlatform().getLogger().warning("No key for " + entry.getValue() + " :( ");
                continue;
            }
            output.put(Integer.parseInt((String)entry.getKey()), Integer.parseInt(value.getKey()));
        }
    }

    private static void mapIdentifiers(short[] output, JsonObject oldIdentifiers, JsonObject newIdentifiers) {
        for (Map.Entry entry : oldIdentifiers.entrySet()) {
            Map.Entry<String, JsonElement> value = MappingData.findValue(newIdentifiers, ((JsonElement)entry.getValue()).getAsString());
            if (value == null) {
                if (Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug()) continue;
                Via.getPlatform().getLogger().warning("No key for " + entry.getValue() + " :( ");
                continue;
            }
            output[Integer.parseInt((String)((String)entry.getKey()))] = Short.parseShort(value.getKey());
        }
    }

    private static void mapIdentifiers(byte[] output, JsonObject oldIdentifiers, JsonObject newIdentifiers) {
        for (Map.Entry entry : oldIdentifiers.entrySet()) {
            Map.Entry<String, JsonElement> value = MappingData.findValue(newIdentifiers, ((JsonElement)entry.getValue()).getAsString());
            if (value == null) {
                Via.getPlatform().getLogger().warning("No key for " + entry.getValue() + " :( ");
                continue;
            }
            output[Integer.parseInt((String)((String)entry.getKey()))] = Byte.parseByte(value.getKey());
        }
    }

    private static void mapIdentifiers(short[] output, JsonArray oldIdentifiers, JsonArray newIdentifiers) {
        for (int i = 0; i < oldIdentifiers.size(); ++i) {
            JsonElement v = oldIdentifiers.get(i);
            Integer index = MappingData.findIndex(newIdentifiers, v.getAsString());
            if (index == null) {
                if (Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug()) continue;
                Via.getPlatform().getLogger().warning("No key for " + v + " :( ");
                continue;
            }
            output[i] = index.shortValue();
        }
    }

    private static void loadTags(Map<String, Integer[]> output, JsonObject newTags) {
        for (Map.Entry entry : newTags.entrySet()) {
            JsonArray ids = ((JsonElement)entry.getValue()).getAsJsonArray();
            Integer[] idsArray = new Integer[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                idsArray[i] = ids.get(i).getAsInt();
            }
            output.put((String)entry.getKey(), idsArray);
        }
    }

    private static void loadEnchantments(Map<Short, String> output, JsonObject enchantments) {
        for (Map.Entry enchantment : enchantments.entrySet()) {
            output.put(Short.parseShort((String)enchantment.getKey()), ((JsonElement)enchantment.getValue()).getAsString());
        }
    }

    private static Map.Entry<String, JsonElement> findValue(JsonObject object, String needle) {
        for (Map.Entry entry : object.entrySet()) {
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!value.equals(needle)) continue;
            return entry;
        }
        return null;
    }

    private static Integer findIndex(JsonArray array, String value) {
        for (int i = 0; i < array.size(); ++i) {
            JsonElement v = array.get(i);
            if (!v.getAsString().equals(value)) continue;
            return i;
        }
        return null;
    }

    private static class EnchantmentMappingByteArray
    implements EnchantmentMappings {
        private byte[] oldToNew = new byte[72];

        private EnchantmentMappingByteArray(JsonObject m1_12, JsonObject m1_13) {
            Arrays.fill(this.oldToNew, (byte)-1);
            MappingData.mapIdentifiers(this.oldToNew, m1_12, m1_13);
        }

        @Override
        public int getNewEnchantment(int old) {
            return old >= 0 && old < this.oldToNew.length ? this.oldToNew[old] : -1;
        }
    }

    public static interface EnchantmentMappings {
        public int getNewEnchantment(int var1);
    }

    private static class SoundMappingShortArray
    implements SoundMappings {
        private short[] oldToNew = new short[662];

        private SoundMappingShortArray(JsonArray mapping1_12, JsonArray mapping1_13) {
            Arrays.fill(this.oldToNew, (short)-1);
            MappingData.mapIdentifiers(this.oldToNew, mapping1_12, mapping1_13);
        }

        @Override
        public int getNewSound(int old) {
            return old >= 0 && old < this.oldToNew.length ? this.oldToNew[old] : -1;
        }
    }

    public static interface SoundMappings {
        public int getNewSound(int var1);
    }

    private static class BlockMappingsShortArray
    implements BlockMappings {
        private short[] oldToNew = new short[4084];

        private BlockMappingsShortArray(JsonObject mapping1_12, JsonObject mapping1_13) {
            Arrays.fill(this.oldToNew, (short)-1);
            MappingData.mapIdentifiers(this.oldToNew, mapping1_12, mapping1_13);
            if (Via.getConfig().isSnowCollisionFix()) {
                this.oldToNew[1248] = 3416;
            }
        }

        @Override
        public int getNewBlock(int old) {
            return old >= 0 && old < this.oldToNew.length ? this.oldToNew[old] : -1;
        }
    }

    public static interface BlockMappings {
        public int getNewBlock(int var1);
    }
}

