/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.Particle;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.InventoryPackets;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.WorldPackets;

public class ParticleRewriter {
    private static List<NewParticle> particles = new LinkedList<NewParticle>();

    public static Particle rewriteParticle(int particleId, Integer[] data) {
        if (particleId >= particles.size()) {
            Via.getPlatform().getLogger().severe("Failed to transform particles with id " + particleId + " and data " + Arrays.toString((Object[])data));
            return null;
        }
        NewParticle rewrite = particles.get(particleId);
        return rewrite.handle(new Particle(rewrite.getId()), data);
    }

    private static void add(int newId) {
        particles.add(new NewParticle(newId, null));
    }

    private static void add(int newId, ParticleDataHandler dataHandler) {
        particles.add(new NewParticle(newId, dataHandler));
    }

    private static ParticleDataHandler reddustHandler() {
        return new ParticleDataHandler(){

            @Override
            public Particle handler(Particle particle, Integer[] data) {
                particle.getArguments().add(new Particle.ParticleData(Type.FLOAT, Float.valueOf(ParticleRewriter.randomBool() ? 1.0f : 0.0f)));
                particle.getArguments().add(new Particle.ParticleData(Type.FLOAT, Float.valueOf(0.0f)));
                particle.getArguments().add(new Particle.ParticleData(Type.FLOAT, Float.valueOf(ParticleRewriter.randomBool() ? 1.0f : 0.0f)));
                particle.getArguments().add(new Particle.ParticleData(Type.FLOAT, Float.valueOf(1.0f)));
                return particle;
            }
        };
    }

    private static boolean randomBool() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    private static ParticleDataHandler iconcrackHandler() {
        return new ParticleDataHandler(){

            @Override
            public Particle handler(Particle particle, Integer[] data) {
                Item item;
                if (data.length == 1) {
                    item = new Item(data[0].shortValue(), 1, 0, null);
                } else if (data.length == 2) {
                    item = new Item(data[0].shortValue(), 1, data[1].shortValue(), null);
                } else {
                    return particle;
                }
                InventoryPackets.toClient(item);
                particle.getArguments().add(new Particle.ParticleData(Type.FLAT_ITEM, item));
                return particle;
            }
        };
    }

    private static ParticleDataHandler blockHandler() {
        return new ParticleDataHandler(){

            @Override
            public Particle handler(Particle particle, Integer[] data) {
                int value = data[0];
                int combined = (value & 0xFFF) << 4 | value >> 12 & 0xF;
                int newId = WorldPackets.toNewId(combined);
                particle.getArguments().add(new Particle.ParticleData(Type.VAR_INT, newId));
                return particle;
            }
        };
    }

    static {
        ParticleRewriter.add(34);
        ParticleRewriter.add(19);
        ParticleRewriter.add(18);
        ParticleRewriter.add(21);
        ParticleRewriter.add(4);
        ParticleRewriter.add(43);
        ParticleRewriter.add(22);
        ParticleRewriter.add(42);
        ParticleRewriter.add(42);
        ParticleRewriter.add(6);
        ParticleRewriter.add(14);
        ParticleRewriter.add(37);
        ParticleRewriter.add(30);
        ParticleRewriter.add(12);
        ParticleRewriter.add(26);
        ParticleRewriter.add(17);
        ParticleRewriter.add(0);
        ParticleRewriter.add(44);
        ParticleRewriter.add(10);
        ParticleRewriter.add(9);
        ParticleRewriter.add(1);
        ParticleRewriter.add(24);
        ParticleRewriter.add(32);
        ParticleRewriter.add(33);
        ParticleRewriter.add(35);
        ParticleRewriter.add(15);
        ParticleRewriter.add(23);
        ParticleRewriter.add(31);
        ParticleRewriter.add(-1);
        ParticleRewriter.add(5);
        ParticleRewriter.add(11, ParticleRewriter.reddustHandler());
        ParticleRewriter.add(29);
        ParticleRewriter.add(34);
        ParticleRewriter.add(28);
        ParticleRewriter.add(25);
        ParticleRewriter.add(2);
        ParticleRewriter.add(27, ParticleRewriter.iconcrackHandler());
        ParticleRewriter.add(3, ParticleRewriter.blockHandler());
        ParticleRewriter.add(3, ParticleRewriter.blockHandler());
        ParticleRewriter.add(36);
        ParticleRewriter.add(-1);
        ParticleRewriter.add(13);
        ParticleRewriter.add(8);
        ParticleRewriter.add(16);
        ParticleRewriter.add(7);
        ParticleRewriter.add(40);
        ParticleRewriter.add(20, ParticleRewriter.blockHandler());
        ParticleRewriter.add(41);
        ParticleRewriter.add(38);
    }

    private static class NewParticle {
        private final int id;
        private final ParticleDataHandler handler;

        public Particle handle(Particle particle, Integer[] data) {
            if (this.handler != null) {
                return this.handler.handler(particle, data);
            }
            return particle;
        }

        public int getId() {
            return this.id;
        }

        public ParticleDataHandler getHandler() {
            return this.handler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewParticle)) {
                return false;
            }
            NewParticle other = (NewParticle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            ParticleDataHandler this$handler = this.getHandler();
            ParticleDataHandler other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NewParticle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            ParticleDataHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "ParticleRewriter.NewParticle(id=" + this.getId() + ", handler=" + this.getHandler() + ")";
        }

        public NewParticle(int id, ParticleDataHandler handler) {
            this.id = id;
            this.handler = handler;
        }
    }

    static interface ParticleDataHandler {
        public Particle handler(Particle var1, Integer[] var2);
    }
}

