/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import lombok.NonNull;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;
import us.myles.ViaVersion.util.GsonUtil;

public class RecipeData {
    public static Map<String, Recipe> recipes;

    public static void init() {
        InputStream stream = MappingData.class.getClassLoader().getResourceAsStream("assets/viaversion/data/itemrecipes1_12_2to1_13.json");
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            recipes = (Map)GsonUtil.getGson().fromJson((Reader)reader, new TypeToken<Map<String, Recipe>>(){}.getType());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class Recipe {
        @NonNull
        private String type;
        private String group;
        private int width;
        private int height;
        private float experience;
        private int cookingTime;
        private Item[] ingredient;
        private Item[][] ingredients;
        private Item result;

        public Recipe(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
        }

        @NonNull
        public String getType() {
            return this.type;
        }

        public String getGroup() {
            return this.group;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getCookingTime() {
            return this.cookingTime;
        }

        public Item[] getIngredient() {
            return this.ingredient;
        }

        public Item[][] getIngredients() {
            return this.ingredients;
        }

        public Item getResult() {
            return this.result;
        }

        public void setType(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setExperience(float experience) {
            this.experience = experience;
        }

        public void setCookingTime(int cookingTime) {
            this.cookingTime = cookingTime;
        }

        public void setIngredient(Item[] ingredient) {
            this.ingredient = ingredient;
        }

        public void setIngredients(Item[][] ingredients) {
            this.ingredients = ingredients;
        }

        public void setResult(Item result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Recipe)) {
                return false;
            }
            Recipe other = (Recipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            if (this.getCookingTime() != other.getCookingTime()) {
                return false;
            }
            if (!Arrays.deepEquals(this.getIngredient(), other.getIngredient())) {
                return false;
            }
            if (!Arrays.deepEquals((Object[])this.getIngredients(), (Object[])other.getIngredients())) {
                return false;
            }
            Item this$result = this.getResult();
            Item other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Recipe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            result = result * 59 + Float.floatToIntBits(this.getExperience());
            result = result * 59 + this.getCookingTime();
            result = result * 59 + Arrays.deepHashCode(this.getIngredient());
            result = result * 59 + Arrays.deepHashCode((Object[])this.getIngredients());
            Item $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "RecipeData.Recipe(type=" + this.getType() + ", group=" + this.getGroup() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", experience=" + this.getExperience() + ", cookingTime=" + this.getCookingTime() + ", ingredient=" + Arrays.deepToString(this.getIngredient()) + ", ingredients=" + Arrays.deepToString((Object[])this.getIngredients()) + ", result=" + this.getResult() + ")";
        }
    }
}

