/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets;

import com.github.steveice10.opennbt.conversion.ConverterRegistry;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.ChatRewriter;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.BlockIdData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.SoundSource;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.SpawnEggRewriter;

public class InventoryPackets {
    private static String NBT_TAG_NAME;

    public static void register(Protocol protocol) {
        NBT_TAG_NAME = "ViaVersion|" + protocol.getClass().getSimpleName();
        protocol.registerOutgoing(State.PLAY, 22, 23, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item stack = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toClient(stack);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 20, 21, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.ITEM_ARRAY, Type.FLAT_ITEM_ARRAY);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item[] stacks;
                        for (Item stack : stacks = wrapper.get(Type.FLAT_ITEM_ARRAY, 0)) {
                            InventoryPackets.toClient(stack);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 21, 22, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        short property = wrapper.get(Type.SHORT, 0);
                        if (property >= 4 && property <= 6) {
                            wrapper.set(Type.SHORT, 1, (short)MappingData.enchantmentMappings.getNewEnchantment(wrapper.get(Type.SHORT, 1).shortValue()));
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 24, 25, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String channel = wrapper.get(Type.STRING, 0);
                        if (channel.equalsIgnoreCase("MC|StopSound")) {
                            String originalSource = wrapper.read(Type.STRING);
                            String originalSound = wrapper.read(Type.STRING);
                            wrapper.clearPacket();
                            wrapper.setId(76);
                            byte flags = 0;
                            wrapper.write(Type.BYTE, flags);
                            if (!originalSource.isEmpty()) {
                                flags = (byte)(flags | 1);
                                Optional finalSource = SoundSource.findBySource(originalSource);
                                if (!finalSource.isPresent()) {
                                    if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                                        Via.getPlatform().getLogger().info("Could not handle unknown sound source " + originalSource + " falling back to default: master");
                                    }
                                    finalSource = Optional.of((Object)((Object)SoundSource.MASTER));
                                }
                                wrapper.write(Type.VAR_INT, ((SoundSource)((Object)finalSource.get())).getId());
                            }
                            if (!originalSound.isEmpty()) {
                                flags = (byte)(flags | 2);
                                wrapper.write(Type.STRING, originalSound);
                            }
                            wrapper.set(Type.BYTE, 0, flags);
                            return;
                        }
                        if (channel.equalsIgnoreCase("MC|TrList")) {
                            channel = "minecraft:trader_list";
                            wrapper.passthrough(Type.INT);
                            int size = wrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
                            for (int i = 0; i < size; ++i) {
                                Item input = wrapper.read(Type.ITEM);
                                InventoryPackets.toClient(input);
                                wrapper.write(Type.FLAT_ITEM, input);
                                Item output = wrapper.read(Type.ITEM);
                                InventoryPackets.toClient(output);
                                wrapper.write(Type.FLAT_ITEM, output);
                                boolean secondItem = wrapper.passthrough(Type.BOOLEAN);
                                if (secondItem) {
                                    Item second = wrapper.read(Type.ITEM);
                                    InventoryPackets.toClient(second);
                                    wrapper.write(Type.FLAT_ITEM, second);
                                }
                                wrapper.passthrough(Type.BOOLEAN);
                                wrapper.passthrough(Type.INT);
                                wrapper.passthrough(Type.INT);
                            }
                        } else {
                            String old = channel;
                            if ((channel = InventoryPackets.getNewPluginChannelId(channel)) == null) {
                                if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                                    Via.getPlatform().getLogger().warning("Ignoring outgoing plugin message with channel: " + old);
                                }
                                wrapper.cancel();
                                return;
                            }
                            if (channel.equals("minecraft:register") || channel.equals("minecraft:unregister")) {
                                String[] channels = new String(wrapper.read(Type.REMAINING_BYTES), StandardCharsets.UTF_8).split("\u0000");
                                ArrayList<String> rewrittenChannels = new ArrayList<String>();
                                for (int i = 0; i < channels.length; ++i) {
                                    String rewritten = InventoryPackets.getNewPluginChannelId(channels[i]);
                                    if (rewritten != null) {
                                        rewrittenChannels.add(rewritten);
                                        continue;
                                    }
                                    if (Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug()) continue;
                                    Via.getPlatform().getLogger().warning("Ignoring plugin channel in outgoing REGISTER: " + channels[i]);
                                }
                                wrapper.write(Type.REMAINING_BYTES, Joiner.on((char)'\u0000').join(rewrittenChannels).getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        wrapper.set(Type.STRING, 0, channel);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 63, 66, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.map(Type.ITEM, Type.FLAT_ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item stack = wrapper.get(Type.FLAT_ITEM, 0);
                        InventoryPackets.toClient(stack);
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 7, 8, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.VAR_INT);
                this.map(Type.FLAT_ITEM, Type.ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item item = wrapper.get(Type.ITEM, 0);
                        InventoryPackets.toServer(item);
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 9, 10, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String channel;
                        String old = channel = wrapper.get(Type.STRING, 0);
                        if ((channel = InventoryPackets.getOldPluginChannelId(channel)) == null) {
                            if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                                Via.getPlatform().getLogger().warning("Ignoring incoming plugin message with channel: " + old);
                            }
                            wrapper.cancel();
                            return;
                        }
                        if (channel.equals("REGISTER") || channel.equals("UNREGISTER")) {
                            String[] channels = new String(wrapper.read(Type.REMAINING_BYTES), StandardCharsets.UTF_8).split("\u0000");
                            ArrayList<String> rewrittenChannels = new ArrayList<String>();
                            for (int i = 0; i < channels.length; ++i) {
                                String rewritten = InventoryPackets.getOldPluginChannelId(channels[i]);
                                if (rewritten != null) {
                                    rewrittenChannels.add(rewritten);
                                    continue;
                                }
                                if (Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug()) continue;
                                Via.getPlatform().getLogger().warning("Ignoring plugin channel in incoming REGISTER: " + channels[i]);
                            }
                            wrapper.write(Type.REMAINING_BYTES, Joiner.on((char)'\u0000').join(rewrittenChannels).getBytes(StandardCharsets.UTF_8));
                        }
                        wrapper.set(Type.STRING, 0, channel);
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 27, 36, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.SHORT);
                this.map(Type.FLAT_ITEM, Type.ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item item = wrapper.get(Type.ITEM, 0);
                        InventoryPackets.toServer(item);
                    }
                });
            }
        });
    }

    public static void toClient(Item item) {
        if (item == null) {
            return;
        }
        CompoundTag tag = item.getTag();
        int originalId = item.getId() << 16 | item.getData() & 0xFFFF;
        int rawId = item.getId() << 4 | item.getData() & 0xF;
        if (InventoryPackets.isDamageable(item.getId())) {
            if (tag == null) {
                tag = new CompoundTag("tag");
                item.setTag(tag);
            }
            tag.put((Tag)new IntTag("Damage", (int)item.getData()));
        }
        if (item.getId() == 358) {
            if (tag == null) {
                tag = new CompoundTag("tag");
                item.setTag(tag);
            }
            tag.put((Tag)new IntTag("map", (int)item.getData()));
        }
        if (tag != null) {
            String[] newValues;
            String numberConverted;
            Object value;
            ListTag old;
            String newId;
            short oldId;
            CompoundTag enchantmentEntry;
            CompoundTag display;
            if ((item.getId() == 442 || item.getId() == 425) && tag.get("BlockEntityTag") instanceof CompoundTag) {
                CompoundTag blockEntityTag = (CompoundTag)tag.get("BlockEntityTag");
                if (blockEntityTag.get("Base") instanceof IntTag) {
                    IntTag base = (IntTag)blockEntityTag.get("Base");
                    base.setValue(15 - base.getValue());
                }
                if (blockEntityTag.get("Patterns") instanceof ListTag) {
                    for (Tag pattern : (ListTag)blockEntityTag.get("Patterns")) {
                        if (!(pattern instanceof CompoundTag)) continue;
                        IntTag c = (IntTag)((CompoundTag)pattern).get("Color");
                        c.setValue(15 - c.getValue());
                    }
                }
            }
            if (tag.get("display") instanceof CompoundTag && (display = (CompoundTag)tag.get("display")).get("Name") instanceof StringTag) {
                StringTag name = (StringTag)display.get("Name");
                display.put((Tag)new StringTag(NBT_TAG_NAME + "|Name", name.getValue()));
                name.setValue(ChatRewriter.legacyTextToJson(name.getValue()));
            }
            if (tag.get("ench") instanceof ListTag) {
                ListTag ench = (ListTag)tag.get("ench");
                ListTag enchantments = new ListTag("Enchantments", CompoundTag.class);
                for (Tag enchEntry : ench) {
                    if (!(enchEntry instanceof CompoundTag)) continue;
                    enchantmentEntry = new CompoundTag("");
                    oldId = ((Number)((CompoundTag)enchEntry).get("id").getValue()).shortValue();
                    newId = (String)MappingData.oldEnchantmentsIds.get((Object)oldId);
                    if (newId == null) {
                        newId = "viaversion:legacy/" + oldId;
                    }
                    enchantmentEntry.put((Tag)new StringTag("id", newId));
                    enchantmentEntry.put((Tag)new ShortTag("lvl", ((Number)((CompoundTag)enchEntry).get("lvl").getValue()).shortValue()));
                    enchantments.add((Tag)enchantmentEntry);
                }
                tag.remove("ench");
                tag.put((Tag)enchantments);
            }
            if (tag.get("StoredEnchantments") instanceof ListTag) {
                ListTag storedEnch = (ListTag)tag.get("StoredEnchantments");
                ListTag newStoredEnch = new ListTag("StoredEnchantments", CompoundTag.class);
                for (Tag enchEntry : storedEnch) {
                    if (!(enchEntry instanceof CompoundTag)) continue;
                    enchantmentEntry = new CompoundTag("");
                    oldId = ((Number)((CompoundTag)enchEntry).get("id").getValue()).shortValue();
                    newId = (String)MappingData.oldEnchantmentsIds.get((Object)oldId);
                    if (newId == null) {
                        newId = "viaversion:legacy/" + oldId;
                    }
                    enchantmentEntry.put((Tag)new StringTag("id", newId));
                    enchantmentEntry.put((Tag)new ShortTag("lvl", ((Number)((CompoundTag)enchEntry).get("lvl").getValue()).shortValue()));
                    newStoredEnch.add((Tag)enchantmentEntry);
                }
                tag.remove("StoredEnchantments");
                tag.put((Tag)newStoredEnch);
            }
            if (tag.get("CanPlaceOn") instanceof ListTag) {
                old = (ListTag)tag.get("CanPlaceOn");
                ListTag newCanPlaceOn = new ListTag("CanPlaceOn", StringTag.class);
                tag.put(ConverterRegistry.convertToTag((String)(NBT_TAG_NAME + "|CanPlaceOn"), (Object)ConverterRegistry.convertToValue((Tag)old)));
                for (Tag oldTag : old) {
                    value = oldTag.getValue();
                    String oldId2 = value.toString().replace("minecraft:", "");
                    numberConverted = BlockIdData.numberIdToString.get(Ints.tryParse((String)oldId2));
                    if (numberConverted != null) {
                        oldId2 = numberConverted;
                    }
                    if ((newValues = BlockIdData.blockIdMapping.get(oldId2)) != null) {
                        for (String newValue : newValues) {
                            newCanPlaceOn.add((Tag)new StringTag("", newValue));
                        }
                        continue;
                    }
                    newCanPlaceOn.add((Tag)new StringTag("", oldId2));
                }
                tag.put((Tag)newCanPlaceOn);
            }
            if (tag.get("CanDestroy") instanceof ListTag) {
                old = (ListTag)tag.get("CanDestroy");
                ListTag newCanDestroy = new ListTag("CanDestroy", StringTag.class);
                tag.put(ConverterRegistry.convertToTag((String)(NBT_TAG_NAME + "|CanDestroy"), (Object)ConverterRegistry.convertToValue((Tag)old)));
                for (Tag oldTag : old) {
                    value = oldTag.getValue();
                    String oldId3 = value.toString().replace("minecraft:", "");
                    numberConverted = BlockIdData.numberIdToString.get(Ints.tryParse((String)oldId3));
                    if (numberConverted != null) {
                        oldId3 = numberConverted;
                    }
                    if ((newValues = BlockIdData.blockIdMapping.get(oldId3)) != null) {
                        for (String newValue : newValues) {
                            newCanDestroy.add((Tag)new StringTag("", newValue));
                        }
                        continue;
                    }
                    newCanDestroy.add((Tag)new StringTag("", oldId3));
                }
                tag.put((Tag)newCanDestroy);
            }
            if (item.getId() == 383) {
                if (tag.get("EntityTag") instanceof CompoundTag) {
                    CompoundTag entityTag = (CompoundTag)tag.get("EntityTag");
                    if (entityTag.get("id") instanceof StringTag) {
                        StringTag identifier = (StringTag)entityTag.get("id");
                        rawId = SpawnEggRewriter.getSpawnEggId(identifier.getValue());
                        if (rawId == -1) {
                            rawId = 25100288;
                        } else {
                            entityTag.remove("id");
                            if (entityTag.isEmpty()) {
                                tag.remove("EntityTag");
                            }
                        }
                    } else {
                        rawId = 25100288;
                    }
                } else {
                    rawId = 25100288;
                }
            }
            if (tag.isEmpty()) {
                tag = null;
                item.setTag(null);
            }
        }
        if (!MappingData.oldToNewItems.containsKey((Object)rawId)) {
            if (!InventoryPackets.isDamageable(item.getId()) && item.getId() != 358) {
                if (tag == null) {
                    tag = new CompoundTag("tag");
                    item.setTag(tag);
                }
                tag.put((Tag)new IntTag(NBT_TAG_NAME, originalId));
            }
            if (item.getId() == 31 && item.getData() == 0) {
                rawId = 512;
            } else if (MappingData.oldToNewItems.containsKey((Object)(rawId & 0xFFFFFFF0))) {
                rawId &= 0xFFFFFFF0;
            } else {
                if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                    Via.getPlatform().getLogger().warning("Failed to get 1.13 item for " + item.getId());
                }
                rawId = 16;
            }
        }
        item.setId(((Integer)MappingData.oldToNewItems.get((Object)rawId)).shortValue());
        item.setData((short)0);
    }

    public static String getNewPluginChannelId(String old) {
        switch (old) {
            case "MC|TrList": {
                return "minecraft:trader_list";
            }
            case "MC|Brand": {
                return "minecraft:brand";
            }
            case "MC|BOpen": {
                return "minecraft:book_open";
            }
            case "MC|DebugPath": {
                return "minecraft:debug/paths";
            }
            case "MC|DebugNeighborsUpdate": {
                return "minecraft:debug/neighbors_update";
            }
            case "REGISTER": {
                return "minecraft:register";
            }
            case "UNREGISTER": {
                return "minecraft:unregister";
            }
            case "BungeeCord": {
                return "bungeecord:main";
            }
            case "WDL|INIT": {
                return "wdl:init";
            }
            case "WDL|CONTROL": {
                return "wdl:control";
            }
            case "WDL|REQUEST": {
                return "wdl:request";
            }
            case "bungeecord:main": {
                return null;
            }
        }
        return old.matches("([0-9a-z_.-]*:)?[0-9a-z_/.-]*") ? old : null;
    }

    public static void toServer(Item item) {
        Integer oldId;
        if (item == null) {
            return;
        }
        Integer rawId = null;
        boolean gotRawIdFromTag = false;
        CompoundTag tag = item.getTag();
        if (tag != null && tag.get(NBT_TAG_NAME) instanceof IntTag) {
            rawId = (Integer)tag.get(NBT_TAG_NAME).getValue();
            tag.remove(NBT_TAG_NAME);
            gotRawIdFromTag = true;
        }
        if (rawId == null && (oldId = (Integer)MappingData.oldToNewItems.inverse().get((Object)item.getId())) != null) {
            Optional<String> eggEntityId = SpawnEggRewriter.getEntityId(oldId);
            if (eggEntityId.isPresent()) {
                rawId = 25100288;
                if (tag == null) {
                    tag = new CompoundTag("tag");
                    item.setTag(tag);
                }
                if (!tag.contains("EntityTag")) {
                    CompoundTag entityTag = new CompoundTag("EntityTag");
                    entityTag.put((Tag)new StringTag("id", (String)eggEntityId.get()));
                    tag.put((Tag)entityTag);
                }
            } else {
                rawId = oldId >> 4 << 16 | oldId & 0xF;
            }
        }
        if (rawId == null) {
            if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().warning("Failed to get 1.12 item for " + item.getId());
            }
            rawId = 65536;
        }
        item.setId((short)(rawId >> 16));
        item.setData((short)(rawId & 0xFFFF));
        if (tag != null) {
            String[] newValues;
            Object value;
            ListTag old;
            Short oldId2;
            String newId;
            CompoundTag enchEntry;
            if (InventoryPackets.isDamageable(item.getId()) && tag.get("Damage") instanceof IntTag) {
                if (!gotRawIdFromTag) {
                    item.setData((short)((Integer)tag.get("Damage").getValue()).intValue());
                }
                tag.remove("Damage");
            }
            if (item.getId() == 358 && tag.get("map") instanceof IntTag) {
                if (!gotRawIdFromTag) {
                    item.setData((short)((Integer)tag.get("map").getValue()).intValue());
                }
                tag.remove("map");
            }
            if ((item.getId() == 442 || item.getId() == 425) && tag.get("BlockEntityTag") instanceof CompoundTag) {
                CompoundTag blockEntityTag = (CompoundTag)tag.get("BlockEntityTag");
                if (blockEntityTag.get("Base") instanceof IntTag) {
                    IntTag base = (IntTag)blockEntityTag.get("Base");
                    base.setValue(15 - base.getValue());
                }
                if (blockEntityTag.get("Patterns") instanceof ListTag) {
                    for (Tag pattern : (ListTag)blockEntityTag.get("Patterns")) {
                        if (!(pattern instanceof CompoundTag)) continue;
                        IntTag c = (IntTag)((CompoundTag)pattern).get("Color");
                        c.setValue(15 - c.getValue());
                    }
                }
            }
            if (tag.get("display") instanceof CompoundTag) {
                CompoundTag display = (CompoundTag)tag.get("display");
                if (((CompoundTag)tag.get("display")).get("Name") instanceof StringTag) {
                    StringTag name = (StringTag)display.get("Name");
                    StringTag via = (StringTag)display.get(NBT_TAG_NAME + "|Name");
                    name.setValue(via != null ? via.getValue() : ChatRewriter.jsonTextToLegacy(name.getValue()));
                    display.remove(NBT_TAG_NAME + "|Name");
                }
            }
            if (tag.get("Enchantments") instanceof ListTag) {
                ListTag enchantments = (ListTag)tag.get("Enchantments");
                ListTag ench = new ListTag("ench", CompoundTag.class);
                for (Tag enchantmentEntry : enchantments) {
                    if (!(enchantmentEntry instanceof CompoundTag)) continue;
                    enchEntry = new CompoundTag("");
                    newId = (String)((CompoundTag)enchantmentEntry).get("id").getValue();
                    oldId2 = (Short)MappingData.oldEnchantmentsIds.inverse().get((Object)newId);
                    if (oldId2 == null && newId.startsWith("viaversion:legacy/")) {
                        oldId2 = Short.valueOf(newId.substring(18));
                    }
                    enchEntry.put((Tag)new ShortTag("id", oldId2.shortValue()));
                    enchEntry.put((Tag)new ShortTag("lvl", ((Short)((CompoundTag)enchantmentEntry).get("lvl").getValue()).shortValue()));
                    ench.add((Tag)enchEntry);
                }
                tag.remove("Enchantments");
                tag.put((Tag)ench);
            }
            if (tag.get("StoredEnchantments") instanceof ListTag) {
                ListTag storedEnch = (ListTag)tag.get("StoredEnchantments");
                ListTag newStoredEnch = new ListTag("StoredEnchantments", CompoundTag.class);
                for (Tag enchantmentEntry : storedEnch) {
                    if (!(enchantmentEntry instanceof CompoundTag)) continue;
                    enchEntry = new CompoundTag("");
                    newId = (String)((CompoundTag)enchantmentEntry).get("id").getValue();
                    oldId2 = (Short)MappingData.oldEnchantmentsIds.inverse().get((Object)newId);
                    if (oldId2 == null && newId.startsWith("viaversion:legacy/")) {
                        oldId2 = Short.valueOf(newId.substring(18));
                    }
                    enchEntry.put((Tag)new ShortTag("id", oldId2.shortValue()));
                    enchEntry.put((Tag)new ShortTag("lvl", ((Short)((CompoundTag)enchantmentEntry).get("lvl").getValue()).shortValue()));
                    newStoredEnch.add((Tag)enchEntry);
                }
                tag.remove("StoredEnchantments");
                tag.put((Tag)newStoredEnch);
            }
            if (tag.get(NBT_TAG_NAME + "|CanPlaceOn") instanceof ListTag) {
                tag.put(ConverterRegistry.convertToTag((String)"CanPlaceOn", (Object)ConverterRegistry.convertToValue((Tag)tag.get(NBT_TAG_NAME + "|CanPlaceOn"))));
                tag.remove(NBT_TAG_NAME + "|CanPlaceOn");
            } else if (tag.get("CanPlaceOn") instanceof ListTag) {
                old = (ListTag)tag.get("CanPlaceOn");
                ListTag newCanPlaceOn = new ListTag("CanPlaceOn", StringTag.class);
                for (Tag oldTag : old) {
                    value = oldTag.getValue();
                    newValues = BlockIdData.fallbackReverseMapping.get(value instanceof String ? ((String)value).replace("minecraft:", "") : null);
                    if (newValues != null) {
                        for (String newValue : newValues) {
                            newCanPlaceOn.add((Tag)new StringTag("", newValue));
                        }
                        continue;
                    }
                    newCanPlaceOn.add(oldTag);
                }
                tag.put((Tag)newCanPlaceOn);
            }
            if (tag.get(NBT_TAG_NAME + "|CanDestroy") instanceof ListTag) {
                tag.put(ConverterRegistry.convertToTag((String)"CanDestroy", (Object)ConverterRegistry.convertToValue((Tag)tag.get(NBT_TAG_NAME + "|CanDestroy"))));
                tag.remove(NBT_TAG_NAME + "|CanDestroy");
            } else if (tag.get("CanDestroy") instanceof ListTag) {
                old = (ListTag)tag.get("CanDestroy");
                ListTag newCanDestroy = new ListTag("CanDestroy", StringTag.class);
                for (Tag oldTag : old) {
                    value = oldTag.getValue();
                    newValues = BlockIdData.fallbackReverseMapping.get(value instanceof String ? ((String)value).replace("minecraft:", "") : null);
                    if (newValues != null) {
                        for (String newValue : newValues) {
                            newCanDestroy.add((Tag)new StringTag("", newValue));
                        }
                        continue;
                    }
                    newCanDestroy.add(oldTag);
                }
                tag.put((Tag)newCanDestroy);
            }
        }
    }

    public static String getOldPluginChannelId(String newId) {
        if (!newId.matches("([0-9a-z_.-]*:)?[0-9a-z_/.-]*")) {
            return null;
        }
        int separatorIndex = newId.indexOf(58);
        if (separatorIndex == -1 || separatorIndex == 0) {
            newId = "minecraft:" + newId;
        }
        switch (newId) {
            case "minecraft:trader_list": {
                return "MC|TrList";
            }
            case "minecraft:book_open": {
                return "MC|BOpen";
            }
            case "minecraft:debug/paths": {
                return "MC|DebugPath";
            }
            case "minecraft:debug/neighbors_update": {
                return "MC|DebugNeighborsUpdate";
            }
            case "minecraft:register": {
                return "REGISTER";
            }
            case "minecraft:unregister": {
                return "UNREGISTER";
            }
            case "minecraft:brand": {
                return "MC|Brand";
            }
            case "bungeecord:main": {
                return "BungeeCord";
            }
            case "wdl:init": {
                return "WDL|INIT";
            }
            case "wdl:control": {
                return "WDL|CONTROL";
            }
            case "wdl:request": {
                return "WDL|REQUEST";
            }
        }
        return newId;
    }

    public static boolean isDamageable(int id) {
        return id >= 256 && id <= 259 || id == 261 || id >= 267 && id <= 279 || id >= 283 && id <= 286 || id >= 290 && id <= 294 || id >= 298 && id <= 317 || id == 346 || id == 359 || id == 398 || id == 442 || id == 443;
    }
}

