/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.BlockChangeRecord;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.Protocol1_13To1_12_2;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.NamedSoundRewriter;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.Particle;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.ParticleRewriter;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.BlockEntityProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.PaintingProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.BlockStorage;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.types.Chunk1_13Type;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.types.Chunk1_9_3_4Type;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;

public class WorldPackets {
    private static final Set<Integer> validBiomes;

    public static void register(Protocol protocol) {
        protocol.registerOutgoing(State.PLAY, 4, 4, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.UUID);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String motive;
                        PaintingProvider provider = Via.getManager().getProviders().get(PaintingProvider.class);
                        Optional<Integer> id = provider.getIntByIdentifier(motive = wrapper.read(Type.STRING));
                        if (!(id.isPresent() || Via.getConfig().isSuppress1_13ConversionErrors() && !Via.getManager().isDebug())) {
                            Via.getPlatform().getLogger().warning("Could not find painting motive: " + motive + " falling back to default (0)");
                        }
                        wrapper.write(Type.VAR_INT, id.or((Object)0));
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 9, 9, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.NBT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        BlockStorage storage;
                        Position position = wrapper.get(Type.POSITION, 0);
                        short action = wrapper.get(Type.UNSIGNED_BYTE, 0);
                        CompoundTag tag = wrapper.get(Type.NBT, 0);
                        BlockEntityProvider provider = Via.getManager().getProviders().get(BlockEntityProvider.class);
                        int newId = provider.transform(wrapper.user(), position, tag, true);
                        if (newId != -1 && (storage = wrapper.user().get(BlockStorage.class)).contains(position)) {
                            storage.get(position).setReplacement(newId);
                        }
                        if (action == 5) {
                            wrapper.cancel();
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 10, 10, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Position pos = wrapper.get(Type.POSITION, 0);
                        short action = wrapper.get(Type.UNSIGNED_BYTE, 0);
                        short param = wrapper.get(Type.UNSIGNED_BYTE, 1);
                        int blockId = wrapper.get(Type.VAR_INT, 0);
                        if (blockId == 25) {
                            blockId = 73;
                        } else if (blockId == 33) {
                            blockId = 99;
                        } else if (blockId == 29) {
                            blockId = 92;
                        } else if (blockId == 54) {
                            blockId = 142;
                        } else if (blockId == 146) {
                            blockId = 305;
                        } else if (blockId == 130) {
                            blockId = 249;
                        } else if (blockId == 138) {
                            blockId = 257;
                        } else if (blockId == 52) {
                            blockId = 140;
                        } else if (blockId == 209) {
                            blockId = 472;
                        } else if (blockId >= 219 && blockId <= 234) {
                            blockId = blockId - 219 + 483;
                        }
                        if (blockId == 73) {
                            PacketWrapper blockChange = wrapper.create(11);
                            blockChange.write(Type.POSITION, new Position(pos.getX(), pos.getY(), pos.getZ()));
                            blockChange.write(Type.VAR_INT, 249 + action * 24 * 2 + param * 2);
                            blockChange.send(Protocol1_13To1_12_2.class, true, true);
                        }
                        wrapper.set(Type.VAR_INT, 0, blockId);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 11, 11, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Position position = wrapper.get(Type.POSITION, 0);
                        int newId = WorldPackets.toNewId(wrapper.get(Type.VAR_INT, 0));
                        UserConnection userConnection = wrapper.user();
                        if (Via.getConfig().isServersideBlockConnections()) {
                            ConnectionData.updateBlockStorage(userConnection, position, newId);
                            if (ConnectionData.connects(newId)) {
                                newId = ConnectionData.connect(userConnection, position, newId);
                            }
                        }
                        wrapper.set(Type.VAR_INT, 0, WorldPackets.checkStorage(wrapper.user(), position, newId));
                        if (Via.getConfig().isServersideBlockConnections()) {
                            wrapper.send(Protocol1_13To1_12_2.class, true, true);
                            wrapper.cancel();
                            ConnectionData.update(userConnection, position);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 16, 15, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Position position;
                        BlockChangeRecord[] records;
                        int chunkX = wrapper.get(Type.INT, 0);
                        int chunkZ = wrapper.get(Type.INT, 1);
                        UserConnection userConnection = wrapper.user();
                        for (BlockChangeRecord record : records = wrapper.get(Type.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                            int newBlock = WorldPackets.toNewId(record.getBlockId());
                            position = new Position((long)(record.getHorizontal() >> 4 & 0xF) + (long)(chunkX * 16), Long.valueOf(record.getY()), (long)(record.getHorizontal() & 0xF) + (long)(chunkZ * 16));
                            if (Via.getConfig().isServersideBlockConnections()) {
                                ConnectionData.updateBlockStorage(userConnection, position, newBlock);
                            }
                            record.setBlockId(WorldPackets.checkStorage(wrapper.user(), position, newBlock));
                        }
                        if (Via.getConfig().isServersideBlockConnections()) {
                            for (BlockChangeRecord record : records) {
                                int blockState = record.getBlockId();
                                position = new Position((long)(record.getHorizontal() >> 4 & 0xF) + (long)(chunkX * 16), Long.valueOf(record.getY()), (long)(record.getHorizontal() & 0xF) + (long)(chunkZ * 16));
                                if (!ConnectionData.connects(blockState)) continue;
                                blockState = ConnectionData.connect(userConnection, position, blockState);
                                record.setBlockId(blockState);
                            }
                            wrapper.send(Protocol1_13To1_12_2.class, true, true);
                            wrapper.cancel();
                            for (BlockChangeRecord record : records) {
                                Position position2 = new Position((long)(record.getHorizontal() >> 4 & 0xF) + (long)(chunkX * 16), Long.valueOf(record.getY()), (long)(record.getHorizontal() & 0xF) + (long)(chunkZ * 16));
                                ConnectionData.update(userConnection, position2);
                            }
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 29, 31, new PacketRemapper(){

            @Override
            public void registerMap() {
                if (Via.getConfig().isServersideBlockConnections()) {
                    this.handler(new PacketHandler(){

                        @Override
                        public void handle(PacketWrapper wrapper) throws Exception {
                            int x = wrapper.passthrough(Type.INT);
                            int z = wrapper.passthrough(Type.INT);
                            ConnectionData.getProvider().unloadChunk(wrapper.user(), x, z);
                        }
                    });
                }
            }
        });
        protocol.registerOutgoing(State.PLAY, 25, 26, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String newSoundId = NamedSoundRewriter.getNewId(wrapper.get(Type.STRING, 0));
                        wrapper.set(Type.STRING, 0, newSoundId);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 32, 34, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                        BlockStorage storage = wrapper.user().get(BlockStorage.class);
                        Chunk1_9_3_4Type type = new Chunk1_9_3_4Type(clientWorld);
                        Chunk1_13Type type1_13 = new Chunk1_13Type(clientWorld);
                        Chunk chunk = wrapper.read(type);
                        wrapper.write(type1_13, chunk);
                        for (int i = 0; i < chunk.getSections().length; ++i) {
                            int block;
                            int x;
                            int z;
                            int y;
                            int newId;
                            ChunkSection section = chunk.getSections()[i];
                            if (section == null) continue;
                            for (int p = 0; p < section.getPaletteSize(); ++p) {
                                int old = section.getPaletteEntry(p);
                                newId = WorldPackets.toNewId(old);
                                section.setPaletteEntry(p, newId);
                            }
                            boolean willSaveToStorage = false;
                            for (int p = 0; p < section.getPaletteSize(); ++p) {
                                newId = section.getPaletteEntry(p);
                                if (!storage.isWelcome(newId)) continue;
                                willSaveToStorage = true;
                                break;
                            }
                            boolean willSaveConnection = false;
                            if (Via.getConfig().isServersideBlockConnections() && ConnectionData.needStoreBlocks()) {
                                for (int p = 0; p < section.getPaletteSize(); ++p) {
                                    int newId2 = section.getPaletteEntry(p);
                                    if (!ConnectionData.isWelcome(newId2)) continue;
                                    willSaveConnection = true;
                                    break;
                                }
                            }
                            if (willSaveToStorage) {
                                for (y = 0; y < 16; ++y) {
                                    for (z = 0; z < 16; ++z) {
                                        for (x = 0; x < 16; ++x) {
                                            block = section.getFlatBlock(x, y, z);
                                            if (!storage.isWelcome(block)) continue;
                                            storage.store(new Position(Long.valueOf(x + (chunk.getX() << 4)), Long.valueOf(y + (i << 4)), Long.valueOf(z + (chunk.getZ() << 4))), block);
                                        }
                                    }
                                }
                            }
                            if (!willSaveConnection) continue;
                            for (y = 0; y < 16; ++y) {
                                for (z = 0; z < 16; ++z) {
                                    for (x = 0; x < 16; ++x) {
                                        block = section.getFlatBlock(x, y, z);
                                        if (!ConnectionData.isWelcome(block)) continue;
                                        ConnectionData.getProvider().storeBlock(wrapper.user(), x + (chunk.getX() << 4), y + (i << 4), z + (chunk.getZ() << 4), block);
                                    }
                                }
                            }
                        }
                        if (Via.getConfig().isServersideBlockConnections()) {
                            ConnectionData.connectBlocks(wrapper.user(), chunk);
                        }
                        if (chunk.isBiomeData()) {
                            int latestBiomeWarn = Integer.MIN_VALUE;
                            for (int i = 0; i < 256; ++i) {
                                int biome = chunk.getBiomeData()[i];
                                if (validBiomes.contains(biome)) continue;
                                if (biome != 255 && latestBiomeWarn != biome) {
                                    if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                                        Via.getPlatform().getLogger().warning("Received invalid biome id " + biome);
                                    }
                                    latestBiomeWarn = biome;
                                }
                                chunk.getBiomeData()[i] = 1;
                            }
                        }
                        BlockEntityProvider provider = Via.getManager().getProviders().get(BlockEntityProvider.class);
                        for (CompoundTag tag : chunk.getBlockEntities()) {
                            int newId = provider.transform(wrapper.user(), null, tag, false);
                            if (newId == -1) continue;
                            int x = (Integer)tag.get("x").getValue();
                            int y = (Integer)tag.get("y").getValue();
                            int z = (Integer)tag.get("z").getValue();
                            Position position = new Position(Long.valueOf(x), Long.valueOf(y), Long.valueOf(z));
                            if (storage.contains(position)) {
                                storage.get(position).setReplacement(newId);
                            }
                            chunk.getSections()[y >> 4].setFlatBlock(x & 0xF, y & 0xF, z & 0xF, newId);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 34, 36, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.BOOLEAN);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int particleId = wrapper.get(Type.INT, 0);
                        int dataCount = 0;
                        if (particleId == 37 || particleId == 38 || particleId == 46) {
                            dataCount = 1;
                        } else if (particleId == 36) {
                            dataCount = 2;
                        }
                        Integer[] data = new Integer[dataCount];
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = wrapper.read(Type.VAR_INT);
                        }
                        Particle particle = ParticleRewriter.rewriteParticle(particleId, data);
                        if (particle == null || particle.getId() == -1) {
                            wrapper.cancel();
                            return;
                        }
                        if (particle.getId() == 11) {
                            int count = wrapper.get(Type.INT, 1);
                            float speed = wrapper.get(Type.FLOAT, 6).floatValue();
                            if (count == 0) {
                                wrapper.set(Type.INT, 1, 1);
                                wrapper.set(Type.FLOAT, 6, Float.valueOf(0.0f));
                                List<Particle.ParticleData> arguments = particle.getArguments();
                                for (int i = 0; i < 3; ++i) {
                                    float colorValue = wrapper.get(Type.FLOAT, i + 3).floatValue() * speed;
                                    if (colorValue == 0.0f && i == 0) {
                                        colorValue = 1.0f;
                                    }
                                    arguments.get(i).setValue(Float.valueOf(colorValue));
                                    wrapper.set(Type.FLOAT, i + 3, Float.valueOf(0.0f));
                                }
                            }
                        }
                        wrapper.set(Type.INT, 0, particle.getId());
                        for (Particle.ParticleData particleData : particle.getArguments()) {
                            wrapper.write(particleData.getType(), particleData.getValue());
                        }
                    }
                });
            }
        });
    }

    public static int toNewId(int oldId) {
        int newId;
        if (oldId < 0) {
            oldId = 0;
        }
        if ((newId = MappingData.blockMappings.getNewBlock(oldId)) != -1) {
            return newId;
        }
        newId = MappingData.blockMappings.getNewBlock(oldId & 0xFFFFFFF0);
        if (newId != -1) {
            if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().warning("Missing block " + oldId);
            }
            return newId;
        }
        if (!Via.getConfig().isSuppress1_13ConversionErrors() || Via.getManager().isDebug()) {
            Via.getPlatform().getLogger().warning("Missing block completely " + oldId);
        }
        return 1;
    }

    private static int checkStorage(UserConnection user, Position position, int newId) {
        BlockStorage storage = user.get(BlockStorage.class);
        if (storage.contains(position)) {
            BlockStorage.ReplacementData data = storage.get(position);
            if (data.getOriginal() == newId) {
                if (data.getReplacement() != -1) {
                    return data.getReplacement();
                }
            } else {
                storage.remove(position);
                if (storage.isWelcome(newId)) {
                    storage.store(position, newId);
                }
            }
        } else if (storage.isWelcome(newId)) {
            storage.store(position, newId);
        }
        return newId;
    }

    static {
        int i;
        validBiomes = new HashSet<Integer>();
        for (i = 0; i < 50; ++i) {
            validBiomes.add(i);
        }
        validBiomes.add(127);
        for (i = 129; i <= 134; ++i) {
            validBiomes.add(i);
        }
        validBiomes.add(140);
        validBiomes.add(149);
        validBiomes.add(151);
        for (i = 155; i <= 158; ++i) {
            validBiomes.add(i);
        }
        for (i = 160; i <= 167; ++i) {
            validBiomes.add(i);
        }
    }
}

