/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.blockentities;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.ChatRewriter;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.providers.BlockEntityProvider;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage.BlockStorage;

public class BannerHandler
implements BlockEntityProvider.BlockEntityHandler {
    private final int WALL_BANNER_START = 7110;
    private final int WALL_BANNER_STOP = 7173;
    private final int BANNER_START = 6854;
    private final int BANNER_STOP = 7109;

    @Override
    public int transform(UserConnection user, CompoundTag tag) {
        Tag name;
        Position position;
        BlockStorage storage = user.get(BlockStorage.class);
        if (!storage.contains(position = new Position(this.getLong(tag.get("x")), this.getLong(tag.get("y")), this.getLong(tag.get("z"))))) {
            Via.getPlatform().getLogger().warning("Received an banner color update packet, but there is no banner! O_o " + tag);
            return -1;
        }
        int blockId = storage.get(position).getOriginal();
        Tag base = tag.get("Base");
        int color = 0;
        if (base != null) {
            color = ((Number)tag.get("Base").getValue()).intValue();
        }
        if (blockId >= 6854 && blockId <= 7109) {
            blockId += (15 - color) * 16;
        } else if (blockId >= 7110 && blockId <= 7173) {
            blockId += (15 - color) * 4;
        } else {
            Via.getPlatform().getLogger().warning("Why does this block have the banner block entity? :(" + tag);
        }
        if (tag.get("Patterns") instanceof ListTag) {
            for (Tag pattern : (ListTag)tag.get("Patterns")) {
                Tag c;
                if (!(pattern instanceof CompoundTag) || !((c = ((CompoundTag)pattern).get("Color")) instanceof IntTag)) continue;
                ((IntTag)c).setValue(15 - (Integer)c.getValue());
            }
        }
        if ((name = tag.get("CustomName")) instanceof StringTag) {
            ((StringTag)name).setValue(ChatRewriter.legacyTextToJson(((StringTag)name).getValue()));
        }
        return blockId;
    }

    private long getLong(Tag tag) {
        return ((Integer)tag.getValue()).longValue();
    }
}

