/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.chunks.NibbleArray;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.data.MappingData;
import us.myles.ViaVersion.protocols.protocol1_13to1_12_2.packets.WorldPackets;

public class BlockConnectionStorage
extends StoredObject {
    private Map<Long, Pair<byte[], NibbleArray>> blockStorage = this.createLongObjectMap();
    private static Constructor<?> fastUtilLongObjectHashMap;
    private static HashMap<Short, Short> reverseBlockMappings;

    public BlockConnectionStorage(UserConnection user) {
        super(user);
    }

    public void store(Position position, int blockState) {
        Short mapping = reverseBlockMappings.get((short)blockState);
        if (mapping == null) {
            return;
        }
        blockState = mapping.shortValue();
        long pair = this.getChunkSectionIndex(position);
        Pair<byte[], NibbleArray> map = this.getChunkSection(pair, (blockState & 0xF) != 0);
        short blockIndex = this.encodeBlockPos(position);
        map.getKey()[blockIndex] = (byte)(blockState >> 4);
        NibbleArray nibbleArray = map.getValue();
        if (nibbleArray != null) {
            nibbleArray.set(blockIndex, blockState);
        }
    }

    public int get(Position position) {
        long pair = this.getChunkSectionIndex(position);
        Pair<byte[], NibbleArray> map = this.blockStorage.get(pair);
        if (map == null) {
            return 0;
        }
        short blockPosition = this.encodeBlockPos(position);
        NibbleArray nibbleArray = map.getValue();
        return WorldPackets.toNewId((map.getKey()[blockPosition] & 0xFF) << 4 | (nibbleArray == null ? 0 : (int)nibbleArray.get(blockPosition)));
    }

    public void remove(Position position) {
        long pair = this.getChunkSectionIndex(position);
        Pair<byte[], NibbleArray> map = this.blockStorage.get(pair);
        if (map == null) {
            return;
        }
        short blockIndex = this.encodeBlockPos(position);
        NibbleArray nibbleArray = map.getValue();
        if (nibbleArray != null) {
            nibbleArray.set(blockIndex, 0);
            boolean allZero = true;
            for (int i = 0; i < 4096; ++i) {
                if (nibbleArray.get(i) == 0) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                map.setValue(null);
            }
        }
        map.getKey()[blockIndex] = 0;
        byte[] byArray = map.getKey();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            short entry = byArray[i];
            if (entry == 0) continue;
            return;
        }
        this.blockStorage.remove(pair);
    }

    public void clear() {
        this.blockStorage.clear();
    }

    public void unloadChunk(int x, int z) {
        for (int y = 0; y < 256; y += 16) {
            this.blockStorage.remove(this.getChunkSectionIndex(x << 4, y, z << 4));
        }
    }

    private Pair<byte[], NibbleArray> getChunkSection(long index, boolean requireNibbleArray) {
        Pair<byte[], NibbleArray> map = this.blockStorage.get(index);
        if (map == null) {
            map = new Pair<byte[], Object>(new byte[4096], null);
            this.blockStorage.put(index, map);
        }
        if (map.getValue() == null && requireNibbleArray) {
            map.setValue(new NibbleArray(4096));
        }
        return map;
    }

    private long getChunkSectionIndex(int x, int y, int z) {
        return ((long)(x >> 4) & 0x3FFFFFFL) << 38 | ((long)(y >> 4) & 0xFFFL) << 26 | (long)(z >> 4) & 0x3FFFFFFL;
    }

    private long getChunkSectionIndex(Position position) {
        return this.getChunkSectionIndex(position.getX().intValue(), position.getY().intValue(), position.getZ().intValue());
    }

    private short encodeBlockPos(int x, int y, int z) {
        return (short)((y & 0xF) << 8 | (x & 0xF) << 4 | z & 0xF);
    }

    private short encodeBlockPos(Position pos) {
        return this.encodeBlockPos(pos.getX().intValue(), pos.getY().intValue(), pos.getZ().intValue());
    }

    private <T> Map<Long, T> createLongObjectMap() {
        if (fastUtilLongObjectHashMap != null) {
            try {
                return (Map)fastUtilLongObjectHashMap.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new HashMap();
    }

    static {
        try {
            fastUtilLongObjectHashMap = Class.forName("it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap").getConstructor(new Class[0]);
            Via.getPlatform().getLogger().info("Using FastUtil Long2ObjectOpenHashMap for block connections");
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        reverseBlockMappings = new HashMap();
        for (int i = 0; i < 4096; ++i) {
            int newBlock = MappingData.blockMappings.getNewBlock(i);
            if (newBlock == -1) continue;
            reverseBlockMappings.put((short)newBlock, (short)i);
        }
    }
}

