/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_13to1_12_2.storage;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;

public class BlockStorage
extends StoredObject {
    private static final Set<Integer> whitelist;
    private Map<Position, ReplacementData> blocks = new ConcurrentHashMap<Position, ReplacementData>();

    public BlockStorage(UserConnection user) {
        super(user);
    }

    public void store(Position position, int block) {
        this.store(position, block, -1);
    }

    public void store(Position position, int block, int replacementId) {
        if (!whitelist.contains(block)) {
            return;
        }
        this.blocks.put(position, new ReplacementData(block, replacementId));
    }

    public boolean isWelcome(int block) {
        return whitelist.contains(block);
    }

    public boolean contains(Position position) {
        return this.blocks.containsKey(position);
    }

    public ReplacementData get(Position position) {
        return this.blocks.get(position);
    }

    public ReplacementData remove(Position position) {
        return this.blocks.remove(position);
    }

    static {
        int i;
        whitelist = Sets.newConcurrentHashSet();
        whitelist.add(5266);
        for (i = 0; i < 16; ++i) {
            whitelist.add(972 + i);
        }
        for (i = 0; i < 20; ++i) {
            whitelist.add(6854 + i);
        }
        for (i = 0; i < 4; ++i) {
            whitelist.add(7110 + i);
        }
        for (i = 0; i < 5; ++i) {
            whitelist.add(5447 + i);
        }
    }

    public class ReplacementData {
        private int original;
        private int replacement;

        public int getOriginal() {
            return this.original;
        }

        public int getReplacement() {
            return this.replacement;
        }

        public void setOriginal(int original) {
            this.original = original;
        }

        public void setReplacement(int replacement) {
            this.replacement = replacement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplacementData)) {
                return false;
            }
            ReplacementData other = (ReplacementData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOriginal() != other.getOriginal()) {
                return false;
            }
            return this.getReplacement() == other.getReplacement();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplacementData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOriginal();
            result = result * 59 + this.getReplacement();
            return result;
        }

        public String toString() {
            return "BlockStorage.ReplacementData(original=" + this.getOriginal() + ", replacement=" + this.getReplacement() + ")";
        }

        public ReplacementData(int original, int replacement) {
            this.original = original;
            this.replacement = replacement;
        }
    }
}

