/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.packets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.Triple;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.entities.Entity1_10Types;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.minecraft.metadata.Metadata;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.remapper.ValueTransformer;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.version.Types1_8;
import us.myles.ViaVersion.api.type.types.version.Types1_9;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.ItemRewriter;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.metadata.MetadataRewriter;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.packets.SpawnPackets;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.EntityTracker;

public class EntityPackets {
    public static final ValueTransformer<Byte, Short> toNewShort = new ValueTransformer<Byte, Short>(Type.SHORT){

        @Override
        public Short transform(PacketWrapper wrapper, Byte inputValue) {
            return (short)(inputValue * 128);
        }
    };

    public static void register(Protocol protocol) {
        protocol.registerOutgoing(State.PLAY, 27, 58, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BOOLEAN, new ValueTransformer<Boolean, Void>(Type.NOTHING){

                    @Override
                    public Void transform(PacketWrapper wrapper, Boolean inputValue) throws Exception {
                        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                        if (!inputValue.booleanValue()) {
                            int passenger = wrapper.get(Type.INT, 0);
                            int vehicle = wrapper.get(Type.INT, 1);
                            wrapper.cancel();
                            PacketWrapper passengerPacket = wrapper.create(64);
                            if (vehicle == -1) {
                                if (!tracker.getVehicleMap().containsKey(passenger)) {
                                    return null;
                                }
                                passengerPacket.write(Type.VAR_INT, tracker.getVehicleMap().remove(passenger));
                                passengerPacket.write(Type.VAR_INT_ARRAY, new Integer[0]);
                            } else {
                                passengerPacket.write(Type.VAR_INT, vehicle);
                                passengerPacket.write(Type.VAR_INT_ARRAY, new Integer[]{passenger});
                                tracker.getVehicleMap().put(passenger, vehicle);
                            }
                            passengerPacket.send(Protocol1_9To1_8.class);
                        }
                        return null;
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 24, 74, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.INT, SpawnPackets.toNewDouble);
                this.map(Type.INT, SpawnPackets.toNewDouble);
                this.map(Type.INT, SpawnPackets.toNewDouble);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BOOLEAN);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        EntityTracker tracker;
                        int entityID = wrapper.get(Type.VAR_INT, 0);
                        if (Via.getConfig().isHologramPatch() && (tracker = wrapper.user().get(EntityTracker.class)).getKnownHolograms().contains(entityID)) {
                            Double newValue = wrapper.get(Type.DOUBLE, 1);
                            newValue = newValue + Via.getConfig().getHologramYOffset();
                            wrapper.set(Type.DOUBLE, 1, newValue);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 23, 38, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BOOLEAN);
            }
        });
        protocol.registerOutgoing(State.PLAY, 21, 37, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BYTE, toNewShort);
                this.map(Type.BOOLEAN);
            }
        });
        protocol.registerOutgoing(State.PLAY, 4, 60, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.SHORT, new ValueTransformer<Short, Integer>(Type.VAR_INT){

                    @Override
                    public Integer transform(PacketWrapper wrapper, Short slot) {
                        return slot > 0 ? slot.intValue() + 1 : slot.intValue();
                    }
                });
                this.map(Type.ITEM);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Item stack = wrapper.get(Type.ITEM, 0);
                        ItemRewriter.toClient(stack);
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        int entityID = wrapper.get(Type.VAR_INT, 0);
                        Item stack = wrapper.get(Type.ITEM, 0);
                        if (stack != null && Protocol1_9To1_8.isSword(stack.getId())) {
                            entityTracker.getValidBlocking().add(entityID);
                            return;
                        }
                        entityTracker.getValidBlocking().remove(entityID);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 28, 57, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Types1_8.METADATA_LIST, Types1_9.METADATA_LIST);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        List<Metadata> metadataList = wrapper.get(Types1_9.METADATA_LIST, 0);
                        int entityID = wrapper.get(Type.VAR_INT, 0);
                        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                        Entity1_10Types.EntityType type = tracker.getClientEntityTypes().get(entityID);
                        if (type != null) {
                            MetadataRewriter.transform(type, metadataList);
                        } else {
                            tracker.addMetadataToBuffer(entityID, metadataList);
                            wrapper.cancel();
                        }
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        List<Metadata> metadataList = wrapper.get(Types1_9.METADATA_LIST, 0);
                        int entityID = wrapper.get(Type.VAR_INT, 0);
                        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                        tracker.handleMetadata(entityID, metadataList);
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        List<Metadata> metadataList = wrapper.get(Types1_9.METADATA_LIST, 0);
                        if (metadataList.size() == 0) {
                            wrapper.cancel();
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 29, 76, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        boolean showParticles = wrapper.read(Type.BOOLEAN);
                        boolean newEffect = Via.getConfig().isNewEffectIndicator();
                        wrapper.write(Type.BYTE, (byte)(showParticles ? (newEffect ? 2 : 1) : 0));
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 73, 73, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 66, 44, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (wrapper.get(Type.VAR_INT, 0) == 2) {
                            wrapper.passthrough(Type.VAR_INT);
                            wrapper.passthrough(Type.INT);
                            Protocol1_9To1_8.FIX_JSON.write(wrapper, wrapper.read(Type.STRING));
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 32, 75, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (!Via.getConfig().isMinimizeCooldown()) {
                            return;
                        }
                        if (wrapper.get(Type.VAR_INT, 0).intValue() != wrapper.user().get(EntityTracker.class).getProvidedEntityId()) {
                            return;
                        }
                        int propertiesToRead = wrapper.read(Type.INT);
                        HashMap properties = new HashMap(propertiesToRead);
                        for (int i = 0; i < propertiesToRead; ++i) {
                            String key = wrapper.read(Type.STRING);
                            Double value = wrapper.read(Type.DOUBLE);
                            int modifiersToRead = wrapper.read(Type.VAR_INT);
                            ArrayList<Triple<UUID, Double, Byte>> modifiers = new ArrayList<Triple<UUID, Double, Byte>>(modifiersToRead);
                            for (int j = 0; j < modifiersToRead; ++j) {
                                modifiers.add(new Triple<UUID, Double, Byte>(wrapper.read(Type.UUID), wrapper.read(Type.DOUBLE), wrapper.read(Type.BYTE)));
                            }
                            properties.put(key, new Pair(value, modifiers));
                        }
                        properties.put("generic.attackSpeed", new Pair<Double, ImmutableList>(15.9, ImmutableList.of(new Triple<UUID, Double, Byte>(UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3"), 0.0, (byte)0), new Triple<UUID, Double, Byte>(UUID.fromString("AF8B6E3F-3328-4C0A-AA36-5BA2BB9DBEF3"), 0.0, (byte)2), new Triple<UUID, Double, Byte>(UUID.fromString("55FCED67-E92A-486E-9800-B47F202C4386"), 0.0, (byte)2))));
                        wrapper.write(Type.INT, properties.size());
                        for (Map.Entry entry : properties.entrySet()) {
                            wrapper.write(Type.STRING, entry.getKey());
                            wrapper.write(Type.DOUBLE, ((Pair)entry.getValue()).getKey());
                            wrapper.write(Type.VAR_INT, ((List)((Pair)entry.getValue()).getValue()).size());
                            for (Triple modifier : (List)((Pair)entry.getValue()).getValue()) {
                                wrapper.write(Type.UUID, modifier.getFirst());
                                wrapper.write(Type.DOUBLE, modifier.getSecond());
                                wrapper.write(Type.BYTE, modifier.getThird());
                            }
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 26, 27);
        protocol.registerOutgoing(State.PLAY, 22, 39);
        protocol.registerOutgoing(State.PLAY, 20, 40);
        protocol.registerOutgoing(State.PLAY, 10, 47);
        protocol.registerOutgoing(State.PLAY, 30, 49);
        protocol.registerOutgoing(State.PLAY, 25, 52);
        protocol.registerOutgoing(State.PLAY, 18, 59);
        protocol.registerIncoming(State.PLAY, 11, 20, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int action = wrapper.get(Type.VAR_INT, 1);
                        if (action == 6 || action == 8) {
                            wrapper.cancel();
                        }
                        if (action == 7) {
                            wrapper.set(Type.VAR_INT, 1, 6);
                        }
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 2, 10, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int hand;
                        int type = wrapper.get(Type.VAR_INT, 1);
                        if (type == 2) {
                            wrapper.passthrough(Type.FLOAT);
                            wrapper.passthrough(Type.FLOAT);
                            wrapper.passthrough(Type.FLOAT);
                        }
                        if ((type == 0 || type == 2) && (hand = wrapper.read(Type.VAR_INT).intValue()) == 1) {
                            wrapper.cancel();
                        }
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 12, 21);
        protocol.registerIncoming(State.PLAY, 24, 27);
    }
}

