/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.storage;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.base.Optional;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;

public class CommandBlockStorage
extends StoredObject {
    private Map<Pair<Integer, Integer>, Map<Position, CompoundTag>> storedCommandBlocks = new ConcurrentHashMap<Pair<Integer, Integer>, Map<Position, CompoundTag>>();
    private boolean permissions = false;

    public CommandBlockStorage(UserConnection user) {
        super(user);
    }

    public void unloadChunk(int x, int z) {
        Pair<Integer, Integer> chunkPos = new Pair<Integer, Integer>(x, z);
        this.storedCommandBlocks.remove(chunkPos);
    }

    public void addOrUpdateBlock(Position position, CompoundTag tag) {
        Map<Position, CompoundTag> blocks;
        Pair<Integer, Integer> chunkPos = this.getChunkCoords(position);
        if (!this.storedCommandBlocks.containsKey(chunkPos)) {
            this.storedCommandBlocks.put(chunkPos, new ConcurrentHashMap());
        }
        if ((blocks = this.storedCommandBlocks.get(chunkPos)).containsKey(position) && blocks.get(position).equals((Object)tag)) {
            return;
        }
        blocks.put(position, tag);
    }

    private Pair<Integer, Integer> getChunkCoords(Position position) {
        int chunkX = (int)Math.floor(position.getX() / 16L);
        int chunkZ = (int)Math.floor(position.getZ() / 16L);
        return new Pair<Integer, Integer>(chunkX, chunkZ);
    }

    public Optional<CompoundTag> getCommandBlock(Position position) {
        Pair<Integer, Integer> chunkCoords = this.getChunkCoords(position);
        Map<Position, CompoundTag> blocks = this.storedCommandBlocks.get(chunkCoords);
        if (blocks == null) {
            return Optional.absent();
        }
        CompoundTag tag = blocks.get(position);
        if (tag == null) {
            return Optional.absent();
        }
        tag = tag.clone();
        tag.put((Tag)new ByteTag("powered", 0));
        tag.put((Tag)new ByteTag("auto", 0));
        tag.put((Tag)new ByteTag("conditionMet", 0));
        return Optional.of((Object)tag);
    }

    public void unloadChunks() {
        this.storedCommandBlocks.clear();
    }

    public void setPermissions(boolean permissions) {
        this.permissions = permissions;
    }

    public boolean isPermissions() {
        return this.permissions;
    }
}

