/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.data.StoredObject;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.entities.Entity1_10Types;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.minecraft.metadata.Metadata;
import us.myles.ViaVersion.api.minecraft.metadata.types.MetaType1_9;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.version.Types1_9;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9To1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.chat.GameMode;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.metadata.MetadataRewriter;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.providers.BossBarProvider;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.providers.EntityIdProvider;

public class EntityTracker
extends StoredObject {
    private final Map<Integer, UUID> uuidMap = new ConcurrentHashMap<Integer, UUID>();
    private final Map<Integer, Entity1_10Types.EntityType> clientEntityTypes = new ConcurrentHashMap<Integer, Entity1_10Types.EntityType>();
    private final Map<Integer, List<Metadata>> metadataBuffer = new ConcurrentHashMap<Integer, List<Metadata>>();
    private final Map<Integer, Integer> vehicleMap = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, BossBar> bossBarMap = new ConcurrentHashMap<Integer, BossBar>();
    private final Set<Integer> validBlocking = Sets.newConcurrentHashSet();
    private final Set<Integer> knownHolograms = Sets.newConcurrentHashSet();
    private final Cache<Position, Integer> blockInteractions = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(250L, TimeUnit.MILLISECONDS).build();
    private boolean blocking = false;
    private boolean autoTeam = false;
    private int entityID = -1;
    private Position currentlyDigging = null;
    private boolean teamExists = false;
    private GameMode gameMode;
    private String currentTeam;

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public UUID getEntityUUID(int id) {
        UUID uuid = this.uuidMap.get(id);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.uuidMap.put(id, uuid);
        }
        return uuid;
    }

    public void setSecondHand(Item item) {
        this.setSecondHand(this.entityID, item);
    }

    public void setSecondHand(int entityID, Item item) {
        PacketWrapper wrapper = new PacketWrapper(60, null, this.getUser());
        wrapper.write(Type.VAR_INT, entityID);
        wrapper.write(Type.VAR_INT, 1);
        wrapper.write(Type.ITEM, item);
        try {
            wrapper.send(Protocol1_9To1_8.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeEntity(Integer entityID) {
        this.clientEntityTypes.remove(entityID);
        this.vehicleMap.remove(entityID);
        this.uuidMap.remove(entityID);
        this.validBlocking.remove(entityID);
        this.knownHolograms.remove(entityID);
        this.metadataBuffer.remove(entityID);
        BossBar bar = this.bossBarMap.remove(entityID);
        if (bar != null) {
            bar.hide();
            Via.getManager().getProviders().get(BossBarProvider.class).handleRemove(this.getUser(), bar.getId());
        }
    }

    public boolean interactedBlockRecently(int x, int y, int z) {
        if (this.blockInteractions.size() == 0L) {
            return false;
        }
        for (Position p : this.blockInteractions.asMap().keySet()) {
            if (p.getX() != (long)x || p.getY() != (long)y || p.getZ() != (long)z) continue;
            return true;
        }
        return false;
    }

    public void addBlockInteraction(Position p) {
        this.blockInteractions.put((Object)p, (Object)0);
    }

    public void handleMetadata(int entityID, List<Metadata> metadataList) {
        Entity1_10Types.EntityType type = this.clientEntityTypes.get(entityID);
        if (type == null) {
            return;
        }
        for (Metadata metadata : new ArrayList<Metadata>(metadataList)) {
            BossBar bar;
            if (type == Entity1_10Types.EntityType.WITHER && metadata.getId() == 10) {
                metadataList.remove(metadata);
            }
            if (type == Entity1_10Types.EntityType.ENDER_DRAGON && metadata.getId() == 11) {
                metadataList.remove(metadata);
            }
            if (type == Entity1_10Types.EntityType.SKELETON && this.getMetaByIndex(metadataList, 12) == null) {
                metadataList.add(new Metadata(12, MetaType1_9.Boolean, true));
            }
            if (type == Entity1_10Types.EntityType.HORSE && metadata.getId() == 16 && (Integer)metadata.getValue() == Integer.MIN_VALUE) {
                metadata.setValue(0);
            }
            if (type == Entity1_10Types.EntityType.PLAYER) {
                if (metadata.getId() == 0) {
                    byte data = (Byte)metadata.getValue();
                    if (entityID != this.getProvidedEntityId() && Via.getConfig().isShieldBlocking()) {
                        if ((data & 0x10) == 16) {
                            if (this.validBlocking.contains(entityID)) {
                                Item shield = new Item(442, 1, 0, null);
                                this.setSecondHand(entityID, shield);
                            } else {
                                this.setSecondHand(entityID, null);
                            }
                        } else {
                            this.setSecondHand(entityID, null);
                        }
                    }
                }
                if (metadata.getId() == 12 && Via.getConfig().isLeftHandedHandling()) {
                    metadataList.add(new Metadata(13, MetaType1_9.Byte, (byte)(((Byte)metadata.getValue() & 0x80) == 0 ? 1 : 0)));
                }
            }
            if (type == Entity1_10Types.EntityType.ARMOR_STAND && Via.getConfig().isHologramPatch() && metadata.getId() == 0 && this.getMetaByIndex(metadataList, 10) != null) {
                Metadata meta = this.getMetaByIndex(metadataList, 10);
                byte data = (Byte)metadata.getValue();
                if ((data & 0x20) == 32 && ((Byte)meta.getValue() & 1) == 1 && ((String)this.getMetaByIndex(metadataList, 2).getValue()).length() != 0 && ((Boolean)this.getMetaByIndex(metadataList, 3).getValue()).booleanValue() && !this.knownHolograms.contains(entityID)) {
                    this.knownHolograms.add(entityID);
                    try {
                        PacketWrapper wrapper = new PacketWrapper(37, null, this.getUser());
                        wrapper.write(Type.VAR_INT, entityID);
                        wrapper.write(Type.SHORT, (short)0);
                        wrapper.write(Type.SHORT, (short)(128.0 * (Via.getConfig().getHologramYOffset() * 32.0)));
                        wrapper.write(Type.SHORT, (short)0);
                        wrapper.write(Type.BOOLEAN, true);
                        wrapper.send(Protocol1_9To1_8.class, true, false);
                    }
                    catch (Exception wrapper) {
                        // empty catch block
                    }
                }
            }
            UUID uuid = this.getUser().get(ProtocolInfo.class).getUuid();
            if (!Via.getConfig().isBossbarPatch() || type != Entity1_10Types.EntityType.ENDER_DRAGON && type != Entity1_10Types.EntityType.WITHER) continue;
            if (metadata.getId() == 2) {
                bar = this.bossBarMap.get(entityID);
                String title = (String)metadata.getValue();
                String string = title.isEmpty() ? (type == Entity1_10Types.EntityType.ENDER_DRAGON ? "Ender Dragon" : "Wither") : (title = title);
                if (bar == null) {
                    bar = Via.getAPI().createBossBar(title, BossColor.PINK, BossStyle.SOLID);
                    this.bossBarMap.put(entityID, bar);
                    bar.addPlayer(uuid);
                    bar.show();
                    Via.getManager().getProviders().get(BossBarProvider.class).handleAdd(this.getUser(), bar.getId());
                    continue;
                }
                bar.setTitle(title);
                continue;
            }
            if (metadata.getId() != 6 || Via.getConfig().isBossbarAntiflicker()) continue;
            bar = this.bossBarMap.get(entityID);
            float maxHealth = type == Entity1_10Types.EntityType.ENDER_DRAGON ? 200.0f : 300.0f;
            float health = Math.max(0.0f, Math.min(((Float)metadata.getValue()).floatValue() / maxHealth, 1.0f));
            if (bar == null) {
                String title = type == Entity1_10Types.EntityType.ENDER_DRAGON ? "Ender Dragon" : "Wither";
                bar = Via.getAPI().createBossBar(title, health, BossColor.PINK, BossStyle.SOLID);
                this.bossBarMap.put(entityID, bar);
                bar.addPlayer(uuid);
                bar.show();
                Via.getManager().getProviders().get(BossBarProvider.class).handleAdd(this.getUser(), bar.getId());
                continue;
            }
            bar.setHealth(health);
        }
    }

    public Metadata getMetaByIndex(List<Metadata> list, int index) {
        for (Metadata meta : list) {
            if (index != meta.getId()) continue;
            return meta;
        }
        return null;
    }

    public void sendTeamPacket(boolean add, boolean now) {
        PacketWrapper wrapper = new PacketWrapper(65, null, this.getUser());
        wrapper.write(Type.STRING, "viaversion");
        if (add) {
            if (!this.teamExists) {
                wrapper.write(Type.BYTE, (byte)0);
                wrapper.write(Type.STRING, "viaversion");
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.BYTE, (byte)0);
                wrapper.write(Type.STRING, "");
                wrapper.write(Type.STRING, "never");
                wrapper.write(Type.BYTE, (byte)0);
            } else {
                wrapper.write(Type.BYTE, (byte)3);
            }
            wrapper.write(Type.STRING_ARRAY, new String[]{this.getUser().get(ProtocolInfo.class).getUsername()});
        } else {
            wrapper.write(Type.BYTE, (byte)1);
        }
        this.teamExists = add;
        try {
            wrapper.send(Protocol1_9To1_8.class, true, now);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMetadataToBuffer(int entityID, List<Metadata> metadataList) {
        List<Metadata> metadata = this.metadataBuffer.get(entityID);
        if (metadata != null) {
            metadata.addAll(metadataList);
        } else {
            this.metadataBuffer.put(entityID, metadataList);
        }
    }

    public void sendMetadataBuffer(int entityID) {
        List<Metadata> metadataList = this.metadataBuffer.get(entityID);
        if (metadataList != null) {
            PacketWrapper wrapper = new PacketWrapper(57, null, this.getUser());
            wrapper.write(Type.VAR_INT, entityID);
            wrapper.write(Types1_9.METADATA_LIST, metadataList);
            MetadataRewriter.transform(this.getClientEntityTypes().get(entityID), metadataList);
            this.handleMetadata(entityID, metadataList);
            if (metadataList.size() > 0) {
                try {
                    wrapper.send(Protocol1_9To1_8.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.metadataBuffer.remove(entityID);
        }
    }

    public int getProvidedEntityId() {
        try {
            return Via.getManager().getProviders().get(EntityIdProvider.class).getEntityId(this.getUser());
        }
        catch (Exception e) {
            return this.entityID;
        }
    }

    public Map<Integer, UUID> getUuidMap() {
        return this.uuidMap;
    }

    public Map<Integer, Entity1_10Types.EntityType> getClientEntityTypes() {
        return this.clientEntityTypes;
    }

    public Map<Integer, List<Metadata>> getMetadataBuffer() {
        return this.metadataBuffer;
    }

    public Map<Integer, Integer> getVehicleMap() {
        return this.vehicleMap;
    }

    public Map<Integer, BossBar> getBossBarMap() {
        return this.bossBarMap;
    }

    public Set<Integer> getValidBlocking() {
        return this.validBlocking;
    }

    public Set<Integer> getKnownHolograms() {
        return this.knownHolograms;
    }

    public Cache<Position, Integer> getBlockInteractions() {
        return this.blockInteractions;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isAutoTeam() {
        return this.autoTeam;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public Position getCurrentlyDigging() {
        return this.currentlyDigging;
    }

    public boolean isTeamExists() {
        return this.teamExists;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public String getCurrentTeam() {
        return this.currentTeam;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setAutoTeam(boolean autoTeam) {
        this.autoTeam = autoTeam;
    }

    public void setEntityID(int entityID) {
        this.entityID = entityID;
    }

    public void setCurrentlyDigging(Position currentlyDigging) {
        this.currentlyDigging = currentlyDigging;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public void setCurrentTeam(String currentTeam) {
        this.currentTeam = currentTeam;
    }
}

